/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeCommand;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBase;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.debug.DockerBeforeRunTaskUI;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DockerRunConfigurationUtils {
    DockerRunConfigurationUtils() {
    }

    @Nullable
    static SingletonDeploymentSourceType getDeploymentSourceType(@Nullable DeployToServerRunConfiguration<?, ?> runConfiguration) {
        return Optional.ofNullable(runConfiguration).map(DeployToServerRunConfiguration::getDeploymentSource).map(DeploymentSource::getType).map(o -> (SingletonDeploymentSourceType)ObjectUtils.tryCast((Object)o, SingletonDeploymentSourceType.class)).orElse(null);
    }

    @Nullable
    static Icon getRunConfigurationIcon(@Nullable DeployToServerRunConfiguration<?, ?> runConfiguration) {
        SingletonDeploymentSourceType sourceType = DockerRunConfigurationUtils.getDeploymentSourceType(runConfiguration);
        return sourceType == null ? null : sourceType.getSingletonSource().getIcon();
    }

    @NotNull
    static Map<String, DockerComposeCommand> parseServices(@NotNull DeployToServerRunConfiguration<?, ?> dockerRunConfig) {
        LinkedHashMap<String, DockerComposeCommand> linkedHashMap;
        SingletonDeploymentSourceType sourceType;
        if (dockerRunConfig == null) {
            DockerRunConfigurationUtils.$$$reportNull$$$0(0);
        }
        if ((sourceType = DockerRunConfigurationUtils.getDeploymentSourceType(dockerRunConfig)) != DockerComposeDeploymentSourceType.getInstance()) {
            Map<String, DockerComposeCommand> map = Collections.emptyMap();
            if (map == null) {
                DockerRunConfigurationUtils.$$$reportNull$$$0(1);
            }
            return map;
        }
        DockerDeploymentConfiguration deployment = (DockerDeploymentConfiguration)dockerRunConfig.getDeploymentConfiguration();
        File composeFile = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(dockerRunConfig.getProject(), deployment);
        if (composeFile == null || !composeFile.exists()) {
            Map<String, DockerComposeCommand> map = Collections.emptyMap();
            if (map == null) {
                DockerRunConfigurationUtils.$$$reportNull$$$0(2);
            }
            return map;
        }
        final LinkedHashMap<String, DockerComposeCommand> result = new LinkedHashMap<String, DockerComposeCommand>();
        try {
            String path = composeFile.getPath();
            DockerComposeConfigurationParserUtil.saveDockerComposeFiles(Collections.singletonList(path));
            DockerComposeConfiguration bean = DockerComposeConfigurationParser.newPureInstance().parseBean(path);
            bean.accept(new DockerComposeConfiguration.Visitor<Void>(){

                @Override
                public Void visit(@NotNull DockerComposeConfigurationV1 composeV1) {
                    if (composeV1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.collectServices(composeV1.getServices());
                    return null;
                }

                @Override
                public Void visit(@NotNull DockerComposeConfigurationV2 composeV2) {
                    if (composeV2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.collectServices(composeV2.getServices());
                    return null;
                }

                private void collectServices(Map<String, ? extends DockerComposeServiceBase> services) {
                    for (Map.Entry<String, ? extends DockerComposeServiceBase> entry : services.entrySet()) {
                        String name = entry.getKey();
                        DockerComposeCommand command = Optional.ofNullable(entry.getValue()).map(DockerComposeServiceBase::getCommand).orElse(null);
                        result.put(name, command);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "composeV1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "composeV2";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/docker/debug/DockerRunConfigurationUtils$1";
                    objectArray[2] = "visit";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            linkedHashMap = result;
        }
        catch (IOException e) {
            DockerBeforeRunTaskUI.LOG.debug((Throwable)e);
            Map<String, DockerComposeCommand> map = Collections.emptyMap();
            if (map == null) {
                DockerRunConfigurationUtils.$$$reportNull$$$0(4);
            }
            return map;
        }
        if (linkedHashMap == null) {
            DockerRunConfigurationUtils.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRunConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/debug/DockerRunConfigurationUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/debug/DockerRunConfigurationUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseServices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseServices";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

