/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.debug.DockerBeforeRunTask;
import com.intellij.docker.debug.DockerBeforeRunTaskLauncherBase;
import com.intellij.docker.remoteDebug.RemotePortRequest;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class DockerBeforeRunComposeLauncher
extends DockerBeforeRunTaskLauncherBase {
    private final DockerBeforeRunTask.TargetComposeRunConfig myTargetRunConfig;

    public DockerBeforeRunComposeLauncher(@NotNull ExecutionEnvironment environment, @NotNull DockerBeforeRunTask task, @NotNull DockerBeforeRunTask.TargetComposeRunConfig targetRunConfig) {
        if (environment == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(0);
        }
        if (task == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(1);
        }
        if (targetRunConfig == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(2);
        }
        super(environment, task);
        this.myTargetRunConfig = targetRunConfig;
    }

    @Override
    protected void validateBeforeRunTask() throws RuntimeConfigurationException {
        if (StringUtil.isEmpty((String)this.myTargetRunConfig.getServiceName())) {
            throw new RuntimeConfigurationException("Target service name is required");
        }
    }

    @Override
    protected void adjustDeployment(@NotNull DockerDeploymentConfiguration deployment) throws IOException {
        if (deployment == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(3);
        }
        String targetServiceName = this.myTargetRunConfig.getServiceName();
        assert (!StringUtil.isEmptyOrSpaces((String)targetServiceName));
        if (!deployment.getServices().isEmpty() && !deployment.getServices().contains(targetServiceName)) {
            deployment.getServices().add(targetServiceName);
        }
        DockerBeforeRunTask task = this.getBeforeRunTask();
        RemotePortRequest portRequest = task.getRequest().findMainDebugPortRequest();
        assert (portRequest != null);
        DockerComposePort composePortMapping = new DockerComposePort(null, portRequest.getLocalPort(), portRequest.getEffectiveRemotePort());
        File composeFile = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(this.getProject(), deployment);
        assert (composeFile != null);
        DockerComposeConfigurationBuilder<?, ?, ?> builder = ServiceCmdExecUtils.createConfigurationBuilder(composeFile.toPath(), new ArrayList<String>());
        builder.addService(targetServiceName).withPorts(Collections.singletonList(composePortMapping)).withCommandLine(StringUtil.nullize((String)task.getAdjustedCommand(this.getHostDebugRunConfiguration())));
        File overrideYml = ServiceCmdExecUtils.writeDockerComposeOverrideYml(builder.build());
        deployment.getSecondarySourceFiles().add(overrideYml.toPath().toString());
    }

    @Override
    @NotNull
    protected Condition<Deployment> getDeploymentMatcher(@NotNull String deploymentName) {
        if (deploymentName == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(4);
        }
        Condition<Deployment> condition = DockerBeforeRunComposeLauncher.matchByComposeDeploymentNameAndService(deploymentName, this.myTargetRunConfig.getServiceName());
        if (condition == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(5);
        }
        return condition;
    }

    private static Condition<Deployment> matchByComposeDeploymentNameAndService(@NotNull String composeDeploymentName, @NotNull String serviceName) {
        if (composeDeploymentName == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(6);
        }
        if (serviceName == null) {
            DockerBeforeRunComposeLauncher.$$$reportNull$$$0(7);
        }
        return deployment -> {
            DeploymentRuntime parentRuntime = deployment.getParentRuntime();
            String actualServiceName = Optional.ofNullable(parentRuntime).map(o -> (ComposeServiceRuntime)ObjectUtils.tryCast((Object)o, ComposeServiceRuntime.class)).map(ComposeServiceRuntime::getServiceName).orElse(null);
            return serviceName.equals(actualServiceName) && parentRuntime.getParent() instanceof ComposeDeploymentRuntime;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRunConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/debug/DockerBeforeRunComposeLauncher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeDeploymentName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunComposeLauncher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustDeployment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentMatcher";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchByComposeDeploymentNameAndService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

