/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.PullImageConfigurable;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullImageAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        ServersTreeNode node;
        if (e == null) {
            PullImageAction.$$$reportNull$$$0(0);
        }
        if ((node = (ServersTreeNode)ServiceViewActionUtils.getTarget((AnActionEvent)e, ServersTreeNode.class)) instanceof ServersTreeStructure.RemoteServerNode) {
            ServersTreeStructure.RemoteServerNode remoteServerNode = (ServersTreeStructure.RemoteServerNode)node;
            boolean visible = remoteServerNode.getServer().getType() == DockerCloudType.getInstance();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && remoteServerNode.isConnected());
            return;
        }
        e.getPresentation().setEnabledAndVisible(PullImageAction.isImagesGroup(node) && PullImageAction.getRemoteServer(node) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ServerConnection connection;
        Project project;
        if (e == null) {
            PullImageAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        final ServersTreeNodeSelector selector = DockerActionUtils.getSelector(e);
        if (selector == null) {
            return;
        }
        ServersTreeNode node = (ServersTreeNode)ServiceViewActionUtils.getTarget((AnActionEvent)e, ServersTreeNode.class);
        RemoteServer<?> remoteServer = PullImageAction.getRemoteServer(node);
        ServerConnection serverConnection = connection = remoteServer == null ? null : ServerConnectionManager.getInstance().getConnection(remoteServer);
        if (connection == null) {
            return;
        }
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                PullImageAction.doPullImage(project, (DockerServerRuntimeInstance)serverRuntimeInstance, (ParameterizedRunnable<String>)new ImageSelectionCase(connection, selector));
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/action/PullImageAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void doPullImage(Project project, DockerServerRuntimeInstance serverRuntime, ParameterizedRunnable<String> onSuccess) {
        DockerRepositoryModel model = new DockerRepositoryModel();
        if (!ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PullImageConfigurable(model))) {
            return;
        }
        serverRuntime.pullImage(project, model, onSuccess);
    }

    private static boolean isImagesGroup(ServersTreeNode node) {
        return node instanceof ServersTreeStructure.DeploymentNodeImpl && PullImageAction.isImagesGroup(((ServersTreeStructure.DeploymentNodeImpl)node).getDeployment().getRuntime());
    }

    private static boolean isImagesGroup(@Nullable DeploymentRuntime deploymentRuntime) {
        return deploymentRuntime instanceof DockerGroupRuntime.ImagesGroup;
    }

    private static RemoteServer<?> getRemoteServer(@Nullable ServersTreeNode node) {
        if (node instanceof ServersTreeStructure.DeploymentNodeImpl) {
            node = ((ServersTreeStructure.DeploymentNodeImpl)node).getServerNode();
        }
        return node instanceof ServersTreeStructure.RemoteServerNode ? ((ServersTreeStructure.RemoteServerNode)node).getServer() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/docker/action/PullImageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ImageSelectionCase
    implements ParameterizedRunnable<String> {
        private final ServerConnection<?> myConnection;
        private final ServersTreeNodeSelector mySelector;

        ImageSelectionCase(ServerConnection<?> connection, ServersTreeNodeSelector selector) {
            this.myConnection = connection;
            this.mySelector = selector;
        }

        public void run(String imageRepoTag) {
            Semaphore semaphore = new Semaphore();
            semaphore.down();
            this.myConnection.computeDeployments(() -> {
                semaphore.up();
                for (Deployment deployment : this.myConnection.getDeployments()) {
                    Set<String> repoTags;
                    DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)deployment.getRuntime();
                    if (applicationRuntime == null || (repoTags = applicationRuntime.getImageRepoTags()) == null || !repoTags.contains(imageRepoTag)) continue;
                    UIUtil.invokeLaterIfNeeded(() -> this.mySelector.select(this.myConnection, deployment.getName()));
                    break;
                }
            });
            semaphore.waitFor();
        }
    }
}

