/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.ContainerActionBase;
import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.exec.ExecCommand;
import com.intellij.docker.exec.ExecCommandManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecInContainerAction
extends ContainerActionBase {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DockerActionUtils.LoggingActionHelper helper;
        if (e == null) {
            ExecInContainerAction.$$$reportNull$$$0(0);
        }
        if ((helper = DockerActionUtils.getLoggingActionHelper(e)) == null) {
            return;
        }
        ListPopup popup = new Case(helper).createPopup();
        popup.showInBestPositionFor(e.getDataContext());
    }

    @Override
    protected boolean isEnabled(DeploymentNode node) {
        Deployment deployment = ApplicationActionUtils.getDeployment((DeploymentNode)node);
        return deployment != null && deployment.getStatus() == DeploymentStatus.DEPLOYED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/action/ExecInContainerAction", "actionPerformed"));
    }

    private static class Case {
        private final DockerActionUtils.LoggingActionHelper myHelper;

        Case(DockerActionUtils.LoggingActionHelper helper) {
            this.myHelper = helper;
        }

        public ListPopup createPopup() {
            ArrayList<ExecCommand> list = new ArrayList<ExecCommand>(ExecCommandManager.getInstance(this.myHelper.project).getImageCommands(this.myHelper.applicationRuntime.getImageId()));
            list.add(null);
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ExecCommand>("Run command in container", list){

                public Icon getIconFor(ExecCommand value) {
                    return null;
                }

                @NotNull
                public String getTextFor(ExecCommand value) {
                    String string = value != null ? value.getCommand() : "Create...";
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(ExecCommand selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> this.createAndRunExecSession(selectedValue));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/action/ExecInContainerAction$Case$1", "getTextFor"));
                }
            });
        }

        private void createAndRunExecSession(@Nullable ExecCommand storedExecCommand) {
            String command;
            if (storedExecCommand == null) {
                command = Messages.showInputDialog((Project)this.myHelper.project, (String)"Command:", (String)"Exec", null);
                if (command == null) {
                    return;
                }
                ExecCommandManager.getInstance(this.myHelper.project).addCommand(this.myHelper.applicationRuntime.getImageId(), command);
            } else {
                command = storedExecCommand.getCommand();
            }
            String logName = "Exec: " + command;
            Runnable onDone = this.myHelper.createLogSelector(logName);
            this.myHelper.applicationRuntime.exec(this.myHelper.project, command, logName, onDone);
        }
    }
}

