/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.IconUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002\u001a,\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u001a\u001c\u0010\u0013\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018\u001a&\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!\u001a$\u0010\"\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0016\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006)"}, d2={"invalidChar", "Lkotlin/text/Regex;", "getInvalidChar", "()Lkotlin/text/Regex;", "addConsoleViewContentTypes", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addEditorStyles", "defaultSelector", "", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "fontMetrics", "Ljava/awt/FontMetrics;", "addSettings", "settings", "Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "attributesToCss", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "colorToCss", "c", "Ljava/awt/Color;", "convertIDEStylesToCss", "fontTypeToCss", "fontType", "", "getLineHeight", "", "getSelectorName", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "setDisplay", "selector", "value", "", "textAttributesToCss", "selectorName", "textAttributesToInlineCss", "intellij.javascript.debugger"})
public final class StylesConversionKt {
    @NotNull
    private static final Regex invalidChar = new Regex("[~!@$%^&*()+=,./';:\"?><\\[\\]{}|`#\\\\]");

    @NotNull
    public static final Regex getInvalidChar() {
        return invalidChar;
    }

    @NotNull
    public static final String getSelectorName(@NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        StringBuilder stringBuilder = new StringBuilder().append("_");
        String string = contentType.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentType.toString()");
        CharSequence charSequence = string;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl = false;
        String string2 = charSequence;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        charSequence = string4;
        Regex regex = invalidChar;
        String string5 = "_";
        boolean bl2 = false;
        string4 = regex.replace(charSequence, string5);
        return stringBuilder2.append(string4).toString();
    }

    @NotNull
    public static final String convertIDEStylesToCss(@NotNull String defaultSelector, @NotNull EditorColorsScheme scheme, @NotNull FontMetrics fontMetrics, @NotNull WebConsoleViewSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)defaultSelector, (String)"defaultSelector");
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        Intrinsics.checkParameterIsNotNull((Object)fontMetrics, (String)"fontMetrics");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        StringBuilder sb = new StringBuilder();
        StylesConversionKt.addConsoleViewContentTypes(sb);
        StylesConversionKt.addEditorStyles(defaultSelector, scheme, sb, fontMetrics);
        StylesConversionKt.addSettings(settings, sb);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public static final void addSettings(@NotNull WebConsoleViewSettings settings, @NotNull StringBuilder sb) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
        StylesConversionKt.setDisplay(sb, "level-error", settings.getShowErrors());
        StylesConversionKt.setDisplay(sb, "level-warning", settings.getShowWarnings());
        StylesConversionKt.setDisplay(sb, "level-info", settings.getShowInfo());
        StylesConversionKt.setDisplay(sb, "level-log", settings.getShowLog());
        StylesConversionKt.setDisplay(sb, "level-debug", settings.getShowDebug());
        StylesConversionKt.setDisplay(sb, "source-network", settings.getShowNetwork());
    }

    private static final void setDisplay(StringBuilder sb, String selector, boolean value) {
        sb.append('.' + selector + " { ");
        sb.append("display: " + (value ? "block" : "none") + ';');
        sb.append("} ");
    }

    private static final void addEditorStyles(String defaultSelector, EditorColorsScheme scheme, StringBuilder sb, FontMetrics fontMetrics) {
        sb.append('.' + defaultSelector + " { ");
        sb.append(" font-family: " + scheme.getConsoleFontName() + ';');
        StringBuilder stringBuilder = new StringBuilder().append(" font-size: ");
        Font font = fontMetrics.getFont();
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"fontMetrics.font");
        sb.append(stringBuilder.append(font.getSize()).append("px;").toString());
        sb.append(" line-height: " + StylesConversionKt.getLineHeight(fontMetrics, scheme) + "px;");
        sb.append(" min-height: " + StylesConversionKt.getLineHeight(fontMetrics, scheme) + "px;");
        sb.append(" } ");
        sb.append(" body { ");
        StringBuilder stringBuilder2 = new StringBuilder().append("   background-color: ");
        Color color = scheme.getDefaultBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"scheme.defaultBackground");
        sb.append(stringBuilder2.append(StylesConversionKt.colorToCss(color)).append(';').toString());
        sb.append(" } ");
        Icon promptIcon = AllIcons.Debugger.PromptInput;
        Icon icon = IconUtil.scaleByFont((Icon)promptIcon, null, (float)fontMetrics.getAscent());
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"IconUtil.scaleByFont(pro\u2026Metrics.ascent.toFloat())");
        Icon scaledIcon = icon;
        sb.append(".icon {");
        sb.append(" background-size: " + scaledIcon.getIconWidth() + "px " + scaledIcon.getIconHeight() + "px;");
        sb.append(" width: " + scaledIcon.getIconWidth() + "px;");
        sb.append(" height: " + scaledIcon.getIconHeight() + "px;");
        sb.append(" } ");
    }

    private static final float getLineHeight(FontMetrics fontMetrics, EditorColorsScheme scheme) {
        return (float)fontMetrics.getHeight() * scheme.getConsoleLineSpacing();
    }

    private static final void addConsoleViewContentTypes(StringBuilder sb) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        String string = StylesConversionKt.getSelectorName(consoleViewContentType);
        ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
        TextAttributes textAttributes = consoleViewContentType2.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"NORMAL_OUTPUT.attributes");
        sb.append(StylesConversionKt.textAttributesToCss(string, textAttributes));
        ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.LOG_ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType3, (String)"LOG_ERROR_OUTPUT");
        String string2 = StylesConversionKt.getSelectorName(consoleViewContentType3);
        ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.LOG_ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType4, (String)"LOG_ERROR_OUTPUT");
        TextAttributes textAttributes2 = consoleViewContentType4.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes2, (String)"LOG_ERROR_OUTPUT.attributes");
        sb.append(StylesConversionKt.textAttributesToCss(string2, textAttributes2));
        ConsoleViewContentType consoleViewContentType5 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType5, (String)"LOG_WARNING_OUTPUT");
        String string3 = StylesConversionKt.getSelectorName(consoleViewContentType5);
        ConsoleViewContentType consoleViewContentType6 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType6, (String)"LOG_WARNING_OUTPUT");
        TextAttributes textAttributes3 = consoleViewContentType6.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes3, (String)"LOG_WARNING_OUTPUT.attributes");
        sb.append(StylesConversionKt.textAttributesToCss(string3, textAttributes3));
        ConsoleViewContentType consoleViewContentType7 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType7, (String)"LOG_DEBUG_OUTPUT");
        String string4 = StylesConversionKt.getSelectorName(consoleViewContentType7);
        ConsoleViewContentType consoleViewContentType8 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType8, (String)"LOG_DEBUG_OUTPUT");
        TextAttributes textAttributes4 = consoleViewContentType8.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes4, (String)"LOG_DEBUG_OUTPUT.attributes");
        sb.append(StylesConversionKt.textAttributesToCss(string4, textAttributes4));
        ConsoleViewContentType consoleViewContentType9 = ConsoleViewContentType.LOG_INFO_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType9, (String)"LOG_INFO_OUTPUT");
        String string5 = StylesConversionKt.getSelectorName(consoleViewContentType9);
        ConsoleViewContentType consoleViewContentType10 = ConsoleViewContentType.LOG_INFO_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType10, (String)"LOG_INFO_OUTPUT");
        TextAttributes textAttributes5 = consoleViewContentType10.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes5, (String)"LOG_INFO_OUTPUT.attributes");
        sb.append(StylesConversionKt.textAttributesToCss(string5, textAttributes5));
        ConsoleViewContentType consoleViewContentType11 = ConsoleViewContentType.USER_INPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType11, (String)"USER_INPUT");
        String string6 = StylesConversionKt.getSelectorName(consoleViewContentType11);
        ConsoleViewContentType consoleViewContentType12 = ConsoleViewContentType.USER_INPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType12, (String)"USER_INPUT");
        TextAttributes textAttributes6 = consoleViewContentType12.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes6, (String)"USER_INPUT.attributes");
        sb.append(StylesConversionKt.textAttributesToCss(string6, textAttributes6));
        ConsoleViewContentType consoleViewContentType13 = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType13, (String)"SYSTEM_OUTPUT");
        String string7 = StylesConversionKt.getSelectorName(consoleViewContentType13);
        ConsoleViewContentType consoleViewContentType14 = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType14, (String)"SYSTEM_OUTPUT");
        TextAttributes textAttributes7 = consoleViewContentType14.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes7, (String)"SYSTEM_OUTPUT.attributes");
        sb.append(StylesConversionKt.textAttributesToCss(string7, textAttributes7));
        Collection collection = ConsoleViewContentType.getRegisteredTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"getRegisteredTypes()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsoleViewContentType it = (ConsoleViewContentType)element$iv;
            boolean bl = false;
            ConsoleViewContentType consoleViewContentType15 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType15, (String)"it");
            String string8 = StylesConversionKt.getSelectorName(consoleViewContentType15);
            TextAttributes textAttributes8 = it.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes8, (String)"it.attributes");
            sb.append(StylesConversionKt.textAttributesToCss(string8, textAttributes8));
        }
    }

    @NotNull
    public static final String textAttributesToCss(@NotNull String selectorName, @NotNull TextAttributes attr) {
        Intrinsics.checkParameterIsNotNull((Object)selectorName, (String)"selectorName");
        Intrinsics.checkParameterIsNotNull((Object)attr, (String)"attr");
        StringBuilder sb = new StringBuilder();
        sb.append('.' + selectorName + " { ");
        StylesConversionKt.attributesToCss(sb, attr);
        sb.append(" } ");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String textAttributesToInlineCss(@NotNull TextAttributes attr) {
        Intrinsics.checkParameterIsNotNull((Object)attr, (String)"attr");
        StringBuilder sb = new StringBuilder();
        StylesConversionKt.attributesToCss(sb, attr);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final void attributesToCss(StringBuilder sb, TextAttributes attr) {
        Color it;
        boolean bl;
        boolean bl2;
        Color color;
        Color color2 = attr.getForegroundColor();
        if (color2 != null) {
            color = color2;
            bl2 = false;
            bl = false;
            it = color;
            boolean bl3 = false;
            sb.append(" color: " + StylesConversionKt.colorToCss(it) + ';');
        }
        Color color3 = attr.getBackgroundColor();
        if (color3 != null) {
            color = color3;
            bl2 = false;
            bl = false;
            it = color;
            boolean bl4 = false;
            sb.append(" background-color: " + StylesConversionKt.colorToCss(it) + ';');
        }
        int n = attr.getFontType();
        bl2 = false;
        bl = false;
        int it2 = n;
        boolean bl5 = false;
        sb.append(' ' + StylesConversionKt.fontTypeToCss(it2) + ';');
    }

    @NotNull
    public static final String colorToCss(@NotNull Color c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        return "rgba(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ')';
    }

    @NotNull
    public static final String fontTypeToCss(int fontType) {
        String string;
        switch (fontType) {
            case 0: {
                string = "font-weight: normal";
                break;
            }
            case 1: {
                string = "font-weight: bold";
                break;
            }
            case 2: {
                string = "font-style: italic";
                break;
            }
            case 3: {
                string = "font-weight: bold; font-style: italic";
                break;
            }
            default: {
                string = "font-weight: normal";
            }
        }
        return string;
    }
}

