/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli;

import com.intellij.docker.agent.cli.CliParserBase;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.cli.Option;

public abstract class DockerBuildCliParserBase<CMD>
extends CliParserBase<CMD> {
    @Override
    public List<CliParserBase.OptionHandler<CMD>> createAllHandlers() {
        LinkedList<CliParserBase.OptionHandler<CMD>> result = new LinkedList<CliParserBase.OptionHandler<CMD>>();
        result.add(this.buildArgs(DockerBuildCliParserBase.buildArgsOption()));
        result.add(this.cacheFrom(DockerBuildCliParserBase.builder13().longOpt("cache-from").hasArg().build()));
        result.add(this.cpuShares(DockerBuildCliParserBase.builder13("c").longOpt("cpu-shares").hasArg().build()));
        result.add(this.cpusetCpus(DockerBuildCliParserBase.builder13().longOpt("cpuset-cpus").hasArg().build()));
        result.add(this.forceRm(DockerBuildCliParserBase.builder13().longOpt("force-rm").hasArg().optionalArg(true).build()));
        result.add(this.label(DockerBuildCliParserBase.builder13().longOpt("label").hasArg().build()));
        result.add(this.memory(DockerBuildCliParserBase.builder13("m").longOpt("memory").hasArg().build()));
        result.add(this.memorySwap(DockerBuildCliParserBase.builder13().longOpt("memory-swap").hasArg().build()));
        result.add(this.shmSize(DockerBuildCliParserBase.builder13().longOpt("shm-size").hasArg().build()));
        result.add(this.network(DockerBuildCliParserBase.builder13().longOpt("network").hasArg().build()));
        result.add(this.noCache(DockerBuildCliParserBase.builder13().longOpt("no-cache").hasArg().optionalArg(true).build()));
        result.add(this.pull(DockerBuildCliParserBase.builder13().longOpt("pull").hasArg().optionalArg(true).build()));
        result.add(this.quiet(DockerBuildCliParserBase.builder13("q").longOpt("quiet").hasArg().optionalArg(true).build()));
        result.add(this.rm(DockerBuildCliParserBase.builder13().longOpt("rm").hasArg().optionalArg(true).build()));
        return result;
    }

    public static Option buildArgsOption() {
        return DockerBuildCliParserBase.builder13().longOpt("build-arg").hasArg().build();
    }

    protected abstract CliParserBase.LabelListHandler<CMD> buildArgs(Option var1);

    protected abstract CommaSeparatedListHandler<CMD> cacheFrom(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cpuShares(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cpusetCpus(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> forceRm(Option var1);

    protected abstract CliParserBase.LabelListHandler<CMD> label(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memory(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memorySwap(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> shmSize(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> network(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> noCache(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> pull(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> quiet(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> rm(Option var1);

    protected static class CommaSeparatedListHandler<CMD>
    extends CliParserBase.StringListHandler<CMD> {
        public CommaSeparatedListHandler(Option option, BiConsumer<CMD, String[]> setter) {
            super(option, setter);
        }

        @Override
        protected void handleValueList(String[] values) {
            LinkedList<String> pieces = new LinkedList<String>();
            if (values != null) {
                for (String next : values) {
                    for (String nextPiece : next.split(",")) {
                        if (nextPiece.isEmpty()) continue;
                        pieces.add(nextPiece);
                    }
                }
            }
            super.handleValueList(pieces.toArray(new String[0]));
        }
    }
}

