/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.CapturingRemoteProcessHandler;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyRemoteProcessStarterManagerUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteInterpreterUtil {
    private static final Logger LOG = Logger.getInstance((String)PyRemoteInterpreterUtil.class.getName());
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";

    @Nullable
    public static String getInterpreterVersion(@Nullable Project project, final @NotNull PyRemoteSdkAdditionalData data, final boolean nullForUnparsableVersion) throws RemoteSdkException {
        PythonRemoteInterpreterManager instance;
        if (data == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(0);
        }
        if ((instance = PythonRemoteInterpreterManager.getInstance()) == null) {
            throw new RemoteSdkException("PythonRemoteInterpreterManager not found");
        }
        final Ref result = Ref.create(null);
        final Ref exception = Ref.create(null);
        Task.Modal task = new Task.Modal(project, "Getting Remote Interpreter Version", true){

            public void run(@NotNull ProgressIndicator indicator) {
                PythonSdkFlavor flavor;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((flavor = data.getFlavor()) != null) {
                    try {
                        try {
                            String version;
                            String[] command = new String[]{data.getInterpreterPath(), flavor.getVersionOption()};
                            ProcessOutput processOutput = PyRemoteProcessStarterManagerUtil.getManager((PyRemoteSdkAdditionalDataBase)data).executeRemoteProcess(this.myProject, command, null, (PyRemoteSdkAdditionalDataBase)data, new PyRemotePathMapper());
                            if (processOutput.getExitCode() == 0 && ((version = flavor.getVersionStringFromOutput(processOutput)) != null || nullForUnparsableVersion)) {
                                result.set((Object)version);
                                return;
                            }
                            exception.set((Object)PyRemoteInterpreterUtil.createException(processOutput, command));
                        }
                        catch (Exception e) {
                            throw RemoteSdkException.cantObtainRemoteCredentials((Throwable)e);
                        }
                    }
                    catch (RemoteSdkException e) {
                        exception.set((Object)e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/remote/PyRemoteInterpreterUtil$1", "run"));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!exception.isNull()) {
            throw (RemoteSdkException)((Object)exception.get());
        }
        return (String)result.get();
    }

    @NotNull
    private static RemoteSdkException createException(@NotNull ProcessOutput processOutput, @NotNull String[] command) {
        if (processOutput == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(1);
        }
        if (command == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(2);
        }
        RemoteSdkException remoteSdkException = RemoteSdkException.cantObtainRemoteCredentials((Throwable)new PyExecutionException("Can't obtain python version", command[0], (List)Lists.newArrayList((Object[])command), processOutput));
        if (remoteSdkException == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(3);
        }
        return remoteSdkException;
    }

    @NotNull
    public static Pair<String, Integer> obtainRemoteSocket(@NotNull ConnectionBuilder connectionBuilder, @NotNull String interpreterPath) throws RemoteSdkException {
        ProcessOutput output;
        block7: {
            if (connectionBuilder == null) {
                PyRemoteInterpreterUtil.$$$reportNull$$$0(4);
            }
            if (interpreterPath == null) {
                PyRemoteInterpreterUtil.$$$reportNull$$$0(5);
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreterPath, "-c", "import socket; s = socket.socket(socket.AF_INET, socket.SOCK_STREAM); s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1); s.bind(('', 0)); print(s.getsockname()); s.close()"});
            SshExecProcess process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(false).start();
            CapturingRemoteProcessHandler processHandler = new CapturingRemoteProcessHandler((SshProcess)process, null, commandLine.getCommandLineString());
            output = processHandler.runProcess();
            Pair<String, Integer> socketName = PyRemoteInterpreterUtil.getSocketName(output.getStdout().trim());
            if (socketName == null) break block7;
            Pair<String, Integer> pair = socketName;
            if (pair == null) {
                PyRemoteInterpreterUtil.$$$reportNull$$$0(6);
            }
            return pair;
        }
        try {
            throw new RemoteSdkException("Couldn't obtain remote socket from output " + output.getStdout() + ", stderr " + output.getStderr());
        }
        catch (RemoteSdkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteSdkException("Error obtaining remote socket:" + e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    static Pair<String, Integer> getSocketName(@NotNull String str) {
        if (str == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(7);
        }
        if (str.length() > 1) {
            String[] parts = (str = str.substring(1, str.length() - 1)).split(",");
            return parts.length == 2 ? Pair.create((Object)PyRemoteInterpreterUtil.unquote(parts[0].trim()), (Object)Integer.parseInt(parts[1].trim())) : null;
        }
        return null;
    }

    @NotNull
    private static String unquote(@NotNull String s) {
        if (s == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(8);
        }
        if (s.length() > 2) {
            if (s.startsWith(SINGLE_QUOTE) && s.endsWith(SINGLE_QUOTE)) {
                String string = s.substring(1, s.length() - 1);
                if (string == null) {
                    PyRemoteInterpreterUtil.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (s.startsWith(DOUBLE_QUOTE) && s.endsWith(DOUBLE_QUOTE)) {
                String string = s.substring(1, s.length() - 1);
                if (string == null) {
                    PyRemoteInterpreterUtil.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        String string = s;
        if (string == null) {
            PyRemoteInterpreterUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteInterpreterUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteInterpreterUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createException";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainRemoteSocket";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createException";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "obtainRemoteSocket";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSocketName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

