/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.python.Result;
import com.jetbrains.python.remote.PyDeploymentUtil;
import com.jetbrains.python.remote.PyServerBasedRemoteProjectSynchronizer;
import com.jetbrains.python.remote.PySshProjectSynchronizerHelpers;
import com.jetbrains.python.remote.PySyncCheckCreateIfPossible;
import com.jetbrains.python.remote.PySyncCheckOnly;
import com.jetbrains.python.remote.PySyncCheckStrategy;
import com.jetbrains.python.remote.PySyncDirection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PyDeploymentBasedProjectSynchronizer
extends PyServerBasedRemoteProjectSynchronizer {
    private static final Logger LOG = Logger.getInstance(PyDeploymentBasedProjectSynchronizer.class);
    @NotNull
    protected final String myServerId;
    @NotNull
    protected final String myServerName;

    PyDeploymentBasedProjectSynchronizer(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(0);
        }
        super(sdk);
        this.myServerId = WebServerConfig.getNextId();
        this.myServerName = this.myAdditionalData.getSdkId();
    }

    PyDeploymentBasedProjectSynchronizer(@NotNull Sdk sdk, @NotNull String serverId, @NotNull String serverName) {
        if (sdk == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(1);
        }
        if (serverId == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(2);
        }
        if (serverName == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(3);
        }
        super(sdk);
        this.myServerId = serverId;
        this.myServerName = serverName;
    }

    protected boolean isMappingExist(@NotNull Project project) {
        if (project == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(4);
        }
        String projectBasePath = project.getBasePath();
        assert (projectBasePath != null) : "Project is not default, base path can't be null";
        List<PathMappingSettings.PathMapping> mappings = this.getPathMappingsIgnoreError(project);
        if (mappings == null) {
            return false;
        }
        return mappings.stream().anyMatch(pathMapping -> pathMapping.canReplaceLocal(projectBasePath));
    }

    @Override
    public final String getDefaultRemotePath() {
        return "/tmp/pycharm_project_" + Math.round(Math.random() * 1000.0);
    }

    @Nullable
    public Result<List<PathMappingSettings.PathMapping>, String> getAutoMappings() {
        return null;
    }

    @NotNull
    protected Deployable createDeployable() throws ExecutionException, InterruptedException {
        Deployable deployable = PyDeploymentUtil.createDeployableUsingCredentials((RemoteCredentials)this.getCredentials(), this.myServerId, this.myServerName);
        if (deployable == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(5);
        }
        return deployable;
    }

    @Override
    @Nullable
    protected final Result<List<PathMappingSettings.PathMapping>, String> getPathMappings(@NotNull Project project) {
        List<PathMappingSettings.PathMapping> mappingsForServer;
        if (project == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(6);
        }
        return (mappingsForServer = PyDeploymentUtil.getPythonPathMappingsForServer(project, this.myServerId)) != null ? new Result.Success(mappingsForServer) : null;
    }

    public void syncProject(@NotNull Module module, @NotNull PySyncDirection syncDirection, @Nullable Consumer<Boolean> callback2, String ... fileNames) {
        Consumer<Boolean> notNullCallback;
        if (module == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(7);
        }
        if (syncDirection == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(8);
        }
        if (fileNames == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(9);
        }
        Project project = module.getProject();
        Consumer<Boolean> consumer = notNullCallback = callback2 != null ? callback2 : ignore -> {};
        if (!PyDeploymentUtil.isDeploymentExist(project, this.myAdditionalData)) {
            notNullCallback.accept(false);
            return;
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile[] baseDirArr = new VirtualFile[]{baseDir};
        if (syncDirection == PySyncDirection.LOCAL_TO_REMOTE) {
            PyDeploymentUtil.uploadProjectFilesToDefaultServer(project, baseDir, fileNames, notNullCallback);
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                RemoteConnectionManager manager = RemoteConnectionManager.getInstance();
                if (manager == null) {
                    return;
                }
                Deployable deployable = null;
                RemoteConnection connection = null;
                FileObject[] remoteFiles = null;
                VirtualFile[] localFiles = baseDirArr;
                try {
                    deployable = this.createDeployable();
                    connection = manager.openConnection(ConnectionOwnerFactory.createConnectionOwner((Project)project), "Getting list of created files", (Connectable)deployable, FileTransferConfig.Origin.Default, null, null);
                    if (connection != null && fileNames.length > 0) {
                        remoteFiles = PyDeploymentUtil.resolveRemoteFiles(connection, fileNames);
                        localFiles = null;
                    }
                }
                catch (ExecutionException | InterruptedException | FileSystemException e) {
                    LOG.warn("Failed to get remote fs", e);
                }
                if (deployable == null) {
                    return;
                }
                PyDeploymentUtil.downloadProjectFiles(project, notNullCallback, deployable, connection, remoteFiles, localFiles);
            });
        }
    }

    @Nullable
    public String checkSynchronizationAvailable(@NotNull PySyncCheckStrategy syncCheckStrategy) {
        String deploymentCreationError;
        if (syncCheckStrategy == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(10);
        }
        if (syncCheckStrategy instanceof PySyncCheckOnly) {
            return null;
        }
        PySyncCheckCreateIfPossible checkStrategy = (PySyncCheckCreateIfPossible)syncCheckStrategy;
        Module module = checkStrategy.getModule();
        Project project = module.getProject();
        String userProvidedPath = checkStrategy.getRemotePath();
        if (userProvidedPath != null) {
            String executionResult = PySshProjectSynchronizerHelpers.createRemoteFolder(this.mySdk, module, userProvidedPath);
            if (executionResult == null || !executionResult.isEmpty()) {
                return String.format("%s is not writable or can't be created. Project will not be created.", userProvidedPath);
            }
            PathMappingSettings.PathMapping pathMapping = PyDeploymentUtil.configurePythonPathMapping(project, this.myServerId, userProvidedPath);
            return this.configureDeployment(module, new PySshProjectSynchronizerHelpers.MyServerRootAndFolder("/", userProvidedPath), pathMapping);
        }
        Pair<PathMappingSettings.PathMapping, PySshProjectSynchronizerHelpers.MyServerRootAndFolder> mappingAndPath = PyDeploymentUtil.createMapping(this.mySdk, module, this.myServerId, this.myAdditionalData);
        if (mappingAndPath == null || !this.isMappingExist(project)) {
            return "No path mappings created for this project. Remote interpreter needs path mapping.";
        }
        if (PyDeploymentBasedProjectSynchronizer.isUserOkWithDeployment(project) && (deploymentCreationError = this.configureDeployment(module, (PySshProjectSynchronizerHelpers.MyServerRootAndFolder)mappingAndPath.getSecond(), (PathMappingSettings.PathMapping)mappingAndPath.first)) != null) {
            return deploymentCreationError;
        }
        if (!PyDeploymentUtil.isDeploymentExist(project, this.myAdditionalData)) {
            return "No deployment created for this project. Remote interpreter needs deployment";
        }
        return null;
    }

    @Nullable
    protected abstract String configureDeployment(@NotNull Module var1, @NotNull PySshProjectSynchronizerHelpers.MyServerRootAndFolder var2, @NotNull PathMappingSettings.PathMapping var3);

    private static boolean isUserOkWithDeployment(@NotNull Project project) {
        if (project == null) {
            PyDeploymentBasedProjectSynchronizer.$$$reportNull$$$0(11);
        }
        DialogBuilder dialog = new DialogBuilder(project);
        dialog.getCenterPanel();
        dialog.setTitle("Add deployment?");
        dialog.setCenterPanel((JComponent)new JLabel("<html><body><p>Do you want to add deployment configuration to this mapping?<p>Deployment configuration allows PyCharm copy files to remote destination.</p></body></html>"));
        dialog.addOkAction();
        dialog.addCancelAction();
        return dialog.showAndGet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyDeploymentBasedProjectSynchronizer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncDirection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncCheckStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyDeploymentBasedProjectSynchronizer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeployable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMappingExist";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappings";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "syncProject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkSynchronizationAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUserOkWithDeployment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

