/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.i18n;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordList;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public class JsonGherkinKeywordProvider
implements GherkinKeywordProvider {
    private static final Logger LOG = Logger.getInstance((String)JsonGherkinKeywordProvider.class.getName());
    private final GherkinKeywordList myEmptyKeywordList;
    private final Map<String, GherkinKeywordList> myLanguageKeywords;
    private final Set<String> myAllStepKeywords;
    private static GherkinKeywordProvider myKeywordProvider;
    private static GherkinKeywordProvider myGherkin6KeywordProvider;

    public static GherkinKeywordProvider getKeywordProvider() {
        if (myKeywordProvider == null) {
            myKeywordProvider = JsonGherkinKeywordProvider.createKeywordProviderFromJson("i18n_old.json");
        }
        return myKeywordProvider;
    }

    public static GherkinKeywordProvider getKeywordProvider(boolean gherkin6) {
        if (!gherkin6) {
            return JsonGherkinKeywordProvider.getKeywordProvider();
        }
        if (myGherkin6KeywordProvider == null) {
            myGherkin6KeywordProvider = JsonGherkinKeywordProvider.createKeywordProviderFromJson("i18n.json");
        }
        return myGherkin6KeywordProvider;
    }

    public static GherkinKeywordProvider getKeywordProvider(@NotNull PsiElement context) {
        Module module;
        if (context == null) {
            JsonGherkinKeywordProvider.$$$reportNull$$$0(0);
        }
        boolean gherkin6Enabled = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null && CucumberStepsIndex.getInstance(context.getProject()).isGherkin6Supported(module);
        return JsonGherkinKeywordProvider.getKeywordProvider(gherkin6Enabled);
    }

    private static GherkinKeywordProvider createKeywordProviderFromJson(@NotNull String jsonFileName) {
        if (jsonFileName == null) {
            JsonGherkinKeywordProvider.$$$reportNull$$$0(1);
        }
        GherkinKeywordProvider result = null;
        ClassLoader classLoader = JsonGherkinKeywordProvider.class.getClassLoader();
        if (classLoader != null) {
            InputStream gherkinKeywordStream = (InputStream)ObjectUtils.notNull((Object)classLoader.getResourceAsStream(jsonFileName));
            result = new JsonGherkinKeywordProvider(gherkinKeywordStream);
        }
        return result != null ? result : new PlainGherkinKeywordProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonGherkinKeywordProvider(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            JsonGherkinKeywordProvider.$$$reportNull$$$0(2);
        }
        this.myEmptyKeywordList = new GherkinKeywordList();
        this.myLanguageKeywords = new HashMap<String, GherkinKeywordList>();
        this.myAllStepKeywords = new HashSet<String>();
        try (InputStreamReader in2 = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            Map fromJson = (Map)new Gson().fromJson((Reader)in2, new TypeToken<Map<String, HashMap<String, Object>>>(){}.getType());
            for (Map.Entry entry : fromJson.entrySet()) {
                Map translation = (Map)entry.getValue();
                GherkinKeywordList keywordList = new GherkinKeywordList(translation);
                this.myLanguageKeywords.put((String)entry.getKey(), keywordList);
                for (String keyword : keywordList.getAllKeywords()) {
                    if (keywordList.getTokenType(keyword) != GherkinTokenTypes.STEP_KEYWORD) continue;
                    this.myAllStepKeywords.add(keyword);
                }
            }
        }
        catch (MalformedJsonException in2) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public Collection<String> getAllKeywords(String language) {
        return this.getKeywordList(language).getAllKeywords();
    }

    @Override
    public IElementType getTokenType(String language, String keyword) {
        return this.getKeywordList(language).getTokenType(keyword);
    }

    @Override
    public String getBaseKeyword(String language, String keyword) {
        return this.getKeywordList(language).getBaseKeyword(keyword);
    }

    @Override
    public boolean isSpaceRequiredAfterKeyword(String language, String keyword) {
        return this.getKeywordList(language).isSpaceAfterKeyword(keyword);
    }

    @Override
    public boolean isStepKeyword(String keyword) {
        return this.myAllStepKeywords.contains(keyword);
    }

    @Override
    @NotNull
    public GherkinKeywordTable getKeywordsTable(@Nullable String language) {
        GherkinKeywordTable gherkinKeywordTable = this.getKeywordList(language).getKeywordsTable();
        if (gherkinKeywordTable == null) {
            JsonGherkinKeywordProvider.$$$reportNull$$$0(3);
        }
        return gherkinKeywordTable;
    }

    @NotNull
    private GherkinKeywordList getKeywordList(@Nullable String language) {
        GherkinKeywordList keywordList = this.myLanguageKeywords.get(language);
        if (keywordList == null) {
            keywordList = this.myEmptyKeywordList;
        }
        GherkinKeywordList gherkinKeywordList = keywordList;
        if (gherkinKeywordList == null) {
            JsonGherkinKeywordProvider.$$$reportNull$$$0(4);
        }
        return gherkinKeywordList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/i18n/JsonGherkinKeywordProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/i18n/JsonGherkinKeywordProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordsTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordProviderFromJson";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

