/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.firefox.FirefoxCommandProcessor$WhenMappings;
import com.jetbrains.firefox.FirefoxListener;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.rdp.FirefoxProtocolReaderImpl;
import com.jetbrains.firefox.rdp.Source;
import com.jetbrains.firefox.rdp.ThreadInterrupted;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.BufferToCharsKt;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.CommandSenderBase;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.MessageManagerBaseKt;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.RequestPromise;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0005FGHIJB\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u001c\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u000b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0,J\b\u0010-\u001a\u00020&H\u0016J\u0006\u0010.\u001a\u00020&J\b\u0010/\u001a\u00020&H\u0016J0\u00100\u001a\u00020&\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H105H\u0014J4\u00106\u001a\u00020&\"\u0004\b\u0000\u001012\n\u00102\u001a\u0006\u0012\u0002\b\u0003072\u0006\u00108\u001a\u00020\u000b2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H105J\u000e\u00109\u001a\u00020&2\u0006\u0010*\u001a\u00020\u000bJ*\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u000b2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u000bH\u0002J@\u0010@\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u000b2\u0006\u0010>\u001a\u00020\u000b2\b\u0010A\u001a\u0004\u0018\u00010\u000b2\b\u0010B\u001a\u0004\u0018\u00010\u000b2\b\u0010?\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010C\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u000bH\u0002J\u000e\u0010D\u001a\u00020&2\u0006\u0010;\u001a\u00020<J\u000e\u0010E\u001a\u00020&2\u0006\u0010>\u001a\u00020\u000bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u001a\u001a\u001e\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u001c0\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor;", "Lorg/jetbrains/rpc/CommandSenderBase;", "", "Lorg/jetbrains/rpc/MessageProcessor;", "writer", "Lkotlin/Function1;", "Lio/netty/buffer/ByteBuf;", "", "(Lkotlin/jvm/functions/Function1;)V", "actorToThread", "Lgnu/trove/THashMap;", "", "getActorToThread", "()Lgnu/trove/THashMap;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$IFirefoxListener;", "kotlin.jvm.PlatformType", "forcedPause", "getForcedPause", "()Z", "setForcedPause", "(Z)V", "isBreakOnException", "messageManager", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$FirefoxMessageManager;", "threadToState", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$ThreadState;", "getThreadToState", "()Ljava/util/concurrent/ConcurrentMap;", "threadsToResume", "Lgnu/trove/THashSet;", "getThreadsToResume", "()Lgnu/trove/THashSet;", "addInitialMessageHandler", "Lorg/jetbrains/concurrency/Promise;", "addListener", "", "listener", "Lcom/jetbrains/firefox/FirefoxListener;", "attachToThreadAndExecute", "thread", "runnable", "Lkotlin/Function0;", "cancelWaitingRequests", "clear", "closed", "doSend", "RESULT", "message", "Lorg/jetbrains/jsonProtocol/Request;", "callback", "Lorg/jetbrains/rpc/RequestPromise;", "doSendFromPaused", "Lcom/jetbrains/firefox/FirefoxRequest;", "threadActor", "forcedReleaseThread", "handleEvent", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "nextName", "actor", "type", "handleResponseOrEvent", "error", "errorDescription", "hasPendingRequestRequiringPause", "processIncomingJson", "releaseThreadIfPossible", "Companion", "FirefoxMessageManager", "IFirefoxListener", "RequestItem", "ThreadState", "intellij.javascript.firefox.connector"})
public final class FirefoxCommandProcessor
extends CommandSenderBase<Object>
implements MessageProcessor {
    private final FirefoxMessageManager messageManager;
    @NotNull
    private final ConcurrentMap<String, ThreadState> threadToState;
    @NotNull
    private final THashMap<String, String> actorToThread;
    @NotNull
    private final THashSet<String> threadsToResume;
    private boolean forcedPause;
    private final EventDispatcher<IFirefoxListener> dispatcher;
    private final boolean isBreakOnException = false;
    private final Function1<ByteBuf, Boolean> writer;
    private static final FirefoxProtocolReaderImpl READER;
    public static final Companion Companion;

    @NotNull
    public final ConcurrentMap<String, ThreadState> getThreadToState() {
        return this.threadToState;
    }

    @NotNull
    public final THashMap<String, String> getActorToThread() {
        return this.actorToThread;
    }

    @NotNull
    public final THashSet<String> getThreadsToResume() {
        return this.threadsToResume;
    }

    public final boolean getForcedPause() {
        return this.forcedPause;
    }

    public final void setForcedPause(boolean bl) {
        this.forcedPause = bl;
    }

    public final boolean isBreakOnException() {
        return this.isBreakOnException;
    }

    @NotNull
    public final Promise<?> addInitialMessageHandler() {
        RequestPromise promise = new RequestPromise("initial");
        this.messageManager.getActorToCurrentItem().put((Object)"root", (Object)new RequestItem(null, FirefoxRequest.Method.INITIAL, (RequestCallback<Object>)((RequestCallback)promise)));
        return (Promise)promise;
    }

    public final void addListener(@NotNull FirefoxListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    public void cancelWaitingRequests() {
        this.messageManager.cancelWaitingRequests();
    }

    public void closed() {
        this.messageManager.closed();
    }

    public final void attachToThreadAndExecute(@NotNull String thread, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        ThreadState state = (ThreadState)((Object)this.threadToState.get(thread));
        if (state != null) {
            CommandProcessorKt.getLOG().assertTrue(state == ThreadState.PAUSED);
            runnable.invoke();
            return;
        }
        this.send(FirefoxRequest.Companion.attachToThread(thread)).onSuccess((Consumer)new Consumer<ThreadInterrupted>(runnable){
            final /* synthetic */ Function0 $runnable;

            public final void accept(ThreadInterrupted it) {
                try {
                    this.$runnable.invoke();
                }
                catch (Exception e) {
                    CommandProcessorKt.getLOG().error((Throwable)e);
                }
            }
            {
                this.$runnable = function0;
            }
        });
    }

    protected <RESULT> void doSend(@NotNull Request<RESULT> message, @NotNull RequestPromise<Object, RESULT> callback) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        FirefoxRequest request = (FirefoxRequest)message;
        this.messageManager.send(request, (RequestCallback<Object>)((RequestCallback)callback));
    }

    public final <RESULT> void doSendFromPaused(@NotNull FirefoxRequest<?> message, @NotNull String threadActor, @NotNull RequestPromise<Object, RESULT> callback) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)threadActor, (String)"threadActor");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        CommandProcessorKt.getLOG().assertTrue(message.requiresPause());
        this.actorToThread.put((Object)message.getActor(), (Object)threadActor);
        this.messageManager.send(message, (RequestCallback<Object>)((RequestCallback)callback));
    }

    public final void processIncomingJson(@NotNull JsonReaderEx reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        reader.beginObject();
        String actor = null;
        JsonReaderEx subReader = null;
        String nextName = null;
        String error = null;
        String errorMessage = null;
        String type = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (Intrinsics.areEqual((Object)name, (Object)"error")) {
                error = reader.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"from")) {
                actor = reader.nextString();
                if (subReader == null) continue;
                String string = actor;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"actor");
                this.handleResponseOrEvent(subReader, nextName, string, error, errorMessage, type);
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"message")) {
                errorMessage = reader.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"type")) {
                type = reader.nextString();
                continue;
            }
            if (actor == null) {
                if (subReader == null) {
                    nextName = name;
                    subReader = reader.subReader();
                }
                reader.skipValue();
                continue;
            }
            this.handleResponseOrEvent(reader, name, actor, error, errorMessage, type);
            return;
        }
        String string = actor;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.handleResponseOrEvent(reader, null, string, error, errorMessage, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void handleResponseOrEvent(JsonReaderEx reader, String nextName, String actor, String error, String errorDescription, String type) {
        nextName = nextName;
        if (Intrinsics.areEqual((Object)"newGlobal", (Object)type)) {
            return;
        }
        nextRequest = null;
        item = null;
        var10_10 = this.messageManager.getActorToCurrentItem();
        var11_12 = false;
        var12_14 = false;
        synchronized (var10_10) {
            block53: {
                block52: {
                    $i$a$-synchronized-FirefoxCommandProcessor$handleResponseOrEvent$1 = false;
                    item = (RequestItem)this.messageManager.getActorToCurrentItem().remove((Object)actor);
                    if (item != null) break block52;
                    nextRequest = null;
                    v0 /* !! */  = Unit.INSTANCE;
                    break block53;
                }
                if (type == null) ** GOTO lbl-1000
                v1 = item;
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)type, (Object)v1.getMethod().getUglyProtocolResponseType()) ^ true) {
                    this.messageManager.getActorToCurrentItem().put((Object)actor, (Object)item);
                    item = null;
                    nextRequest = null;
                    v0 /* !! */  = Unit.INSTANCE;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = item;
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((next = v2.getNext()) == null) {
                        nextRequest = null;
                        v0 /* !! */  = Unit.INSTANCE;
                    } else {
                        nextRequest = next.getMessage();
                        var15_19 = nextRequest != null;
                        var16_20 = false;
                        var17_21 = false;
                        if (_Assertions.ENABLED && !var15_19) {
                            var18_22 = false;
                            var18_23 = "Assertion failed";
                            throw (Throwable)new AssertionError((Object)var18_23);
                        }
                        next.setMessage(null);
                        v0 /* !! */  = this.messageManager.getActorToCurrentItem().put((Object)actor, (Object)next);
                    }
                }
            }
            var12_15 = v0 /* !! */ ;
        }
        if (item == null) {
            v3 = type;
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            this.handleEvent(reader, nextName, actor, v3);
            return;
        }
        try {
            if (error == null) {
                v4 = item;
                if (v4 == null) {
                    Intrinsics.throwNpe();
                }
                method = v4.getMethod();
                response = null;
                block5 : switch (FirefoxCommandProcessor$WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (Intrinsics.areEqual((Object)"exited", (Object)type)) {
                            v5 = item;
                            if (v5 == null) {
                                Intrinsics.throwNpe();
                            }
                            v5.getCallback().onError("EXITED");
                            return;
                        }
                        if (Intrinsics.areEqual((Object)type, (Object)"paused")) {
                            this.threadToState.put(actor, ThreadState.PAUSED);
                        }
                        response = method == FirefoxRequest.Method.ATTACH_TO_TAB ? FirefoxCommandProcessor.READER.readAttachToTabResult(reader, nextName) : FirefoxCommandProcessor.READER.readThreadInterrupted(reader, nextName);
                        break;
                    }
                    case 4: {
                        this.threadToState.put(actor, ThreadState.RUNNING);
                        response = null;
                        break;
                    }
                    case 5: {
                        response = FirefoxCommandProcessor.READER.readSetBreakpointResult(reader, nextName);
                        break;
                    }
                    case 6: {
                        response = FirefoxCommandProcessor.READER.readSourcesResult(reader, nextName);
                        break;
                    }
                    case 7: {
                        response = FirefoxCommandProcessor.READER.readSourceResult(reader, nextName);
                        break;
                    }
                    case 8: {
                        response = FirefoxCommandProcessor.READER.readFramesResult(reader, nextName);
                        break;
                    }
                    case 9: {
                        response = FirefoxCommandProcessor.READER.readPrototypeAndPropertiesResult(reader, nextName);
                        break;
                    }
                    case 10: {
                        response = reader.hasNext() != false ? FirefoxCommandProcessor.READER.readPropertyResult(reader, nextName) : null;
                        break;
                    }
                    case 11: {
                        response = reader.hasNext() != false ? FirefoxCommandProcessor.READER.readPrototypeResult(reader, nextName) : null;
                        break;
                    }
                    case 12: {
                        if (nextName == null) {
                            nextName = reader.nextName();
                        }
                        response = null;
                        do {
                            if (Intrinsics.areEqual((Object)nextName, (Object)"bindings")) {
                                response = FirefoxCommandProcessor.READER.readBindings(reader, null);
                                break block5;
                            }
                            reader.skipValue();
                            nextName = reader.nextName();
                        } while (reader.hasNext());
                        break;
                    }
                    case 13: {
                        response = FirefoxCommandProcessor.READER.readListTabsResult(reader, nextName);
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        response = null;
                        break;
                    }
                    default: {
                        rejectError = "Unknown response " + method.getProtocolName() + ", actor " + actor;
                        CommandProcessorKt.getLOG().error(rejectError);
                        v6 = item;
                        if (v6 == null) {
                            Intrinsics.throwNpe();
                        }
                        v6.getCallback().onError(rejectError);
                        return;
                    }
                }
                v7 = item;
                if (v7 == null) {
                    Intrinsics.throwNpe();
                }
                v7.getCallback().onSuccess(response, null);
            } else {
                v8 = item;
                if (v8 == null) {
                    Intrinsics.throwNpe();
                }
                if (v8.getMethod() == FirefoxRequest.Method.RELEASE_MANY && Intrinsics.areEqual((Object)error, (Object)"notReleasable")) {
                    v9 = item;
                    if (v9 == null) {
                        Intrinsics.throwNpe();
                    }
                    v9.getCallback().onSuccess(null, null);
                } else {
                    v10 = item;
                    if (v10 == null) {
                        Intrinsics.throwNpe();
                    }
                    v10.getCallback().onError(error + (errorDescription == null ? "" : ", " + errorDescription));
                }
            }
        }
        finally {
            if (nextRequest != null) {
                v11 = nextRequest;
                if (v11 == null) {
                    Intrinsics.throwNpe();
                }
                this.writer.invoke((Object)CommandProcessorKt.requestToByteBuf$default((Request)v11, (boolean)false, (int)2, null));
            } else {
                this.releaseThreadIfPossible(actor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseThreadIfPossible(@NotNull String actor) {
        Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
        if (this.forcedPause) {
            return;
        }
        String actorThread = (String)this.actorToThread.get((Object)actor);
        ConcurrentMap<String, ThreadState> concurrentMap = this.threadToState;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentMap) {
            boolean bl3 = false;
            if (actorThread != null && this.threadsToResume.contains((Object)actorThread) && !this.hasPendingRequestRequiringPause(actorThread)) {
                CommandProcessorKt.getLOG().assertTrue((ThreadState)((Object)this.threadToState.get(actorThread)) == ThreadState.PAUSED);
                this.send(FirefoxRequest.Companion.resumeThread(actorThread, this.isBreakOnException));
                this.threadToState.put(actorThread, ThreadState.RUNNING);
                this.threadsToResume.remove((Object)actorThread);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void forcedReleaseThread(@NotNull String thread) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        this.forcedPause = false;
        this.threadsToResume.add((Object)thread);
        this.releaseThreadIfPossible(thread);
    }

    private final boolean hasPendingRequestRequiringPause(String thread) {
        Map map = (Map)this.messageManager.getActorToCurrentItem();
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            RequestItem item;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            String actor = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            for (RequestItem currentItem = item = (RequestItem)entry2.getValue(); currentItem != null; currentItem = currentItem.getNext()) {
                FirefoxRequest<Object> message = currentItem.getMessage();
                if (message == null || !message.requiresPause() || !Intrinsics.areEqual((Object)((String)this.actorToThread.get((Object)actor)), (Object)thread)) continue;
                return true;
            }
        }
        return false;
    }

    private final void handleEvent(JsonReaderEx reader, String nextName, String actor, String type) {
        block16: {
            EventListener eventListener = this.dispatcher.getMulticaster();
            Intrinsics.checkExpressionValueIsNotNull((Object)eventListener, (String)"dispatcher.multicaster");
            IFirefoxListener multicaster = (IFirefoxListener)eventListener;
            if (Intrinsics.areEqual((Object)type, (Object)"tabDetached")) {
                multicaster.tabDetached(actor);
            } else if (Intrinsics.areEqual((Object)type, (Object)"paused")) {
                this.threadToState.put(actor, ThreadState.PAUSED);
                multicaster.paused(READER.readThreadInterrupted(reader, nextName));
            } else if (Intrinsics.areEqual((Object)type, (Object)"frameUpdate")) {
                String name = nextName;
                if (name == null && reader.hasNext()) {
                    name = reader.nextName();
                }
                boolean destroyAll = false;
                if (name != null) {
                    while (true) {
                        if (Intrinsics.areEqual((Object)name, (Object)"destroyAll")) {
                            destroyAll = reader.nextBoolean();
                            break;
                        }
                        reader.skipValue();
                        if (reader.nextNameOrNull() != null) continue;
                        break;
                    }
                }
                multicaster.frameUpdated(actor, destroyAll);
            } else {
                if (Intrinsics.areEqual((Object)type, (Object)"newSource")) {
                    String name = nextName;
                    if (name == null) {
                        name = reader.nextName();
                    }
                    while (true) {
                        if (Intrinsics.areEqual((Object)name, (Object)"source")) {
                            multicaster.scriptAdded(READER.readSource(reader, null));
                        } else {
                            reader.skipValue();
                            if (reader.nextNameOrNull() != null) continue;
                        }
                        break block16;
                    }
                }
                if (!Intrinsics.areEqual((Object)type, (Object)"tabNavigated") && !Intrinsics.areEqual((Object)type, (Object)"tabListChanged")) {
                    CommandProcessorKt.getLOG().warn("Unhandled event " + actor + ':' + type);
                }
            }
        }
    }

    public final void clear() {
        this.messageManager.clear$intellij_javascript_firefox_connector();
        for (String key : this.threadToState.keySet()) {
            this.threadToState.put(key, ThreadState.RUNNING);
        }
    }

    public FirefoxCommandProcessor(@NotNull Function1<? super ByteBuf, Boolean> writer) {
        Intrinsics.checkParameterIsNotNull(writer, (String)"writer");
        this.writer = writer;
        this.messageManager = new FirefoxMessageManager();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurr\u2026ap<String, ThreadState>()");
        this.threadToState = concurrentMap;
        this.actorToThread = new THashMap();
        this.threadsToResume = new THashSet();
        EventDispatcher eventDispatcher = EventDispatcher.create(IFirefoxListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(I\u2026efoxListener::class.java)");
        this.dispatcher = eventDispatcher;
    }

    static {
        Companion = new Companion(null);
        READER = new FirefoxProtocolReaderImpl();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$IFirefoxListener;", "Ljava/util/EventListener;", "frameUpdated", "", "actor", "", "destroyAll", "", "paused", "event", "Lcom/jetbrains/firefox/rdp/ThreadInterrupted;", "scriptAdded", "script", "Lcom/jetbrains/firefox/rdp/Source;", "tabDetached", "intellij.javascript.firefox.connector"})
    public static interface IFirefoxListener
    extends EventListener {
        public void tabDetached(@NotNull String var1);

        public void paused(@NotNull ThreadInterrupted var1);

        public void frameUpdated(@NotNull String var1, boolean var2);

        public void scriptAdded(@NotNull Source var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$ThreadState;", "", "(Ljava/lang/String;I)V", "PAUSED", "RUNNING", "intellij.javascript.firefox.connector"})
    public static final class ThreadState
    extends Enum<ThreadState> {
        public static final /* enum */ ThreadState PAUSED;
        public static final /* enum */ ThreadState RUNNING;
        private static final /* synthetic */ ThreadState[] $VALUES;

        static {
            ThreadState[] threadStateArray = new ThreadState[2];
            ThreadState[] threadStateArray2 = threadStateArray;
            threadStateArray[0] = PAUSED = new ThreadState();
            threadStateArray[1] = RUNNING = new ThreadState();
            $VALUES = threadStateArray;
        }

        public static ThreadState[] values() {
            return (ThreadState[])$VALUES.clone();
        }

        public static ThreadState valueOf(String string) {
            return Enum.valueOf(ThreadState.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "", "message", "Lcom/jetbrains/firefox/FirefoxRequest;", "method", "Lcom/jetbrains/firefox/FirefoxRequest$Method;", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "(Lcom/jetbrains/firefox/FirefoxRequest;Lcom/jetbrains/firefox/FirefoxRequest$Method;Lorg/jetbrains/rpc/RequestCallback;)V", "getCallback", "()Lorg/jetbrains/rpc/RequestCallback;", "getMessage", "()Lcom/jetbrains/firefox/FirefoxRequest;", "setMessage", "(Lcom/jetbrains/firefox/FirefoxRequest;)V", "getMethod", "()Lcom/jetbrains/firefox/FirefoxRequest$Method;", "next", "getNext", "()Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "setNext", "(Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;)V", "intellij.javascript.firefox.connector"})
    private static final class RequestItem {
        @Nullable
        private RequestItem next;
        @Nullable
        private FirefoxRequest<Object> message;
        @NotNull
        private final FirefoxRequest.Method method;
        @NotNull
        private final RequestCallback<Object> callback;

        @Nullable
        public final RequestItem getNext() {
            return this.next;
        }

        public final void setNext(@Nullable RequestItem requestItem) {
            this.next = requestItem;
        }

        @Nullable
        public final FirefoxRequest<Object> getMessage() {
            return this.message;
        }

        public final void setMessage(@Nullable FirefoxRequest<Object> firefoxRequest) {
            this.message = firefoxRequest;
        }

        @NotNull
        public final FirefoxRequest.Method getMethod() {
            return this.method;
        }

        @NotNull
        public final RequestCallback<Object> getCallback() {
            return this.callback;
        }

        public RequestItem(@Nullable FirefoxRequest<Object> message, @NotNull FirefoxRequest.Method method, @NotNull RequestCallback<Object> callback) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.message = message;
            this.method = method;
            this.callback = callback;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\r\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\fJ \u0010\r\u001a\u00020\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$FirefoxMessageManager;", "Lorg/jetbrains/rpc/MessageManagerBase;", "(Lcom/jetbrains/firefox/FirefoxCommandProcessor;)V", "actorToCurrentItem", "Lgnu/trove/THashMap;", "", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "getActorToCurrentItem", "()Lgnu/trove/THashMap;", "cancelWaitingRequests", "", "clear", "clear$intellij_javascript_firefox_connector", "send", "message", "Lcom/jetbrains/firefox/FirefoxRequest;", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "", "intellij.javascript.firefox.connector"})
    private final class FirefoxMessageManager
    extends MessageManagerBase {
        @NotNull
        private final THashMap<String, RequestItem> actorToCurrentItem = new THashMap();

        @NotNull
        public final THashMap<String, RequestItem> getActorToCurrentItem() {
            return this.actorToCurrentItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void send(@NotNull FirefoxRequest<?> message, @NotNull RequestCallback<Object> callback) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(message, (String)"message");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            if (this.rejectIfClosed(callback)) {
                return;
            }
            String actor = message.getActor();
            if (message.requiresPause()) {
                Object object = FirefoxCommandProcessor.this.getActorToThread().get((Object)actor);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"actorToThread[actor]!!");
                String thread = (String)object;
                ConcurrentMap<String, ThreadState> concurrentMap = FirefoxCommandProcessor.this.getThreadToState();
                bl = false;
                boolean bl2 = false;
                synchronized (concurrentMap) {
                    boolean bl3 = false;
                    ThreadState state = (ThreadState)((Object)FirefoxCommandProcessor.this.getThreadToState().get(thread));
                    if (state == ThreadState.RUNNING) {
                        FirefoxCommandProcessor.this.send(FirefoxRequest.Companion.interrupt(thread)).onSuccess((Consumer)new Consumer<ThreadInterrupted>(this, thread, message, callback){
                            final /* synthetic */ FirefoxMessageManager this$0;
                            final /* synthetic */ String $thread$inlined;
                            final /* synthetic */ FirefoxRequest $message$inlined;
                            final /* synthetic */ RequestCallback $callback$inlined;
                            {
                                this.this$0 = firefoxMessageManager;
                                this.$thread$inlined = string;
                                this.$message$inlined = firefoxRequest;
                                this.$callback$inlined = requestCallback;
                            }

                            public final void accept(ThreadInterrupted it) {
                                this.this$0.send(this.$message$inlined, (RequestCallback<Object>)this.$callback$inlined);
                            }
                        }).onError((Consumer)new Consumer<Throwable>(this, thread, message, callback){
                            final /* synthetic */ FirefoxMessageManager this$0;
                            final /* synthetic */ String $thread$inlined;
                            final /* synthetic */ FirefoxRequest $message$inlined;
                            final /* synthetic */ RequestCallback $callback$inlined;
                            {
                                this.this$0 = firefoxMessageManager;
                                this.$thread$inlined = string;
                                this.$message$inlined = firefoxRequest;
                                this.$callback$inlined = requestCallback;
                            }

                            public final void accept(Throwable it) {
                                this.this$0.FirefoxCommandProcessor.this.getThreadToState().put(this.$thread$inlined, ThreadState.RUNNING);
                                Throwable throwable = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                                this.$callback$inlined.onError(throwable);
                            }
                        });
                        FirefoxCommandProcessor.this.getThreadToState().put(thread, ThreadState.PAUSED);
                        FirefoxCommandProcessor.this.getThreadsToResume().add((Object)thread);
                        return;
                    }
                    bl2 = CommandProcessorKt.getLOG().assertTrue(state == ThreadState.PAUSED, (Object)state);
                }
            }
            message.finalize(-1);
            THashMap<String, RequestItem> tHashMap = this.actorToCurrentItem;
            boolean bl4 = false;
            bl = false;
            synchronized (tHashMap) {
                boolean bl5 = false;
                RequestItem item = (RequestItem)this.actorToCurrentItem.get((Object)actor);
                if (item != null) {
                    RequestItem prev = item;
                    while (prev.getNext() != null) {
                        if (prev.getNext() != null) continue;
                        Intrinsics.throwNpe();
                    }
                    prev.setNext(new RequestItem(message, message.getMethod(), callback));
                    return;
                }
                RequestItem requestItem = (RequestItem)this.actorToCurrentItem.put((Object)actor, (Object)new RequestItem(null, message.getMethod(), callback));
            }
            FirefoxCommandProcessor.this.writer.invoke((Object)CommandProcessorKt.requestToByteBuf$default((Request)message, (boolean)false, (int)2, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear$intellij_javascript_firefox_connector() {
            THashMap<String, RequestItem> tHashMap = this.actorToCurrentItem;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (tHashMap) {
                boolean bl3 = false;
                this.cancelWaitingRequests();
                this.actorToCurrentItem.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void cancelWaitingRequests() {
            THashMap<String, RequestItem> tHashMap = this.actorToCurrentItem;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (tHashMap) {
                boolean bl3 = false;
                Iterator iterator = this.actorToCurrentItem.values().iterator();
                block3: while (iterator.hasNext()) {
                    RequestItem listItem;
                    RequestItem item = listItem = (RequestItem)iterator.next();
                    while (true) {
                        item.setMessage(null);
                        MessageManagerBaseKt.reject(item.getCallback());
                        if (item.getNext() != null) continue;
                        continue block3;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$Companion;", "", "()V", "READER", "Lcom/jetbrains/firefox/rdp/FirefoxProtocolReaderImpl;", "write", "Lio/netty/channel/ChannelFuture;", "contentBuffer", "Lio/netty/buffer/ByteBuf;", "channel", "Lio/netty/channel/Channel;", "intellij.javascript.firefox.connector"})
    public static final class Companion {
        @NotNull
        public final ChannelFuture write(@NotNull ByteBuf contentBuffer, @NotNull Channel channel) {
            Intrinsics.checkParameterIsNotNull((Object)contentBuffer, (String)"contentBuffer");
            Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
            ByteBuf lengthBuffer = channel.alloc().ioBuffer(8);
            int n = contentBuffer.readableBytes();
            ByteBuf byteBuf = lengthBuffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"lengthBuffer");
            BufferToCharsKt.writeIntAsAscii((int)n, (ByteBuf)byteBuf);
            lengthBuffer.writeByte(58);
            channel.write((Object)lengthBuffer);
            ChannelFuture channelFuture = channel.writeAndFlush((Object)contentBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"channel.writeAndFlush(contentBuffer)");
            return channelFuture;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

