/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import org.angular2.lang.Angular2ContextProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Angular2LangUtil {
    @NonNls
    public static final String ANGULAR_CORE_PACKAGE = "@angular/core";
    @NonNls
    public static final String ANGULAR_CLI_PACKAGE = "@angular/cli";
    @NonNls
    private static final Key<CachedValue<Boolean>> ANGULAR2_CONTEXT_KEY = new Key("angular2.isContext");

    public static boolean isAngular2Context(@NotNull PsiElement context) {
        if (context == null) {
            Angular2LangUtil.$$$reportNull$$$0(0);
        }
        if (!context.isValid()) {
            return false;
        }
        PsiFile psiFile = InjectedLanguageManager.getInstance((Project)context.getProject()).getTopLevelFile(context);
        if (psiFile == null) {
            return false;
        }
        VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
        if (file == null || !file.isInLocalFileSystem()) {
            return Angular2LangUtil.isAngular2Context(psiFile.getProject());
        }
        return Angular2LangUtil.isAngular2Context(psiFile.getProject(), file);
    }

    public static boolean isAngular2Context(@NotNull Project project, @NotNull VirtualFile context) {
        if (project == null) {
            Angular2LangUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            Angular2LangUtil.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && "disabled".equals(System.getProperty("angular.js"))) {
            return false;
        }
        while (context instanceof LightVirtualFileBase) {
            context = ((LightVirtualFileBase)context).getOriginalFile();
        }
        PsiDirectory psiDir = (PsiDirectory)ObjectUtils.doIfNotNull((Object)(context != null ? context.getParent() : null), dir -> dir.isValid() ? PsiManager.getInstance((Project)project).findDirectory(dir) : null);
        if (psiDir == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiDir, ANGULAR2_CONTEXT_KEY, () -> {
            HashSet dependencies = new HashSet();
            for (Angular2ContextProvider provider : Angular2ContextProvider.ANGULAR_CONTEXT_PROVIDER_EP.getExtensionList()) {
                CachedValueProvider.Result<Boolean> result = provider.isAngular2Context(psiDir);
                if (result.getValue() == Boolean.TRUE) {
                    return result;
                }
                ContainerUtil.addAll((Collection)dependencies, (Object[])result.getDependencyItems());
            }
            return new CachedValueProvider.Result((Object)false, dependencies.toArray());
        });
    }

    private static boolean isAngular2Context(@NotNull Project project) {
        if (project == null) {
            Angular2LangUtil.$$$reportNull$$$0(3);
        }
        if (project.getBaseDir() != null) {
            return Angular2LangUtil.isAngular2Context(project, project.getBaseDir());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/angular2/lang/Angular2LangUtil";
        objectArray[2] = "isAngular2Context";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

