/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2Module;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Angular2ModuleResolver<T extends PsiElement> {
    @NonNls
    public static final String NG_MODULE_PROP = "ngModule";
    @NonNls
    private static final String KEYS_PREFIX = "angular.moduleResolver.";
    private static final Key<CachedValue<ResolvedEntitiesList<Angular2Declaration>>> DECLARATIONS_KEY = new Key("angular.moduleResolver.declarations");
    private static final Key<CachedValue<ResolvedEntitiesList<Angular2Module>>> IMPORTS_KEY = new Key("angular.moduleResolver.imports");
    private static final Key<CachedValue<ResolvedEntitiesList<Angular2Entity>>> EXPORTS_KEY = new Key("angular.moduleResolver.exports");
    private final Supplier<? extends T> mySourceSupplier;
    private final SymbolCollector<T> mySymbolCollector;

    public Angular2ModuleResolver(@NotNull Supplier<? extends T> sourceSupplier, @NotNull SymbolCollector<T> symbolCollector) {
        if (sourceSupplier == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(0);
        }
        if (symbolCollector == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(1);
        }
        this.mySourceSupplier = sourceSupplier;
        this.mySymbolCollector = symbolCollector;
    }

    @NotNull
    public Set<Angular2Declaration> getDeclarations() {
        Set<Angular2Declaration> set = this.getResolvedModuleList(Angular2ModuleResolver.DECLARATIONS_KEY, Angular2Declaration.class).entities;
        if (set == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<Angular2Module> getImports() {
        Set<Angular2Module> set = this.getResolvedModuleList(Angular2ModuleResolver.IMPORTS_KEY, Angular2Module.class).entities;
        if (set == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<Angular2Entity> getExports() {
        Set<Angular2Entity> set = this.getResolvedModuleList(Angular2ModuleResolver.EXPORTS_KEY, Angular2Entity.class).entities;
        if (set == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isScopeFullyResolved() {
        if (!this.getResolvedModuleList(Angular2ModuleResolver.DECLARATIONS_KEY, Angular2Declaration.class).isFullyResolved) {
            return false;
        }
        ResolvedEntitiesList<Angular2Module> imports = this.getResolvedModuleList(IMPORTS_KEY, Angular2Module.class);
        return imports.isFullyResolved && !ContainerUtil.exists(imports.entities, m -> !m.areExportsFullyResolved()) && this.areExportsFullyResolved();
    }

    public boolean areExportsFullyResolved() {
        ResolvedEntitiesList<Angular2Entity> exports = this.getResolvedModuleList(EXPORTS_KEY, Angular2Entity.class);
        return exports.isFullyResolved && !ContainerUtil.exists(exports.entities, m -> m instanceof Angular2Module && !((Angular2Module)m).areExportsFullyResolved());
    }

    public boolean areDeclarationsFullyResolved() {
        return this.getResolvedModuleList(Angular2ModuleResolver.DECLARATIONS_KEY, Angular2Declaration.class).isFullyResolved;
    }

    @NotNull
    public Set<Angular2Declaration> getAllExportedDeclarations() {
        PsiElement source = (PsiElement)this.mySourceSupplier.get();
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)source, () -> {
            Angular2Module module;
            HashSet<Angular2Declaration> result = new HashSet<Angular2Declaration>();
            Angular2Module angular2Module = module = source instanceof Angular2Module ? (Angular2Module)source : Angular2EntitiesProvider.getModule(source);
            if (module != null) {
                HashSet<Angular2Module> processedModules = new HashSet<Angular2Module>();
                Stack moduleQueue = new Stack((Object[])new Angular2Module[]{module});
                while (!moduleQueue.empty()) {
                    Angular2Module current = (Angular2Module)moduleQueue.pop();
                    if (!processedModules.add(current)) continue;
                    for (Angular2Entity export : current.getExports()) {
                        if (export instanceof Angular2Module) {
                            moduleQueue.push((Object)((Angular2Module)export));
                            continue;
                        }
                        if (export instanceof Angular2Declaration) {
                            result.add((Angular2Declaration)export);
                            continue;
                        }
                        throw new IllegalArgumentException("Class " + export.getClass() + " extends neither Angular2Module nor Angular2Declaration");
                    }
                }
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (set == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    private <U extends Angular2Entity> ResolvedEntitiesList<U> getResolvedModuleList(@NotNull Key<CachedValue<ResolvedEntitiesList<U>>> key, @NotNull Class<U> entityClass) {
        if (key == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(6);
        }
        if (entityClass == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(7);
        }
        PsiElement source = (PsiElement)this.mySourceSupplier.get();
        SymbolCollector symbolCollector = this.mySymbolCollector;
        ResolvedEntitiesList resolvedEntitiesList = (ResolvedEntitiesList)CachedValuesManager.getCachedValue((PsiElement)source, key, () -> symbolCollector.collect(source, StringUtil.trimStart((String)key.toString(), (String)KEYS_PREFIX), entityClass));
        if (resolvedEntitiesList == null) {
            Angular2ModuleResolver.$$$reportNull$$$0(8);
        }
        return resolvedEntitiesList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolCollector";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/entities/Angular2ModuleResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/entities/Angular2ModuleResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllExportedDeclarations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedModuleList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedModuleList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ResolvedEntitiesList<T extends Angular2Entity> {
        final Set<T> entities;
        final boolean isFullyResolved;

        private ResolvedEntitiesList(@NotNull Set<T> entities, boolean isFullyResolved) {
            if (entities == null) {
                ResolvedEntitiesList.$$$reportNull$$$0(0);
            }
            this.entities = Collections.unmodifiableSet(entities);
            this.isFullyResolved = isFullyResolved;
        }

        public static <T extends Angular2Entity> CachedValueProvider.Result<ResolvedEntitiesList<T>> createResult(@NotNull Set<T> entities, boolean isFullyResolved, @NotNull Object dependency) {
            if (entities == null) {
                ResolvedEntitiesList.$$$reportNull$$$0(1);
            }
            if (dependency == null) {
                ResolvedEntitiesList.$$$reportNull$$$0(2);
            }
            return CachedValueProvider.Result.createSingleDependency(new ResolvedEntitiesList<T>(entities, isFullyResolved), (Object)dependency);
        }

        public static <T extends Angular2Entity> CachedValueProvider.Result<ResolvedEntitiesList<T>> createResult(@NotNull Set<T> entities, boolean isFullyResolved, @NotNull Collection<?> dependencies) {
            if (entities == null) {
                ResolvedEntitiesList.$$$reportNull$$$0(3);
            }
            if (dependencies == null) {
                ResolvedEntitiesList.$$$reportNull$$$0(4);
            }
            return CachedValueProvider.Result.create(new ResolvedEntitiesList<T>(entities, isFullyResolved), dependencies);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entities";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
            }
            objectArray2[1] = "org/angular2/entities/Angular2ModuleResolver$ResolvedEntitiesList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createResult";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface SymbolCollector<T> {
        public <U extends Angular2Entity> CachedValueProvider.Result<ResolvedEntitiesList<U>> collect(@NotNull T var1, @NotNull String var2, @NotNull Class<U> var3);
    }
}

