/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegatedConditionalExpressionJSInspection
extends JavaScriptInspection {
    private final NegatedConditionalFix fix = new NegatedConditionalFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("negated.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            NegatedConditionalExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONFUSING_GROUP_NAME;
        if (string == null) {
            NegatedConditionalExpressionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("negated.conditional.expression.error.string", new Object[0]);
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/confusing/NegatedConditionalExpressionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSConditionalExpression(JSConditionalExpression exp) {
            super.visitJSConditionalExpression(exp);
            JSExpression condition = exp.getCondition();
            condition = JSParenthesesUtils.stripParentheses(condition);
            if (condition == null || !BoolUtils.isNegation(condition) && !this.isNotEquals(condition)) {
                return;
            }
            this.registerError((PsiElement)exp);
        }

        private boolean isNotEquals(JSExpression expression) {
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType sign = binaryExpression.getOperationSign();
            return JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign);
        }
    }

    private static class NegatedConditionalFix
    extends InspectionJSFix {
        private NegatedConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("invert.condition.fix", new Object[0]);
            if (string == null) {
                NegatedConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            JSConditionalExpression exp = (JSConditionalExpression)descriptor2.getPsiElement();
            assert (exp != null);
            JSExpression elseBranch = exp.getElse();
            JSExpression thenBranch = exp.getThen();
            JSExpression condition = exp.getCondition();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition);
            assert (elseBranch != null);
            assert (thenBranch != null);
            String newStatement = negatedCondition + '?' + elseBranch.getText() + ':' + thenBranch.getText();
            NegatedConditionalFix.replaceExpression((JSExpression)exp, newStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedConditionalExpressionJSInspection$NegatedConditionalFix", "getFamilyName"));
        }
    }
}

