/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.minimatch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.minimatch.DefaultPathAdapter;
import com.intellij.util.text.minimatch.GlobStar;
import com.intellij.util.text.minimatch.LiteralItem;
import com.intellij.util.text.minimatch.MagicItem;
import com.intellij.util.text.minimatch.MinimatchKt;
import com.intellij.util.text.minimatch.MinimatchOptions;
import com.intellij.util.text.minimatch.ParseContext;
import com.intellij.util.text.minimatch.ParseItem;
import com.intellij.util.text.minimatch.ParseResult;
import com.intellij.util.text.minimatch.PathAdapter;
import com.intellij.util.text.minimatch.PatternListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJG\u0010\u001d\u001a.\u0012*\u0012(\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00030\u0003 \u001e*\u0014\u0012\u000e\b\u0001\u0012\n \u001e*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00130\u00130\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0010H\u0002J3\u0010#\u001a\u00020\b\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u0002H$2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'2\b\b\u0002\u0010(\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010)J\u001a\u0010#\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\bH\u0007J\u001e\u0010#\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00102\b\b\u0002\u0010(\u001a\u00020\bJ,\u0010,\u001a\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0\u00102\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010(\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u00020\bH\u0002J\b\u00101\u001a\u00020\u0003H\u0016J\u001c\u00101\u001a\u00020+2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/util/text/minimatch/Minimatch;", "", "pattern", "", "options", "Lcom/intellij/util/text/minimatch/MinimatchOptions;", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)V", "comment", "", "empty", "negate", "getNegate", "()Z", "getOptions", "()Lcom/intellij/util/text/minimatch/MinimatchOptions;", "set", "", "Lcom/intellij/util/text/minimatch/ParseItem;", "braceExpand", "", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)[Ljava/lang/String;", "clearStateChar", "", "ctx", "Lcom/intellij/util/text/minimatch/ParseContext;", "equals", "other", "expand", "(Ljava/lang/String;)[Ljava/lang/String;", "globParts", "kotlin.jvm.PlatformType", "([Ljava/lang/String;)Ljava/util/List;", "hashCode", "", "make", "match", "T", "input", "adapter", "Lcom/intellij/util/text/minimatch/PathAdapter;", "partial", "(Ljava/lang/Object;Lcom/intellij/util/text/minimatch/PathAdapter;Z)Z", "path", "", "matchOne", "file", "parse", "Lcom/intellij/util/text/minimatch/ParseResult;", "isSub", "toString", "intellij.javascript.impl"})
public final class Minimatch {
    private final boolean comment;
    private final boolean empty = false;
    private final boolean negate;
    private final List<List<ParseItem>> set;
    private final String pattern;
    @NotNull
    private final MinimatchOptions options;

    public final boolean getNegate() {
        return this.negate;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<ParseItem>> make() {
        List list2;
        Object object;
        Object object2;
        Object[] set = this.braceExpand(this.pattern, this.options);
        Logger $this$debug$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object2 = $this$debug$iv;
            boolean bl = false;
            object = this.pattern + ' ' + Arrays.toString(set);
            object2.debug((String)object, (Throwable)e$iv);
        }
        List<String[]> globParts = this.globParts((String[])set);
        Logger $this$debug$iv2 = MinimatchKt.access$getLOG$p();
        Exception e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            object2 = $this$debug$iv2;
            boolean bl = false;
            object = this.pattern + ' ' + this.toString(globParts);
            object2.debug((String)object, (Throwable)e$iv2);
        }
        Collection $this$mapSmart$iv = globParts;
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.size();
        switch (size$iv) {
            case 1: {
                List list3;
                List list4;
                String[] it = (String[])CollectionsKt.first((Iterable)$this$mapSmart$iv);
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                String[] $this$mapSmart$iv2 = it;
                boolean $i$f$mapSmart2 = false;
                int size$iv2 = $this$mapSmart$iv2.length;
                switch (size$iv2) {
                    case 1: {
                        ParseItem parseItem;
                        String it2 = $this$mapSmart$iv2[0];
                        boolean bl2 = false;
                        String string = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                        ParseItem parseItem2 = parseItem = this.parse(string, false).getItem();
                        list4 = (List)new SmartList((Object)parseItem2);
                        break;
                    }
                    case 0: {
                        list4 = (List)new SmartList();
                        break;
                    }
                    default: {
                        void $this$mapTo$iv$iv;
                        String[] stringArray = $this$mapSmart$iv2;
                        Collection destination$iv$iv2 = new ArrayList(size$iv2);
                        boolean $i$f$mapTo = false;
                        void var20_37 = $this$mapTo$iv$iv;
                        int it2 = ((void)var20_37).length;
                        for (int i = 0; i < it2; ++i) {
                            void it3;
                            void item$iv$iv;
                            void var22_46 = item$iv$iv = var20_37[i];
                            Collection collection = destination$iv$iv2;
                            boolean bl3 = false;
                            void v2 = it3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                            ParseItem parseItem = this.parse((String)v2, false).getItem();
                            collection.add(parseItem);
                        }
                        list4 = (List)destination$iv$iv2;
                    }
                }
                List list5 = list3 = list4;
                list2 = (List)new SmartList((Object)list5);
                break;
            }
            case 0: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                Iterable iterable = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    List list6;
                    void $this$mapSmart$iv3;
                    void it;
                    String[] bl = (String[])item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean $i$a$-mapSmart-Minimatch$make$results$2 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    boolean $i$f$mapSmart3 = false;
                    int size$iv3 = ((void)$this$mapSmart$iv3).length;
                    switch (size$iv3) {
                        case 1: {
                            ParseItem parseItem;
                            void it4 = $this$mapSmart$iv3[0];
                            boolean bl4 = false;
                            void v4 = it4;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                            ParseItem parseItem3 = parseItem = this.parse((String)v4, false).getItem();
                            list6 = (List)new SmartList((Object)parseItem3);
                            break;
                        }
                        case 0: {
                            list6 = (List)new SmartList();
                            break;
                        }
                        default: {
                            void $this$mapTo$iv$iv2;
                            void destination$iv$iv2 = $this$mapSmart$iv3;
                            Collection destination$iv$iv3 = new ArrayList(size$iv3);
                            boolean $i$f$mapTo2 = false;
                            void var21_45 = $this$mapTo$iv$iv2;
                            int n = ((void)var21_45).length;
                            for (int i = 0; i < n; ++i) {
                                void it5;
                                void item$iv$iv2;
                                void bl3 = item$iv$iv2 = var21_45[i];
                                Collection collection = destination$iv$iv3;
                                boolean $i$a$-mapSmart-Minimatch$make$results$1$2 = false;
                                void v6 = it5;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                                ParseItem parseItem = this.parse((String)v6, false).getItem();
                                collection.add(parseItem);
                            }
                            list6 = (List)destination$iv$iv3;
                        }
                    }
                    object = list6;
                    object2.add(object);
                }
                list2 = (List)destination$iv$iv;
            }
        }
        List results = list2;
        Logger $this$debug$iv3 = MinimatchKt.access$getLOG$p();
        Exception e$iv3 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object2 = $this$debug$iv3;
            boolean bl = false;
            object = this.pattern + ' ' + results;
            object2.debug((String)object, (Throwable)e$iv3);
        }
        return results;
    }

    private final CharSequence toString(List<String[]> globParts) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object[] objectArray : globParts) {
            sb.append(Arrays.toString(objectArray));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String[]> globParts(String[] set) {
        List list2;
        String[] $this$mapSmart$iv = set;
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.length;
        switch (size$iv) {
            case 1: {
                String[] stringArray;
                String it = $this$mapSmart$iv[0];
                boolean bl = false;
                String[] stringArray2 = stringArray = MinimatchKt.access$getSlashSplit$p().split(it, Integer.MAX_VALUE);
                list2 = (List)new SmartList((Object)stringArray2);
                break;
            }
            case 0: {
                list2 = (List)new SmartList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                String[] stringArray = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                void var5_6 = $this$mapTo$iv$iv;
                int n = ((void)var5_6).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_16 = item$iv$iv = var5_6[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String[] stringArray3 = MinimatchKt.access$getSlashSplit$p().split((CharSequence)it, Integer.MAX_VALUE);
                    collection.add(stringArray3);
                }
                list2 = (List)destination$iv$iv;
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final ParseResult parse(String pattern, boolean isSub) {
        boolean bl;
        int $i$f$debug22;
        boolean bl2;
        String string;
        CharSequence charSequence;
        Object object;
        char c22;
        if (!this.options.getNoglobstar() && Intrinsics.areEqual((Object)"**", (Object)pattern)) {
            return new ParseResult(MinimatchKt.access$getGLOBSTAR$p(), false);
        }
        CharSequence charSequence2 = pattern;
        boolean bl3 = false;
        if (charSequence2.length() == 0) {
            return new ParseResult(ParseItem.Empty, false);
        }
        ParseContext ctx = new ParseContext();
        ctx.re = "";
        ctx.hasMagic = this.options.getNocase();
        boolean escaping = false;
        Stack patternListStack = new Stack();
        Stack negativeListStack = new Stack();
        char plType = '\u0000';
        boolean inClass = false;
        int reClassStart = -1;
        int classStart = -1;
        String patternStart = pattern.charAt(0) == '.' ? "" : (this.options.getDot() ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)");
        int n = 0;
        int n2 = pattern.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                c22 = pattern.charAt((int)i);
                Logger $this$debug$iv = MinimatchKt.access$getLOG$p();
                Object e$iv = null;
                int $i$f$debug = 0;
                if ($this$debug$iv.isDebugEnabled()) {
                    object = $this$debug$iv;
                    boolean bl4 = false;
                    charSequence = pattern + '\t' + (int)i + ' ' + ctx.re + " \"" + c22 + '\"';
                    object.debug((String)charSequence, (Throwable)e$iv);
                }
                if (escaping && StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", (char)c22, (boolean)false, (int)2, null)) {
                    ctx.re = ctx.re + "\\" + c22;
                    escaping = false;
                } else {
                    switch (c22) {
                        case '/': {
                            throw (Throwable)new IllegalStateException();
                        }
                        case '\\': {
                            this.clearStateChar(ctx);
                            escaping = true;
                            break;
                        }
                        case '!': 
                        case '*': 
                        case '+': 
                        case '?': 
                        case '@': {
                            $this$debug$iv = MinimatchKt.access$getLOG$p();
                            e$iv = null;
                            $i$f$debug = 0;
                            if ($this$debug$iv.isDebugEnabled()) {
                                object = $this$debug$iv;
                                boolean bl5 = false;
                                charSequence = pattern + '\t' + (int)i + ' ' + ctx.re + " \"" + c22 + "\" <-- stateChar";
                                object.debug((String)charSequence, (Throwable)e$iv);
                            }
                            if (inClass) {
                                MinimatchKt.access$getLOG$p().debug("  in class");
                                if (c22 == '!' && i == classStart + 1) {
                                    c22 = '^';
                                }
                                ctx.re = ctx.re + c22;
                                break;
                            }
                            $this$debug$iv = MinimatchKt.access$getLOG$p();
                            e$iv = null;
                            $i$f$debug = 0;
                            if ($this$debug$iv.isDebugEnabled()) {
                                object = $this$debug$iv;
                                boolean bl6 = false;
                                charSequence = "call clearStateChar \"" + ctx.stateChar + '\"';
                                object.debug((String)charSequence, (Throwable)e$iv);
                            }
                            this.clearStateChar(ctx);
                            ctx.stateChar = Character.valueOf(c22);
                            if (!this.options.getNoext()) break;
                            this.clearStateChar(ctx);
                            break;
                        }
                        case '(': {
                            int n3;
                            if (inClass) {
                                ctx.re = ctx.re + "(";
                                break;
                            }
                            if (ctx.stateChar == null) {
                                ctx.re = ctx.re + "\\(";
                                break;
                            }
                            Character c = ctx.stateChar;
                            if (c == null) {
                                Intrinsics.throwNpe();
                            }
                            plType = c.charValue();
                            patternListStack.push((Object)new PatternListItem(plType, (int)(i - true), ctx.re.length(), 0, 8, null));
                            Character c3 = ctx.stateChar;
                            ctx.re = ctx.re + (c3 != null && c3.charValue() == '!' ? "(?:(?!(?:" : "(?:");
                            $this$debug$iv = MinimatchKt.access$getLOG$p();
                            e$iv = null;
                            $i$f$debug = 0;
                            if ($this$debug$iv.isDebugEnabled()) {
                                object = $this$debug$iv;
                                n3 = 0;
                                charSequence = "plType \"" + ctx.stateChar + "\" \"" + ctx.re + '\"';
                                object.debug((String)charSequence, (Throwable)e$iv);
                            }
                            ctx.stateChar = null;
                            break;
                        }
                        case ')': {
                            if (inClass || patternListStack.isEmpty()) {
                                ctx.re = ctx.re + "\\)";
                                break;
                            }
                            this.clearStateChar(ctx);
                            ctx.hasMagic = true;
                            ctx.re = ctx.re + ")";
                            PatternListItem pl = (PatternListItem)patternListStack.pop();
                            plType = pl.getType();
                            switch (plType) {
                                case '!': {
                                    negativeListStack.push((Object)pl);
                                    ctx.re = ctx.re + ")[^/]*?)";
                                    pl.setReEnd(ctx.re.length());
                                    break;
                                }
                                case '*': 
                                case '+': 
                                case '?': {
                                    ctx.re = ctx.re + plType;
                                }
                            }
                            break;
                        }
                        case '|': {
                            if (inClass || patternListStack.size() == 0 || escaping) {
                                ctx.re = ctx.re + "\\|";
                                escaping = false;
                                break;
                            }
                            this.clearStateChar(ctx);
                            ctx.re = ctx.re + '|';
                            break;
                        }
                        case '[': {
                            this.clearStateChar(ctx);
                            if (inClass) {
                                ctx.re = ctx.re + '\\' + c22;
                                break;
                            }
                            inClass = true;
                            classStart = i;
                            reClassStart = ctx.re.length();
                            ctx.re = ctx.re + c22;
                            break;
                        }
                        case ']': {
                            int n3;
                            if (i == classStart + 1 || !inClass) {
                                ctx.re = ctx.re + "\\" + c22;
                                escaping = false;
                                break;
                            }
                            if (inClass) {
                                String cs;
                                e$iv = pattern;
                                $i$f$debug = classStart + 1;
                                boolean bl7 = false;
                                Object object2 = e$iv;
                                if (object2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)((String)object2).substring($i$f$debug, (int)i), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                try {
                                    Pattern.compile('[' + cs + ']');
                                }
                                catch (Throwable e) {
                                    ParseResult sp = this.parse(cs, true);
                                    String string2 = ctx.re;
                                    n3 = 0;
                                    charSequence = new StringBuilder();
                                    object = ctx;
                                    boolean bl8 = false;
                                    String string3 = string2;
                                    if (string3 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n3, reClassStart), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    ((ParseContext)object).re = ((StringBuilder)charSequence).append(string).append("\\[").append(sp.getItem().getSource()).append("\\]").toString();
                                    ctx.hasMagic = ctx.hasMagic || sp.isB();
                                    inClass = false;
                                    break;
                                }
                            }
                            ctx.hasMagic = true;
                            inClass = false;
                            ctx.re = ctx.re + c22;
                            break;
                        }
                        default: {
                            this.clearStateChar(ctx);
                            if (escaping) {
                                escaping = false;
                            } else if (StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", (char)c22, (boolean)false, (int)2, null) && (c22 != '^' || !inClass)) {
                                ctx.re = ctx.re + "\\";
                            }
                            ctx.re = ctx.re + c22;
                        }
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (inClass) {
            String string4 = pattern;
            c22 = classStart + 1;
            int cs = 0;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(c22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String cs2 = string6;
            ParseResult sp = this.parse(cs2, true);
            String c22 = ctx.re;
            cs = 0;
            charSequence = new StringBuilder();
            object = ctx;
            boolean e = false;
            String string7 = c22;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(cs, reClassStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string8;
            ((ParseContext)object).re = ((StringBuilder)charSequence).append(string).append("\\[").append(sp.getItem().getSource()).toString();
            boolean bl9 = ctx.hasMagic = ctx.hasMagic || sp.isB();
        }
        while (!patternListStack.isEmpty()) {
            int n4;
            PatternListItem pl = (PatternListItem)patternListStack.pop();
            String c22 = ctx.re;
            int cs = pl.getReStart() + 3;
            boolean e = false;
            String string9 = c22;
            if (string9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(cs);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            charSequence = string10;
            CharSequence tail = charSequence;
            Pattern p = Pattern.compile("((?:\\\\{2})*)(\\\\?)\\|");
            Matcher m = p.matcher(tail);
            StringBuilder sb22 = new StringBuilder();
            int lastEnd22 = 0;
            while (m.find()) {
                String g1 = m.group(1);
                String g2 = m.group(2);
                CharSequence charSequence3 = g2;
                n4 = 0;
                bl2 = false;
                if (charSequence3 == null || charSequence3.length() == 0) {
                    g2 = "\\";
                }
                charSequence3 = tail;
                n4 = m.start();
                object = sb22;
                bl2 = false;
                charSequence = ((Object)charSequence3.subSequence(lastEnd22, n4)).toString();
                ((StringBuilder)object).append((String)charSequence);
                sb22.append(g1).append(g1).append(g2).append("|");
                lastEnd22 = m.end();
            }
            sb22.append(tail, lastEnd22, tail.length());
            tail = sb22;
            Logger $this$debug$iv = MinimatchKt.access$getLOG$p();
            Object e$iv22 = null;
            $i$f$debug22 = 0;
            if ($this$debug$iv.isDebugEnabled()) {
                object = $this$debug$iv;
                bl = false;
                charSequence = "tail=" + tail;
                object.debug((String)charSequence, (Throwable)e$iv22);
            }
            String t22 = '*' == pl.getType() ? MinimatchKt.access$getSTAR$p() : ('?' == pl.getType() ? "[^/]" : "\\" + pl.getType());
            ctx.hasMagic = true;
            e$iv22 = ctx.re;
            $i$f$debug22 = 0;
            n4 = pl.getReStart();
            charSequence = new StringBuilder();
            object = ctx;
            bl = false;
            Object object3 = e$iv22;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object3).substring($i$f$debug22, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            ((ParseContext)object).re = ((StringBuilder)charSequence).append(string).append(t22).append("\\(").append(tail).toString();
        }
        this.clearStateChar(ctx);
        if (escaping) {
            ctx.re = ctx.re + "\\\\";
        }
        boolean addPatternStart = false;
        switch (ctx.re.charAt(0)) {
            case '(': 
            case '.': 
            case '[': {
                addPatternStart = true;
            }
        }
        while (!negativeListStack.isEmpty()) {
            String nlFirst;
            Collection thisCollection$iv;
            List list2;
            boolean bl10;
            CharSequence charSequence4;
            String nlBefore;
            PatternListItem nl = (PatternListItem)negativeListStack.pop();
            String m = ctx.re;
            int sb22 = 0;
            int lastEnd22 = nl.getReStart();
            int t22 = 0;
            String string11 = m;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string11.substring(sb22, lastEnd22), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String sb22 = ctx.re;
            lastEnd22 = nl.getReStart();
            t22 = nl.getReEnd() - 8;
            int e$iv22 = 0;
            String string12 = sb22;
            if (string12 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string12.substring(lastEnd22, t22), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String lastEnd22 = ctx.re;
            t22 = nl.getReEnd() - 8;
            e$iv22 = nl.getReEnd();
            $i$f$debug22 = 0;
            String string13 = lastEnd22;
            if (string13 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string14 = string13.substring(t22, e$iv22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String nlLast = string14;
            String t22 = ctx.re;
            e$iv22 = nl.getReEnd();
            $i$f$debug22 = 0;
            String string15 = t22;
            if (string15 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string16 = string15.substring(e$iv22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"(this as java.lang.String).substring(startIndex)");
            String nlAfter = string16;
            nlLast = nlLast + nlAfter;
            CharSequence e$iv22 = nlBefore;
            Regex $i$f$debug22 = new Regex("\\(");
            int n5 = 0;
            bl = false;
            List $this$dropLastWhile$iv = $i$f$debug22.split(e$iv22, n5);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p1 = (String)iterator$iv.previous();
                    boolean bl11 = false;
                    charSequence4 = p1;
                    bl10 = false;
                    if (charSequence4.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list2;
            int $i$f$toTypedArray = 0;
            if ($this$toTypedArray$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int openParensBefore = stringArray.length - 1;
            String cleanAfter = nlAfter;
            $i$f$toTypedArray = 0;
            int n6 = openParensBefore - 1;
            if ($i$f$toTypedArray <= n6) {
                while (true) {
                    void i;
                    CharSequence charSequence5 = cleanAfter;
                    Regex regex = new Regex("\\)[+*?]?");
                    charSequence4 = "";
                    bl10 = false;
                    cleanAfter = regex.replace(charSequence5, (String)charSequence4);
                    if (i == n6) break;
                    ++i;
                }
            }
            nlAfter = cleanAfter;
            String dollar = "";
            CharSequence charSequence6 = nlAfter;
            bl2 = false;
            if (charSequence6.length() == 0 && !isSub) {
                dollar = "$";
            }
            ctx.re = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        CharSequence charSequence7 = ctx.re;
        boolean bl12 = false;
        if (!(charSequence7.length() == 0) && ctx.hasMagic) {
            ctx.re = "(?=.)" + ctx.re;
        }
        if (addPatternStart) {
            ctx.re = patternStart + ctx.re;
        }
        if (isSub) {
            return new ParseResult(new LiteralItem(ctx.re), ctx.hasMagic);
        }
        if (!ctx.hasMagic) {
            return new ParseResult(new LiteralItem(MinimatchKt.globUnescape(pattern)), false);
        }
        return new ParseResult(new MagicItem(ctx.re, this.options), false);
    }

    private final void clearStateChar(ParseContext ctx) {
        if (ctx.stateChar != null) {
            Character c;
            Character c2 = c = ctx.stateChar;
            if (c2 != null && c2.charValue() == '*') {
                ctx.re = ctx.re + MinimatchKt.access$getSTAR$p();
                ctx.hasMagic = true;
            } else {
                Character c3 = c;
                if (c3 != null && c3.charValue() == '?') {
                    ctx.re = ctx.re + "[^/]";
                    ctx.hasMagic = true;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append(ctx.re).append('\\');
                    Character c4 = ctx.stateChar;
                    if (c4 == null) {
                        Intrinsics.throwNpe();
                    }
                    ctx.re = stringBuilder.append(c4.charValue()).toString();
                }
            }
            Logger $this$debug$iv = MinimatchKt.access$getLOG$p();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "clearStateChar \"" + ctx.stateChar + "\" \"" + ctx.re + '\"';
                logger.debug(string, (Throwable)e$iv);
            }
            ctx.stateChar = null;
        }
    }

    private final String[] braceExpand(String pattern, MinimatchOptions options) {
        String[] stringArray;
        if (options.getNobrace() || !MinimatchKt.access$getHasBraces$p().matcher(pattern).matches()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = pattern;
        } else {
            stringArray = this.expand(pattern);
        }
        return stringArray;
    }

    private final String[] expand(String pattern) {
        return new String[]{pattern};
    }

    public final boolean match(@NotNull List<? extends CharSequence> path, boolean partial) {
        int i;
        Intrinsics.checkParameterIsNotNull(path, (String)"path");
        Logger $this$debug$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = this.pattern + " set " + this.set;
            logger.debug(string, (Throwable)e$iv);
        }
        CharSequence filename = null;
        for (i = path.size() - 1; i >= 0; --i) {
            CharSequence $i$f$debug2 = filename = path.get(i);
            boolean bl = false;
            if (!($i$f$debug2.length() == 0)) break;
        }
        for (i = 0; i < this.set.size(); ++i) {
            List<ParseItem> pattern = this.set.get(i);
            List file2 = path;
            if (this.options.getMatchBase() && pattern.size() == 1) {
                CharSequence charSequence = filename;
                if (charSequence == null) {
                    Intrinsics.throwNpe();
                }
                file2 = (List)new SmartList((Object)charSequence);
            }
            if (!this.matchOne(file2, pattern, partial)) continue;
            return this.options.getFlipNegate() || !this.negate;
        }
        if (this.options.getFlipNegate()) {
            return false;
        }
        return this.negate;
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return minimatch.match(list2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchOne(List<? extends CharSequence> file2, List<? extends ParseItem> pattern, boolean partial) {
        int pi;
        String string;
        Logger logger;
        Logger $this$debug$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            string = "matchOne\n\tOptions: " + this.options + "\n\tfile: " + file2 + "\n\tpattern: " + pattern;
            logger.debug(string, (Throwable)e$iv);
        }
        $this$debug$iv = MinimatchKt.access$getLOG$p();
        e$iv = null;
        $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            string = "matchOne " + file2.size() + ' ' + pattern.size();
            logger.debug(string, (Throwable)e$iv);
        }
        int fi = 0;
        int fl = file2.size();
        int pl = pattern.size();
        for (pi = 0; fi < fl && pi < pl; ++fi, ++pi) {
            ParseItem p = pattern.get(pi);
            CharSequence f = file2.get(fi);
            Logger $this$debug$iv2 = MinimatchKt.access$getLOG$p();
            Exception e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                logger = $this$debug$iv2;
                boolean bl = false;
                string = "" + pattern + ' ' + p + ' ' + f;
                logger.debug(string, (Throwable)e$iv2);
            }
            if (p instanceof GlobStar) {
                $this$debug$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                $i$f$debug2 = false;
                if ($this$debug$iv2.isDebugEnabled()) {
                    logger = $this$debug$iv2;
                    boolean bl = false;
                    string = "GLOBSTAR [" + pattern + ", " + p + ", " + f + ']';
                    logger.debug(string, (Throwable)e$iv2);
                }
                int fr = fi;
                int pr = pi + 1;
                if (pr == pl) {
                    MinimatchKt.access$getLOG$p().debug("** at the end");
                    while (fi < fl) {
                        CharSequence item = file2.get(fi);
                        if (Intrinsics.areEqual((Object)item, (Object)".")) return false;
                        if (Intrinsics.areEqual((Object)item, (Object)"..")) return false;
                        if (!this.options.getDot() && StringsKt.startsWith$default((CharSequence)item, (char)'.', (boolean)false, (int)2, null)) {
                            return false;
                        }
                        ++fi;
                    }
                    return true;
                }
                while (fr < fl) {
                    CharSequence swallowee = file2.get(fr);
                    Logger $this$debug$iv3 = MinimatchKt.access$getLOG$p();
                    Exception e$iv3 = null;
                    boolean $i$f$debug3 = false;
                    if ($this$debug$iv3.isDebugEnabled()) {
                        logger = $this$debug$iv3;
                        boolean bl = false;
                        string = "\nglobstar while " + file2 + ' ' + fr + ' ' + pattern + ' ' + pr + ' ' + swallowee;
                        logger.debug(string, (Throwable)e$iv3);
                    }
                    if (this.matchOne(file2.subList(fr, file2.size()), pattern.subList(pr, pattern.size()), partial)) {
                        $this$debug$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        $i$f$debug3 = false;
                        if (!$this$debug$iv3.isDebugEnabled()) return true;
                        logger = $this$debug$iv3;
                        boolean bl = false;
                        string = "globstar found match! " + fr + ' ' + fl + ' ' + swallowee;
                        logger.debug(string, (Throwable)e$iv3);
                        return true;
                    }
                    if (Intrinsics.areEqual((Object)swallowee, (Object)".") || Intrinsics.areEqual((Object)swallowee, (Object)"..") || !this.options.getDot() && StringsKt.startsWith$default((CharSequence)swallowee, (char)'.', (boolean)false, (int)2, null)) {
                        $this$debug$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        $i$f$debug3 = false;
                        if (!$this$debug$iv3.isDebugEnabled()) break;
                        logger = $this$debug$iv3;
                        boolean bl = false;
                        string = "dot detected! " + file2 + ' ' + fr + ' ' + pattern + ' ' + pr;
                        logger.debug(string, (Throwable)e$iv3);
                        break;
                    }
                    MinimatchKt.access$getLOG$p().debug("globstar swallow a segment, and continue");
                    int $this$debug$iv22 = fr;
                    fr = $this$debug$iv22 + 1;
                }
                if (!partial) return false;
                Logger $this$debug$iv4 = MinimatchKt.access$getLOG$p();
                Exception e$iv4 = null;
                boolean $i$f$debug4 = false;
                if ($this$debug$iv4.isDebugEnabled()) {
                    logger = $this$debug$iv4;
                    boolean bl = false;
                    string = "\n>>> no match, partial? " + file2 + ' ' + fr + ' ' + pattern + ' ' + pr;
                    logger.debug(string, (Throwable)e$iv4);
                }
                if (fr != fl) return false;
                return true;
            }
            if (!p.match(f, this.options)) {
                $this$debug$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                $i$f$debug2 = false;
                if (!$this$debug$iv2.isDebugEnabled()) return false;
                logger = $this$debug$iv2;
                boolean bl = false;
                string = "pattern match " + p + ' ' + f + " false";
                logger.debug(string, (Throwable)e$iv2);
                return false;
            }
            $this$debug$iv2 = MinimatchKt.access$getLOG$p();
            e$iv2 = null;
            $i$f$debug2 = false;
            if (!$this$debug$iv2.isDebugEnabled()) continue;
            logger = $this$debug$iv2;
            boolean bl = false;
            string = "pattern match " + p + ' ' + f + " true";
            logger.debug(string, (Throwable)e$iv2);
        }
        if (fi == fl && pi == pl) {
            return true;
        }
        if (fi == fl) {
            return partial;
        }
        if (pi != pl) throw (Throwable)new IllegalStateException("");
        if (fi != fl - 1) return false;
        CharSequence charSequence = file2.get(fi);
        boolean bl = false;
        if (charSequence.length() != 0) return false;
        return true;
    }

    @JvmOverloads
    public final boolean match(@NotNull String input, boolean partial) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.match(input, DefaultPathAdapter.INSTANCE, partial);
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return minimatch.match(string, bl);
    }

    @JvmOverloads
    public final boolean match(@NotNull String input) {
        return Minimatch.match$default(this, input, false, 2, null);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter, boolean partial) {
        String string;
        Logger logger;
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        Logger $this$debug$iv = MinimatchKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            string = "match " + input + ' ' + this.pattern;
            logger.debug(string, (Throwable)e$iv);
        }
        if (this.comment) {
            return false;
        }
        List<String> file2 = adapter.toArray(input, this.options);
        if (this.empty) {
            return file2.isEmpty();
        }
        Logger $this$debug$iv2 = MinimatchKt.access$getLOG$p();
        Exception e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            logger = $this$debug$iv2;
            boolean bl = false;
            string = this.pattern + " split " + file2;
            logger.debug(string, (Throwable)e$iv2);
        }
        return this.match(file2, partial);
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, Object object, PathAdapter pathAdapter, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return minimatch.match(object, pathAdapter, bl);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter) {
        return Minimatch.match$default(this, input, adapter, false, 4, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.text.minimatch.Minimatch");
        }
        Minimatch cfr_ignored_0 = (Minimatch)object2;
        if (Intrinsics.areEqual((Object)this.options, (Object)((Minimatch)other).options) ^ true) {
            return false;
        }
        if (this.comment != ((Minimatch)other).comment) {
            return false;
        }
        if (this.empty != ((Minimatch)other).empty) {
            return false;
        }
        if (this.negate != ((Minimatch)other).negate) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.pattern, (Object)((Minimatch)other).pattern) ^ true);
    }

    public int hashCode() {
        int result2 = this.options.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.comment);
        result2 = 31 * result2 + Boolean.hashCode(this.empty);
        result2 = 31 * result2 + Boolean.hashCode(this.negate);
        result2 = 31 * result2 + this.pattern.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.pattern;
    }

    @NotNull
    public final MinimatchOptions getOptions() {
        return this.options;
    }

    @JvmOverloads
    public Minimatch(@NotNull String pattern, @NotNull MinimatchOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.options = options;
        String normalizedPattern = this.options.getAllowWindowsPaths() ? MinimatchKt.replaceEscapedBackSlash(pattern) : pattern;
        boolean bl = this.comment = !this.options.getNocomment() && StringsKt.startsWith$default((CharSequence)normalizedPattern, (char)'#', (boolean)false, (int)2, null);
        if (this.comment) {
            this.pattern = normalizedPattern;
            this.set = CollectionsKt.emptyList();
            this.negate = false;
        } else {
            if (this.options.getNonegate()) {
                this.pattern = normalizedPattern;
                this.negate = false;
            } else {
                String string;
                int negateOffset;
                boolean negate = false;
                for (negateOffset = 0; negateOffset < pattern.length() && pattern.charAt(negateOffset) == '!'; ++negateOffset) {
                    negate = !negate;
                }
                this.negate = negate;
                Minimatch minimatch = this;
                if (negateOffset > 0) {
                    String string2 = pattern;
                    Minimatch minimatch2 = minimatch;
                    boolean bl2 = false;
                    String string3 = string2.substring(negateOffset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String string4 = string3;
                    minimatch = minimatch2;
                    string = string4;
                } else {
                    string = pattern;
                }
                minimatch.pattern = string;
            }
            this.set = this.make();
        }
    }

    public /* synthetic */ Minimatch(String string, MinimatchOptions minimatchOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            minimatchOptions = new MinimatchOptions(false, false, false, false, false, false, false, false, false, false, 1023, null);
        }
        this(string, minimatchOptions);
    }

    @JvmOverloads
    public Minimatch(@NotNull String pattern) {
        this(pattern, null, 2, null);
    }
}

