/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.JSCompilingVisitor;
import com.intellij.structuralsearch.JSExprTypePredicate;
import com.intellij.structuralsearch.JSMatchingStrategy;
import com.intellij.structuralsearch.JSMatchingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralSearchProfile
extends StructuralSearchProfile {
    private static final String TYPED_VAR_PREFIX = "__$_";

    @NotNull
    public CompiledPattern createCompiledPattern() {
        CompiledPattern compiledPattern = new CompiledPattern(){
            {
                this.setStrategy(JSMatchingStrategy.getInstance());
            }

            public String[] getTypedVarPrefixes() {
                return new String[]{JSStructuralSearchProfile.TYPED_VAR_PREFIX};
            }

            public boolean isTypedVar(String str) {
                return str.startsWith(JSStructuralSearchProfile.TYPED_VAR_PREFIX);
            }
        };
        if (compiledPattern == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        return compiledPattern;
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        if (element instanceof JSExpressionStatement) {
            String string = StringUtil.trimEnd((String)element.getText(), (char)';');
            if (string == null) {
                JSStructuralSearchProfile.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = super.getTypedVarString(element);
        if (string == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> JSStructuralSearchProfile.isLexicalNode(element);
        if (nodeFilter == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return nodeFilter;
    }

    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        new JSCompilingVisitor(globalVisitor).compile(elements);
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        JSMatchingVisitor jSMatchingVisitor = new JSMatchingVisitor(globalVisitor);
        if (jSMatchingVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        return jSMatchingVisitor;
    }

    static boolean isLexicalNode(@NotNull PsiElement element) {
        if (element == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (!(element instanceof LeafElement)) {
            return false;
        }
        IElementType type = ((LeafElement)element).getElementType();
        return type == JSTokenTypes.COMMA || type == JSTokenTypes.SEMICOLON;
    }

    static boolean canBePatternVariable(PsiElement element) {
        ASTNode node;
        PsiElement child = element.getFirstChild();
        if (child == null) {
            return true;
        }
        if ((element instanceof JSReferenceExpression || element instanceof JSParameter) && (node = child.getNode()) != null) {
            return node.getElementType() == JSTokenTypes.IDENTIFIER && child.getNextSibling() == null;
        }
        return false;
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        return language instanceof JavascriptLanguage || language instanceof JSLanguageDialect;
    }

    public boolean isIdentifier(@Nullable PsiElement element) {
        return element != null && element.getNode().getElementType() == JSTokenTypes.IDENTIFIER;
    }

    public List<MatchPredicate> getCustomPredicates(MatchVariableConstraint constraint, String name, MatchOptions options) {
        SmartList result2 = new SmartList();
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfExprType())) {
            JSExprTypePredicate predicate = new JSExprTypePredicate(constraint.getNameOfExprType(), constraint.isExprTypeWithinHierarchy(), options.isCaseSensitiveMatch());
            result2.add(constraint.isInvertExprType() ? new NotPredicate((MatchPredicate)predicate) : predicate);
        }
        return result2;
    }

    public boolean isApplicableConstraint(String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        if (constraintName.equals("TYPE")) {
            PsiElement parent;
            return variableNode != null && ((parent = variableNode.getParent()) instanceof JSExpression || parent instanceof JSFunction || parent instanceof JSVariable);
        }
        return super.isApplicableConstraint(constraintName, variableNode, completePattern, target);
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        if (JavaScriptCodeContextType.class == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        return JavaScriptCodeContextType.class;
    }

    public void checkSearchPattern(CompiledPattern pattern) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        MatchOptions matchOptions = options.getMatchOptions();
        LanguageFileType fileType = matchOptions.getFileType();
        Language dialect = matchOptions.getDialect();
        boolean searchIsExpression = this.isProbableExpression(matchOptions.getSearchPattern(), fileType, dialect, project);
        boolean replacementIsExpression = this.isProbableExpression(options.getReplacement(), fileType, dialect, project);
        boolean targetFound = false;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (!constraint.isPartOfSearchResults()) continue;
            targetFound = true;
            break;
        }
        if (!targetFound && searchIsExpression != replacementIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message((String)"replacement.template.is.not.expression.error.message", (Object[])new Object[0]) : SSRBundle.message((String)"search.template.is.not.expression.error.message", (Object[])new Object[0]));
        }
    }

    private boolean isProbableExpression(String pattern, LanguageFileType fileType, Language dialect, Project project) {
        PsiElement[] searchElements = this.createPatternTree(pattern, PatternTreeContext.File, fileType, dialect, null, project, false);
        if (searchElements.length != 1) {
            return false;
        }
        PsiElement element = searchElements[0];
        if (!(element instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement lastChild = element.getLastChild();
        return !(lastChild instanceof LeafPsiElement) || ((LeafPsiElement)lastChild).getElementType() != JSTokenTypes.SEMICOLON;
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (replaceOptions == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        return new DocumentBasedReplaceHandler(project);
    }

    public Configuration[] getPredefinedTemplates() {
        String general = "JavaScript/General";
        String suspicious = "JavaScript/Suspicious";
        return new Configuration[]{PredefinedConfigurationUtil.createSearchTemplateInfo((String)"anonymous functions", (String)"var '_name = function('_parameter*) {\n  '_statement*;\n}", (String)"JavaScript/General", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"functions", (String)"function '_name('_parameter*) {\n  '_statement*;\n}", (String)"JavaScript/General", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"variables", (String)"var '_name+ = '_initializer?;", (String)"JavaScript/General", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"function calls", (String)"'_qualifier?.'_name('_argument*)", (String)"JavaScript/General", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"while loops", (String)"while ('_condition) {\n  '_statement*;\n}", (String)"JavaScript/General", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"constants", (String)"const '_name;", (String)"JavaScript/General", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"classes", (String)"class '_name {}", (String)"JavaScript/General", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"empty functions", (String)"function '_name('_parameter*) {}", (String)"JavaScript/Suspicious", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"console.log() calls", (String)"console.log('_argument*)", (String)"JavaScript/Suspicious", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"with statements", (String)"with ('_expression) {\n  '_statement*;\n}", (String)"JavaScript/Suspicious", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"var statements", (String)"var '_x+:[script( \"import com.intellij.lang.javascript.psi.JSVarStatement\ndef statement = (JSVarStatement)x.parent\nstatement.varKeyword == JSVarStatement.VarKeyword.VAR\" )];", (String)"JavaScript/Suspicious", (LanguageFileType)ES6FileType.INSTANCE), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"functions with boolean parameters", (String)"function '_name('_before*, '_parameter:[exprtype( Boolean )], '_after*) {\n  '_statement*;\n}", (String)"JavaScript/Suspicious", (LanguageFileType)StdFileTypes.JS), PredefinedConfigurationUtil.createSearchTemplateInfo((String)"comparison to self", (String)"'_expression === '_expression", (String)"JavaScript/Suspicious", (LanguageFileType)StdFileTypes.JS)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContextTypeClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLexicalNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ValidatingVisitor
    extends JSRecursiveWalkingElementVisitor {
        ValidatingVisitor() {
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            String errorDescription = element.getErrorDescription();
            throw new MalformedPatternException(errorDescription);
        }
    }
}

