/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferenceCache;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAugmentationUtil {
    public static final Key<CachedValue<Collection<PsiElement>>> KEY = Key.create((String)"module.aug.non.filtered");

    @NotNull
    public static Collection<PsiElement> getModuleAugmentations(@NotNull PsiElement module) {
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(0);
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)module, KEY, () -> {
            Collection<PsiElement> result2 = TypeScriptAugmentationUtil.getModuleAugmentationsImpl(module);
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        });
        if (collection == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiElement> getModuleAugmentationsImpl(@NotNull PsiElement module) {
        Project project;
        Collection<TypeScriptModule> augmentationModules;
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(2);
        }
        if ((augmentationModules = TypeScriptUtil.getAllAugmentationModules(project = module.getProject(), module)).isEmpty()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(3);
            }
            return set;
        }
        VirtualFile scope = TypeScriptAugmentationUtil.getVirtualFile(module);
        List result2 = ContainerUtil.newSmartList();
        VirtualFile closestNodeModules = JSLibraryUtil.findUpClosestNodeModulesResolveRoot(scope);
        for (TypeScriptModule augmentation : augmentationModules) {
            ProgressManager.checkCanceled();
            VirtualFile moduleFile = TypeScriptAugmentationUtil.getVirtualFile((PsiElement)augmentation);
            if (!TypeScriptAugmentationUtil.isAccessibleAugmentation(project, scope, closestNodeModules, moduleFile)) continue;
            Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation((PsiElement)augmentation);
            for (PsiElement resolvedModule : elements) {
                ProgressManager.checkCanceled();
                if (!module.equals(resolvedModule)) continue;
                result2.add(augmentation);
            }
        }
        List list2 = result2;
        if (list2 == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static Collection<PsiElement> getAugmentations(@NotNull PsiElement context, @NotNull Collection<? extends PsiElement> modules) {
        if (context == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(5);
        }
        if (modules == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(6);
        }
        if (!DialectDetector.isTypeScript(context) || modules.isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(7);
            }
            return list2;
        }
        Project project = context.getProject();
        List augmentationModules = StreamEx.of(modules).flatMap(el -> TypeScriptAugmentationUtil.getModuleAugmentations(el).stream()).toList();
        if (augmentationModules.isEmpty()) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(8);
            }
            return list3;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        VirtualFile scope = TypeScriptAugmentationUtil.getVirtualFile(context);
        if (scope == null) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(9);
            }
            return list4;
        }
        VirtualFile closestNodeModules = JSLibraryUtil.findUpClosestNodeModulesResolveRoot(scope);
        for (PsiElement augmentation : augmentationModules) {
            ProgressManager.checkCanceled();
            VirtualFile moduleFile = TypeScriptAugmentationUtil.getVirtualFile(augmentation);
            if (!TypeScriptAugmentationUtil.isAccessibleAugmentation(project, scope, closestNodeModules, moduleFile)) continue;
            result2.add(augmentation);
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static boolean isAccessibleAugmentation(@NotNull Project project, @NotNull VirtualFile scope, @Nullable VirtualFile closestNodeModules, @Nullable VirtualFile candidate) {
        if (project == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(12);
        }
        if (candidate == null) {
            return false;
        }
        if (TypeScriptConfigService.Provider.isAccessible(project, scope, candidate)) {
            return true;
        }
        if (closestNodeModules == null) {
            return false;
        }
        return TypeScriptUtil.isDefinitionFile(candidate) && VfsUtilCore.isAncestor((VirtualFile)closestNodeModules, (VirtualFile)candidate, (boolean)true);
    }

    private static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(13);
        }
        PsiFile file2 = element.getContainingFile();
        PsiFile originalFile = file2.getOriginalFile();
        return originalFile.getVirtualFile();
    }

    @NotNull
    public static Collection<PsiElement> resolveAugmentation(@NotNull PsiElement module) {
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(14);
        }
        Collection<PsiElement> collection = JSFileReferenceCache.getInstance(module.getProject()).resolveDirectModules(module);
        if (collection == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public static boolean isExternalModuleAugmentation(@NotNull PsiElement candidate) {
        if (candidate == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(16);
        }
        if (!(candidate instanceof TypeScriptModule)) {
            return false;
        }
        TypeScriptModule module = (TypeScriptModule)candidate;
        if (!TypeScriptPsiUtil.isAmbientModule(module)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope((PsiElement)module);
        if (container instanceof JSFile) {
            return ((JSFile)container).isCommonJSModule();
        }
        if (container instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientModule((TypeScriptModule)container)) {
            JSElement secondLevelParent = ES6PsiUtil.getExportScope((PsiElement)container);
            return secondLevelParent != null && !ES6PsiUtil.isExternalModule((PsiElement)secondLevelParent);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAugmentations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAugmentationsImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugmentations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAugmentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAugmentations";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAugmentationsImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAugmentations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleAugmentation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveAugmentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isExternalModuleAugmentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

