/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.validation.TypeScriptTypeInspectionVisitor;
import com.intellij.psi.PsiElement;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class TypeScriptValidateTypesInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"typescript.validate.types.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(3);
        }
        TypeScriptAnnotatorCheckerProvider provider2 = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)holder.getFile());
        if (!holder.isOnTheFly() && provider2.skipErrors()) {
            JSElementVisitor jSElementVisitor = new JSElementVisitor();
            if (jSElementVisitor == null) {
                TypeScriptValidateTypesInspection.$$$reportNull$$$0(4);
            }
            return jSElementVisitor;
        }
        TypeScriptTypeInspectionVisitor typeScriptTypeInspectionVisitor = new TypeScriptTypeInspectionVisitor(holder, provider2){

            @Override
            protected boolean isAcceptable(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.dialectOfElement((PsiElement)element).isTypeScript) {
                    return false;
                }
                if (element instanceof JSCallExpression) {
                    element = ((JSCallExpression)element).getMethodExpression();
                }
                return !(element instanceof JSReferenceExpression) || TypeScriptUtil.resolveIsStrict((JSReferenceExpression)element);
            }

            public void visitJSReferenceList(JSReferenceList referenceList) {
                if (!this.isAcceptable((PsiElement)referenceList)) {
                    return;
                }
                JSClass jsClass = (JSClass)referenceList.getParent();
                boolean isExtends = jsClass.getExtendsList() == referenceList;
                for (JSReferenceListMember pair : referenceList.getMembers()) {
                    if (jsClass.isInterface() || !isExtends) continue;
                    this.checkNotResolvedReferenceListExpression(pair, !pair.getClasses().isEmpty());
                }
            }

            private void checkNotResolvedReferenceListExpression(@NotNull JSReferenceListMember member, boolean hasClasses) {
                ES6ReferenceListImpl.ClassExpressionResolve resolveInfo;
                if (member == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(resolveInfo = ES6ReferenceListImpl.resolveReferenceListMember(member)).hasError() && hasClasses) {
                    return;
                }
                if (resolveInfo.constructorError == ES6ReferenceList.Errors.CIRCLE) {
                    this.getTypeChecker((PsiElement)member).registerProblem((PsiElement)member, JSBundle.message((String)ES6ReferenceList.Errors.CIRCLE.getString(), (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                    return;
                }
                JSType type = resolveInfo.constructorType;
                if (type == null || type instanceof JSNullType || type instanceof JSGenericParameterImpl) {
                    return;
                }
                ES6ReferenceList.Errors errorType = resolveInfo.constructorError;
                if (errorType == null || errorType == ES6ReferenceList.Errors.NO_CONSTRUCTOR) {
                    this.getTypeChecker((PsiElement)member).registerProblem((PsiElement)member, JSBundle.message((String)ES6ReferenceList.Errors.NO_CONSTRUCTOR.getString(), (Object[])new Object[]{type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                } else if (errorType == ES6ReferenceList.Errors.NO_COUNT_TYPE_ARGUMENTS || errorType == ES6ReferenceList.Errors.MANY_CONSTRUCTORS_WITH_DIFF_TYPES) {
                    this.getTypeChecker((PsiElement)member).registerProblem((PsiElement)member, JSBundle.message((String)errorType.getString(), (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                } else if (errorType == ES6ReferenceList.Errors.NO_ERROR) {
                    List functionTypes = ((StreamEx)((StreamEx)StreamEx.of(resolveInfo.constructorFunctions).filter(el -> !ES6ReferenceListImpl.isMixinConstructor(el))).filter(el -> ES6ReferenceListImpl.getExpandedReturnTypes(el).stream().anyMatch(ret -> !(ret instanceof JSRecordType)))).toList();
                    if (functionTypes.isEmpty()) {
                        return;
                    }
                    JSType item = (JSType)functionTypes.get(0);
                    this.getTypeChecker((PsiElement)member).registerProblem((PsiElement)member, JSBundle.message((String)ES6ReferenceList.Errors.IS_NO_CLASS.getString(), (Object[])new Object[]{item.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "member";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptValidateTypesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAcceptable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNotResolvedReferenceListExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (typeScriptTypeInspectionVisitor == null) {
            TypeScriptValidateTypesInspection.$$$reportNull$$$0(5);
        }
        return typeScriptTypeInspectionVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptValidateTypesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptValidateTypesInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

