/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileCurrentFileAction
extends TypeScriptCompileAction {
    private final Project myProject;

    public TypeScriptCompileCurrentFileAction(Project project) {
        super(JSBundle.message((String)"typescript.compiler.action.compile.current", (Object[])new Object[0]), null, null);
        this.myProject = project;
    }

    @Override
    protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
        return FileEditorManager.getInstance((Project)project).getSelectedFiles();
    }

    @Override
    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager2, @NotNull Collection<? extends JSAnnotationError> infos) {
        if (manager2 == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(1);
        }
        manager2.logCurrentErrors((List<JSAnnotationError>)ContainerUtil.immutableList(new ArrayList<JSAnnotationError>(infos)), true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed() || DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        VirtualFile[] files = this.getFiles(this.myProject, e.getDataContext());
        if (files.length == 1 && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(files[0].getFileType())) {
            e.getPresentation().setText(files[0].getPath());
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Override
    @Nullable
    protected VirtualFile getConfigFile(@Nullable DataContext context) {
        return TypeScriptCompileCurrentFileAction.getTypeScriptConfigVirtualFile(context);
    }

    @Override
    @NotNull
    protected Consumer<ProgressIndicator> compileWithoutConfig(@NotNull Project project, @Nullable DataContext context) {
        if (project == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(3);
        }
        VirtualFile[] files = this.getFiles(project, context);
        Consumer consumer = indicator -> this.runCompile(project, (ProgressIndicator)indicator, files);
        if (consumer == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(4);
        }
        return consumer;
    }

    @Override
    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompileCurrentFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompileCurrentFileAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "compileWithoutConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logErrors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compileWithoutConfig";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canUseOnlyConfigs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

