/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReturnStatementImpl;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSReturnStatementStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReturnStatementElementType
extends JSStubElementType<JSReturnStatementStub, JSReturnStatement> {
    public JSReturnStatementElementType() {
        super("RETURN_STATEMENT");
    }

    @NotNull
    public JSReturnStatementStub createStub(@NotNull JSReturnStatement psi, StubElement parentStub) {
        if (psi == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(0);
        }
        JSReturnStatementStubImpl jSReturnStatementStubImpl = new JSReturnStatementStubImpl(psi, parentStub);
        if (jSReturnStatementStubImpl == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(1);
        }
        return jSReturnStatementStubImpl;
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSReturnStatementImpl(node);
    }

    @NotNull
    public JSReturnStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(2);
        }
        JSReturnStatementStubImpl jSReturnStatementStubImpl = new JSReturnStatementStubImpl(dataStream, parentStub);
        if (jSReturnStatementStubImpl == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(3);
        }
        return jSReturnStatementStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        Language language = JSTreeUtil.getLanguage(node);
        if (!(language instanceof JSLanguageDialect) || !((JSLanguageDialect)language).getOptionHolder().isJavaScript()) {
            return false;
        }
        ASTNode expressionNode = JSReturnStatementImpl.getExpressionNode(node);
        return expressionNode != null && (expressionNode.getElementType() == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(expressionNode.getElementType()) || JSReturnStatementElementType.isIIFE(expressionNode));
    }

    private static boolean isIIFE(@NotNull ASTNode expressionNode) {
        if (expressionNode == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(4);
        }
        if (expressionNode.getElementType() != JSStubElementTypes.CALL_EXPRESSION) {
            return false;
        }
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression(expressionNode);
        while (methodExpression != null && methodExpression.getElementType() == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            methodExpression = JSParenthesizedExpressionImpl.getInnerExpression(methodExpression);
        }
        return methodExpression != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(methodExpression.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/types/JSReturnStatementElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/types/JSReturnStatementElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIIFE";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

