/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceAnnotationProvider {
    public void apply(@NotNull PsiFile file2, @Nullable List<JSAnnotationError> annotationResult, @NotNull AnnotationHolder holder, @NotNull JSLanguageService languageService) {
        if (file2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(1);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(2);
        }
        if (annotationResult == null) {
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file2.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document2 == null) {
            WolfTheProblemSolver.getInstance((Project)project).clearProblems(virtualFile);
            return;
        }
        ArrayList<HighlightInfo> errorHighlightInfos = new ArrayList<HighlightInfo>();
        String simplePath = virtualFile.getPath();
        String canonicalPath = virtualFile.getCanonicalPath();
        for (JSAnnotationError result2 : annotationResult) {
            String annotationFilePath = result2.getAbsoluteFilePath();
            if (StringUtil.isEmpty((String)annotationFilePath) || !FileUtil.pathsEqual((String)annotationFilePath, (String)simplePath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)canonicalPath)) continue;
            try {
                JSLanguageServiceUtil.PsiElementInfo info = JSLanguageServiceUtil.getElementInfo(file2, document2, result2);
                if (info == null) continue;
                PsiElement element = info.getElement();
                TextRange range = info.getRange();
                if (element == null && range == null) continue;
                Annotation annotation = JSLanguageServiceAnnotationProvider.registerAnnotation(file2, result2, element, range, holder, languageService, document2);
                if (!JSLanguageServiceAnnotationProvider.isError(result2)) continue;
                errorHighlightInfos.add(HighlightInfo.fromAnnotation((Annotation)annotation));
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        List problems = ContainerUtil.map(errorHighlightInfos, el -> new ProblemImpl(virtualFile, el, true));
        WolfTheProblemSolver.getInstance((Project)project).reportProblems(virtualFile, (Collection)problems);
    }

    @NotNull
    private static Annotation registerAnnotation(@NotNull PsiFile file2, @NotNull JSAnnotationError result2, @Nullable PsiElement element, @Nullable TextRange range, @NotNull AnnotationHolder holder, @NotNull JSLanguageService languageService, @NotNull Document document2) {
        if (file2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(5);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(6);
        }
        if (document2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(7);
        }
        assert (element != null || range != null);
        String message = result2.getDescription();
        if (range == null) {
            range = element.getTextRange();
        }
        Annotation annotation = holder.createAnnotation(result2.getSeverity(), range, message);
        ProblemHighlightType type = result2.getHighlightType();
        if (type != null) {
            annotation.setHighlightType(type);
        }
        annotation.setAfterEndOfLine(JSLanguageServiceAnnotationProvider.isAnnotationAtEndOfLine(annotation, document2));
        Collection<? extends IntentionAction> fixes = languageService.getServiceFixes(file2, element, result2);
        fixes.forEach(arg_0 -> ((Annotation)annotation).registerFix(arg_0));
        String tooltip = result2.getTooltipText();
        if (tooltip != null) {
            annotation.setTooltip(tooltip);
        }
        Annotation annotation2 = annotation;
        if (annotation2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(8);
        }
        return annotation2;
    }

    private static boolean isAnnotationAtEndOfLine(@NotNull Annotation annotation, @NotNull Document document2) {
        if (annotation == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(9);
        }
        if (document2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(10);
        }
        int startOffset = annotation.getStartOffset();
        int endOffset = annotation.getEndOffset();
        if (startOffset >= document2.getTextLength()) {
            return true;
        }
        return document2.getImmutableCharSequence().charAt(startOffset) == '\n' && (startOffset == endOffset || endOffset == startOffset + 1);
    }

    private static boolean isError(@NotNull JSAnnotationError result2) {
        if (result2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(11);
        }
        return "error".equalsIgnoreCase(result2.getCategory());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageService";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotation";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationAtEndOfLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

