/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceExecutorImpl
implements JSLanguageServiceExecutor {
    public static final String CANNOT_START_LANGUAGE_SERVICE_PROCESS = "Cannot start language service process";
    public static final String TIMEOUT_ON_STARTING_SERVICE_PROCESS = "Timeout on starting language service process";
    public static final String CAN_NOT_GET_RESULT_FROM_LANGUAGE_SERVICE = "Can not get result from language service";
    @NotNull
    private final Object myInitializationLock;
    @NotNull
    protected final ExecutorService myExecutorService;
    @NotNull
    private final JSLanguageServiceQueue.ServiceInfoReporter myReporter;
    @NotNull
    protected final JSLanguageServiceConnector myServiceConnector;
    @NotNull
    private final Project myProject;
    @Nullable
    private final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @NotNull
    protected volatile JSLanguageServiceExecutor.State myState;
    private volatile String myStartErrorMessage;
    private final AtomicReference<Boolean> myDisposed;
    @Nullable
    private ProcessHandler myProcessHandler;

    public JSLanguageServiceExecutorImpl(@NotNull Project project, @NotNull JSLanguageServiceConnector serviceConnector, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter) {
        if (project == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(0);
        }
        if (serviceConnector == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(2);
        }
        this.myInitializationLock = new Object();
        this.myState = JSLanguageServiceExecutor.State.STARTING;
        this.myDisposed = new AtomicReference<Boolean>(false);
        this.myReporter = reporter;
        this.myProject = project;
        this.myProcessConnector = connector;
        this.myServiceConnector = serviceConnector;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("JS external service " + reporter.getServiceName()));
        Disposer.register((Disposable)project, (Disposable)this);
        this.myExecutorService.submit(this::startServiceWithProgress);
    }

    @Override
    @NotNull
    public final JSLanguageServiceExecutor.State getState() {
        JSLanguageServiceExecutor.State state = this.myState;
        if (state == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(3);
        }
        return state;
    }

    private void startServiceWithProgress() {
        BackgroundableProcessIndicator indicator = this.createIndicator();
        if (indicator != null && !indicator.isCanceled()) {
            indicator.start();
        }
        try {
            this.startService();
        }
        finally {
            if (indicator != null) {
                indicator.processFinish();
                this.disposeIndicator(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService() {
        Object object = this.myInitializationLock;
        synchronized (object) {
            if (this.myState == JSLanguageServiceExecutor.State.DISPOSED) {
                this.debugLog("StartService: already disposed");
                return;
            }
            this.debugLog("Creating OS Handler");
            this.createProcessHandler();
            if (this.myProcessHandler == null) {
                return;
            }
            this.debugLog("OS Handler created successfully");
            this.createUI(this.myProcessHandler);
        }
        Exception exception = null;
        boolean readyNotificationReceived = false;
        try {
            readyNotificationReceived = this.myServiceConnector.awaitReadyNotification(this.myProcessHandler);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            exception = e;
        }
        Object object2 = this.myInitializationLock;
        synchronized (object2) {
            if (this.myState == JSLanguageServiceExecutor.State.DISPOSED) {
                this.debugLog("StartService after awaitReadyNotification. Already disposed.");
                return;
            }
            if (exception != null) {
                this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                this.reportUserError(JSLanguageServiceExecutorImpl.getPresentableExceptionMessage(exception));
                this.infoLog("Exception while waiting for ready notification", exception);
                return;
            }
            if (readyNotificationReceived) {
                this.myState = JSLanguageServiceExecutor.State.STARTED;
            } else {
                this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                this.reportUserError((String)ObjectUtils.coalesce((Object)this.myServiceConnector.getInitializeError(), (Object)TIMEOUT_ON_STARTING_SERVICE_PROCESS));
                this.infoLog("Timed out waiting for ready notification");
            }
        }
    }

    @Nullable
    private BackgroundableProcessIndicator createIndicator() {
        if (this.myProcessConnector == null) {
            return null;
        }
        AtomicReference ref = new AtomicReference();
        try {
            EdtInvocationManager.getInstance().invokeAndWait(() -> {
                if (this.myProject.isDisposed() || !this.myProject.isOpen() || !this.isValid()) {
                    return;
                }
                ref.set(new BackgroundableProcessIndicator(this.myProject, "Starting " + this.myReporter.getServiceName() + " Service", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false));
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            JSLanguageServiceQueue.LOGGER.error((Throwable)e);
        }
        return (BackgroundableProcessIndicator)ref.get();
    }

    private void createUI(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(4);
        }
        ReadAction.run(() -> StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myProcessConnector != null) {
                this.myProcessConnector.connectToProcessHandler(processHandler);
            }
        })));
    }

    private void createProcessHandler() {
        try {
            this.myProcessHandler = this.myServiceConnector.connect();
            if (this.myProcessHandler == null) {
                this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                this.reportUserError((String)ObjectUtils.coalesce((Object)this.myServiceConnector.getInitializeError(), (Object)TIMEOUT_ON_STARTING_SERVICE_PROCESS));
                this.infoLog("Error creating process handler");
                return;
            }
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == ProcessOutputTypes.STDERR) {
                        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                            JSLanguageServiceQueue.LOGGER.debug("Stderr output: " + StringUtil.escapeLineBreak((String)event.getText()));
                        }
                        return;
                    }
                    if (outputType == ProcessOutputTypes.STDOUT && JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
                        JSLanguageServiceQueue.LOGGER.trace("Stdout output: " + StringUtil.escapeLineBreak((String)event.getText()));
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    JSLanguageServiceExecutorImpl.this.processTerminated();
                    if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
                        JSLanguageServiceQueue.LOGGER.trace("Process [" + event.getProcessHandler() + "] was killed " + event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (Exception e) {
            this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
            this.reportUserError(JSLanguageServiceExecutorImpl.getPresentableExceptionMessage(e));
            JSLanguageServiceQueue.LOGGER.info("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void processTerminated() {
        if (this.myState == JSLanguageServiceExecutor.State.STARTED || this.myState == JSLanguageServiceExecutor.State.STARTING) {
            this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
        }
    }

    private static String getPresentableExceptionMessage(@NotNull Throwable e) {
        if (e == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(5);
        }
        return e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
    }

    private void reportUserError(String message) {
        this.myStartErrorMessage = message;
        this.myReporter.logError(message);
    }

    public final void dispose() {
        if (this.myDisposed.compareAndSet(false, true)) {
            this.doDispose();
        } else {
            this.debugLog("Dispose. already disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug(String.format("Disposing service %s with hashCode %s", this.myReporter.getServiceName(), this.hashCode()), new Throwable());
        }
        boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
        boolean isEdt = ApplicationManager.getApplication().isDispatchThread();
        long timeoutMillis = isTest ? 60000L : (long)(isEdt ? 50 : 1000);
        Object object = this.myInitializationLock;
        synchronized (object) {
            this.myState = JSLanguageServiceExecutor.State.DISPOSED;
            if (this.myProcessHandler != null) {
                if (!this.myProcessHandler.isProcessTerminated() && !this.myProcessHandler.isProcessTerminating()) {
                    JSLanguageServiceExecutorImpl.destroyProcess(this.myProcessHandler, timeoutMillis);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProcessConnector != null) {
                        this.myProcessConnector.disconnectFromProcessHandler(false);
                    }
                });
            }
        }
        this.shutdownPool(this.myExecutorService, timeoutMillis);
    }

    private static void destroyProcess(@NotNull ProcessHandler processHandler, long waitForTerminationTimeout) {
        if (processHandler == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(6);
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                semaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$2", "processTerminated"));
            }
        });
        processHandler.destroyProcess();
        semaphore.waitFor(waitForTerminationTimeout);
    }

    private void shutdownPool(@NotNull ExecutorService pool, long timeout) {
        if (pool == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(7);
        }
        pool.shutdownNow();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                JSLanguageServiceQueue.LOGGER.warn(String.format("%s: Pool did not terminate in %s milliseconds", this.myReporter.getServiceName(), timeout));
            } else {
                this.debugLog("Pool terminated");
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected void startAction(@NotNull JSLanguageServiceCommand command) {
        if (command == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(8);
        }
        this.startAction(command.getPresentableText(this.myProject));
    }

    protected void startAction(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.myReporter.setProcess(text);
    }

    protected void endAction() {
        if (this.getState() == JSLanguageServiceExecutor.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    private void disposeIndicator(@Nullable BackgroundableProcessIndicator indicator) {
        try {
            if (indicator != null) {
                if (!indicator.isCanceled()) {
                    indicator.cancel();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    Disposer.dispose((Disposable)indicator);
                });
            }
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isStarted() {
        return this.myState == JSLanguageServiceExecutor.State.STARTED;
    }

    @Override
    public boolean isValid() {
        JSLanguageServiceExecutor.State state = this.myState;
        return state != JSLanguageServiceExecutor.State.DISPOSED && state != JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
    }

    @Override
    public String getStartErrorMessage() {
        return (String)ObjectUtils.coalesce((Object)this.myServiceConnector.getInitializeError(), (Object)this.myStartErrorMessage);
    }

    @NotNull
    public JSLanguageServiceConnector getProtocol() {
        JSLanguageServiceConnector jSLanguageServiceConnector = this.myServiceConnector;
        if (jSLanguageServiceConnector == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(9);
        }
        return jSLanguageServiceConnector;
    }

    public <T> Future<T> submit(@Nullable String presentableName, Callable<? extends T> task) {
        try {
            return this.myExecutorService.submit(() -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    throw new IllegalStateException("Service is not started. State = " + this.myState.name());
                }
                this.startAction(presentableName);
                try {
                    Object v = task.call();
                    return v;
                }
                catch (IOException e) {
                    JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    JSLanguageServiceQueue.LOGGER.error(throwable.getMessage(), throwable);
                    throw throwable;
                }
                finally {
                    this.endAction();
                }
            });
        }
        catch (RejectedExecutionException exception) {
            JSLanguageServiceQueue.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    private void infoLog(String message) {
        this.infoLog(message, null);
    }

    private void infoLog(String message, @Nullable Throwable exception) {
        JSLanguageServiceQueue.LOGGER.info(this.myReporter.getServiceName() + ": " + message, exception);
    }

    private void debugLog(String message) {
        JSLanguageServiceQueue.LOGGER.debug(this.myReporter.getServiceName() + ": " + message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceConnector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUI";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableExceptionMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shutdownPool";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

