/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducerBase;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class JSVariableInplaceIntroducer
extends JSVariableInplaceIntroducerBase {
    private Settings.IntroducedVarType myVarType;
    private final Runnable myCallback;

    public JSVariableInplaceIntroducer(Project project, Editor editor, JSExpression[] occurrences, JSBaseIntroduceHandler<? extends JSElement, Settings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context, Runnable callback) {
        super(project, editor, occurrences, (FileType)JavaScriptFileType.INSTANCE, handler, context);
        this.myVarType = JSIntroduceVariableHandler.getLastIntroduceType(project, this.myDialectOptionHolder);
        this.myCallback = callback;
    }

    protected JComponent getComponent() {
        boolean letEnabled = JSIntroduceVariableHandler.varTypeEnabled(this.myDialectOptionHolder, Settings.IntroducedVarType.LET);
        boolean constEnabled = JSIntroduceVariableHandler.varTypeEnabled(this.myDialectOptionHolder, Settings.IntroducedVarType.CONST);
        if (!constEnabled && !letEnabled) {
            return null;
        }
        Settings.IntroducedVarType lastSelected = JSIntroduceVariableHandler.getLastIntroduceType(this.myProject, this.myDialectOptionHolder);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        if (letEnabled) {
            JRadioButton letTypeSelector = new JRadioButton("let");
            this.initTypeSelector(letTypeSelector, 'l', Settings.IntroducedVarType.LET, lastSelected);
            panel.add(letTypeSelector);
            buttonGroup.add(letTypeSelector);
        }
        JRadioButton varTypeSelector = new JRadioButton("var");
        this.initTypeSelector(varTypeSelector, 'v', Settings.IntroducedVarType.VAR, lastSelected);
        panel.add(varTypeSelector);
        buttonGroup.add(varTypeSelector);
        if (constEnabled) {
            JRadioButton constTypeSelector = new JRadioButton("const");
            this.initTypeSelector(constTypeSelector, 'c', Settings.IntroducedVarType.CONST, lastSelected);
            panel.add(constTypeSelector);
            buttonGroup.add(constTypeSelector);
        }
        return panel;
    }

    private void initTypeSelector(JRadioButton selector, char mnemonic, final Settings.IntroducedVarType newVarType, Settings.IntroducedVarType lastSelected) {
        selector.setFocusable(false);
        selector.setMnemonic(mnemonic);
        selector.setSelected(lastSelected == newVarType);
        selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSVariableInplaceIntroducer.this.myVarType = newVarType;
                JSIntroduceVariableHandler.setLastIntroduceType(JSVariableInplaceIntroducer.this.myProject, newVarType);
                JSVariableInplaceIntroducer.this.restartInplaceIntroduceTemplate();
            }
        });
    }

    public void selectVarType(@NotNull Settings.IntroducedVarType varType) {
        if (varType == null) {
            JSVariableInplaceIntroducer.$$$reportNull$$$0(0);
        }
        this.myVarType = varType;
        this.restartInplaceIntroduceTemplate();
    }

    @Override
    protected Settings getInplaceIntroduceSettings(final String name) {
        return new Settings(){

            @Override
            public Settings.IntroducedVarType getIntroducedVarType() {
                return JSVariableInplaceIntroducer.this.myVarType;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return ((Settings)JSVariableInplaceIntroducer.this.myInitialSettings).isReplaceAllOccurrences();
            }

            @Override
            public String getVariableName() {
                return name;
            }

            @Override
            public String getVariableType() {
                return ((Settings)JSVariableInplaceIntroducer.this.myInitialSettings).getVariableType();
            }
        };
    }

    protected void performPostIntroduceTasks() {
        super.performPostIntroduceTasks();
        this.myCallback.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varType", "com/intellij/lang/javascript/refactoring/introduceVariable/JSVariableInplaceIntroducer", "selectVarType"));
    }
}

