/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.ClassLevelIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseIntroduceHandler<T extends JSElement, S extends BaseIntroduceSettings, D extends JSBaseIntroduceDialog>
implements RefactoringActionHandler {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler");
    @NotNull
    private final JSIntroduceTargetChooser<JSExpression> myIntroducedExpressionChooser;
    public static final JSIntroduceTargetChooser<JSExpression> DEFAULT_EXPRESSION_CHOOSER = (editor, elements, callback, presenter) -> callback.pass(ContainerUtil.getLastItem((List)elements));

    public JSBaseIntroduceHandler() {
        this(ApplicationManager.getApplication().isUnitTestMode() ? DEFAULT_EXPRESSION_CHOOSER : IntroduceTargetChooser::showChooser);
    }

    public JSBaseIntroduceHandler(@NotNull JSIntroduceTargetChooser<JSExpression> introducedExpressionChooser) {
        if (introducedExpressionChooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(0);
        }
        this.myIntroducedExpressionChooser = introducedExpressionChooser;
    }

    protected boolean visitInnerFunctions() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(1);
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file2, editor, this.getRefactoringName())) {
            return;
        }
        String featureId = this.getProductivityFeatureId();
        if (featureId != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        List<Pair<JSExpression, TextRange>> candidates = this.getCandidateExpressions(editor, file2, start, end);
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        Consumer<JSExpression> callback = selectedExpression -> {
            Pair expressionDescriptor = (Pair)ContainerUtil.find((Iterable)candidates, e -> e.first == selectedExpression);
            if (expressionDescriptor == null || !this.validateSelectedExpression(file2, editor, (Pair<JSExpression, TextRange>)expressionDescriptor)) {
                return;
            }
            this.introduceWithExpression(editor, file2, (Pair<JSExpression, TextRange>)expressionDescriptor);
        };
        List expressions = ContainerUtil.map(candidates, jsExpressionTextRangePair -> (JSExpression)jsExpressionTextRangePair.getFirst());
        JSBaseIntroduceHandler.chooseElement(this.myIntroducedExpressionChooser, editor, expressions, callback, PsiElement::getText);
    }

    protected void afterIntroduce() {
    }

    public void introduceWithExpression(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(3);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(4);
        }
        NullableConsumer callback = scope -> {
            if (scope == null) {
                this.showErrorHint(editor, file2, JSBundle.message((String)"javascript.introduce.variable.arrow.function.parameter.referenced", (Object[])new Object[0]));
                return;
            }
            this.introduceWithScope(editor, expressionDescriptor, (JSElement)scope);
        };
        this.findIntroducedScope(editor, expressionDescriptor, (NullableConsumer<JSElement>)callback);
    }

    private void introduceWithScope(final @NotNull Editor editor, final @NotNull Pair<JSExpression, TextRange> expressionDescriptor, final @NotNull JSElement scope) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(5);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(7);
        }
        final Project project = ((JSExpression)expressionDescriptor.getFirst()).getProject();
        final JSExpression[] occurrences = this.findOccurrences(expressionDescriptor, scope);
        final boolean inplaceJavaScriptIntroduce = !JSIntroducedExpressionUtil.willReplacePartOfExpression(expressionDescriptor) && this.isInplaceIntroduce(editor, ((JSExpression)expressionDescriptor.first).getContainingFile());
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                BaseIntroduceSettings settings;
                if (!JSBaseIntroduceHandler.this.doPreprocess(project, editor, (Pair<JSExpression, TextRange>)expressionDescriptor, scope)) {
                    return;
                }
                InplaceSettings inplaceSettings = JSBaseIntroduceHandler.this.getInplaceSettings((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, choice);
                BaseIntroduceSettings baseIntroduceSettings = settings = choice == null ? JSBaseIntroduceHandler.this.getSettings(project, editor, (Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope) : (BaseIntroduceSettings)inplaceSettings.getSettings();
                if (settings == null) {
                    return;
                }
                editor.getSelectionModel().removeSelection();
                BaseIntroduceContext<BaseIntroduceSettings> introduceContext = new BaseIntroduceContext<BaseIntroduceSettings>((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, settings);
                if (inplaceJavaScriptIntroduce) {
                    JSBaseInplaceIntroducer<BaseIntroduceSettings> introducer = JSBaseIntroduceHandler.this.createInplaceIntroducer(introduceContext, scope, editor, project, occurrences, () -> JSBaseIntroduceHandler.this.afterIntroduce());
                    introducer.startInplaceIntroduceTemplate();
                } else {
                    CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                        JSBaseIntroduceHandler.this.doRefactoring(project, editor, introduceContext, true);
                        JSBaseIntroduceHandler.this.performIntroduce(introduceContext);
                    }), JSBaseIntroduceHandler.this.getRefactoringName(), null);
                    JSBaseIntroduceHandler.this.afterIntroduce();
                }
            }
        };
        if (inplaceJavaScriptIntroduce) {
            LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>>();
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(expressionDescriptor.getFirst()));
            if (occurrences.length > 1) {
                occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
            }
            this.chooseOccurrencesToReplace(editor, occurrencesMap, callback);
        } else {
            callback.pass(null);
        }
    }

    @NotNull
    protected JSExpression[] findOccurrences(@NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(9);
        }
        JSExpression[] jSExpressionArray = JSUtils.findExpressionOccurrences(scope, expressionDescriptor, this.visitInnerFunctions());
        if (jSExpressionArray == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(10);
        }
        return jSExpressionArray;
    }

    protected boolean isInplaceIntroduce(Editor editor, PsiFile file2) {
        return (file2.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || this instanceof JSIntroduceVariableHandler) && editor.getSettings().isVariableInplaceRenameEnabled();
    }

    protected void chooseOccurrencesToReplace(Editor editor, Map<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap, Pass<OccurrencesChooser.ReplaceChoice> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser(callback, occurrencesMap);
    }

    protected abstract JSBaseInplaceIntroducer<S> createInplaceIntroducer(BaseIntroduceContext<S> var1, JSElement var2, Editor var3, Project var4, JSExpression[] var5, Runnable var6);

    protected boolean doPreprocess(Project project, Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(12);
        }
        return true;
    }

    @Nullable
    protected String getProductivityFeatureId() {
        return null;
    }

    protected static String prependAccessModifier(BaseIntroduceContext<? extends ClassLevelIntroduceSettings> baseIntroduceContext, String baseDeclText) {
        JSExpression expression;
        JSAttributeList.AccessType type = ((ClassLevelIntroduceSettings)baseIntroduceContext.settings).getAccessType();
        String accessText = JSChangeVisibilityUtil.accessTypeToCodeString(type, (PsiElement)(expression = (JSExpression)baseIntroduceContext.expressionDescriptor.first));
        if (!StringUtil.isEmpty((String)accessText)) {
            baseDeclText = accessText + " " + baseDeclText;
        }
        return baseDeclText;
    }

    public static boolean introduceOverVariableNameRef(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof JSVariable && JSResolveUtil.isSelfReference(element);
    }

    public static boolean calcDependsOnContext(final PsiElement occurrence, final boolean okToAccessThis, final boolean okToAccessOccurrence) {
        if (occurrence == null) {
            return false;
        }
        final Ref localContextDependent = new Ref();
        occurrence.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(node)) {
                    ResolveResult[] results = node.multiResolve(true);
                    if (results.length == 0) {
                        localContextDependent.set((Object)Boolean.TRUE);
                    } else {
                        PsiElement element = results[0].getElement();
                        if ((element instanceof JSVariable || element instanceof JSFunction) && !(JSResolveUtil.findParent(element) instanceof JSClass) && PsiTreeUtil.findCommonParent((PsiElement)element, (PsiElement)occurrence) != occurrence && (occurrence.getParent() != element || okToAccessOccurrence)) {
                            localContextDependent.set((Object)Boolean.TRUE);
                        }
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSThisExpression(JSThisExpression node) {
                if (!okToAccessThis) {
                    localContextDependent.set((Object)Boolean.TRUE);
                }
                super.visitJSThisExpression(node);
            }
        });
        return localContextDependent.get() == Boolean.TRUE;
    }

    protected static boolean containsAwaitExpressions(@Nullable JSExpression expression) {
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)expression, element -> {
            if (ES6PsiUtil.isAwaitExpression(element)) {
                result2.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        });
        return Boolean.TRUE == result2.get();
    }

    protected void findIntroducedScope(@NotNull Editor editor, @NotNull Pair<? extends JSExpression, ? extends TextRange> expressionDescriptor, @NotNull NullableConsumer<? super JSElement> callback) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(13);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(14);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(15);
        }
        callback.consume((Object)JSBaseIntroduceHandler.getStatementScope(expressionDescriptor));
    }

    @Nullable
    private static JSExecutionScope getStatementScope(Pair<? extends JSExpression, ? extends TextRange> expressionDescriptor) {
        JSExpression expression = (JSExpression)expressionDescriptor.first;
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)expression, JSExecutionScope.class);
        if (scope != null && scope.getNode().getElementType() == JSElementTypes.EMBEDDED_EXPRESSION) {
            return (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope.getParent(), JSExecutionScope.class);
        }
        if (scope instanceof JSFunctionExpression && ((JSFunctionExpression)scope).isShorthandArrowFunction()) {
            JSParameter[] parameters = ((JSFunction)scope).getParameterVariables();
            THashSet parameterNames = new THashSet();
            for (JSParameter parameter : parameters) {
                parameterNames.add((Object)parameter.getName());
            }
            TextRange range = (TextRange)expressionDescriptor.second;
            boolean hasParamRefs = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSReferenceExpression.class).filter(r -> r.getQualifier() == null && parameterNames.contains((Object)r.getReferenceName()) && (range == null || range.contains(r.getTextRange()))).isNotEmpty();
            return hasParamRefs ? null : (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope, JSExecutionScope.class);
        }
        return scope;
    }

    protected abstract String getRefactoringName();

    protected abstract String getCannotIntroduceMessagePropertyKey();

    protected abstract String getCannotIntroduceVoidExpressionTypeMessagePropertyKey();

    protected static boolean isIntroducingPartOfExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        return expressionDescriptor.second != null;
    }

    @Nullable
    protected List<Pair<JSExpression, TextRange>> getCandidateExpressions(@NotNull Editor editor, @NotNull PsiFile file2, int start, int end) {
        List<Pair<JSExpression, TextRange>> candidates;
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(17);
        }
        if ((candidates = JSIntroducedExpressionUtil.findExpressionsInRange(file2, start, end)) == null || candidates.isEmpty()) {
            this.showDefaultErrorHint(editor, file2);
            return null;
        }
        if (ActionScriptResolveUtil.isInsideAnonymousEventHandler((PsiElement)candidates.get((int)0).first)) {
            return null;
        }
        return candidates;
    }

    protected boolean validateSelectedExpression(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression expression;
        JSType jsType;
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(19);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(20);
        }
        if ((jsType = JSResolveUtil.getExpressionJSType(expression = (JSExpression)expressionDescriptor.first)) instanceof JSVoidType) {
            this.showErrorHint(editor, file2, JSBundle.message((String)this.getCannotIntroduceVoidExpressionTypeMessagePropertyKey(), (Object[])new Object[0]));
            return false;
        }
        if (!SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSThrowExpression.class).isEmpty()) {
            this.showErrorHint(editor, file2, JSBundle.message((String)"javascript.introduce.throw.expressions.unsupported", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected abstract InplaceSettings<S> getInplaceSettings(Pair<JSExpression, TextRange> var1, JSExpression[] var2, PsiElement var3, OccurrencesChooser.ReplaceChoice var4);

    @Nullable
    protected S getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
        ArrayList<RangeHighlighter> highlighters = null;
        if (occurrences.length > 1) {
            highlighters = HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])occurrences);
        }
        D dialog = this.createDialog(project, this.getReplacementExpression(expressionDescriptor), occurrences, scope);
        dialog.show();
        if (highlighters != null) {
            for (RangeHighlighter highlighter : highlighters) {
                HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, highlighter);
            }
        }
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return (S)dialog;
    }

    protected abstract D createDialog(Project var1, JSExpression var2, JSExpression[] var3, PsiElement var4);

    @Nullable
    IntroduceInfo doRefactoring(Project project, Editor editor, BaseIntroduceContext<S> introduceContext, boolean replaceExpressions) {
        Object settings = introduceContext.settings;
        boolean replaceAllOccurences = settings.isReplaceAllOccurrences();
        JSExpression expression = (JSExpression)introduceContext.expressionDescriptor.first;
        T anchorStatement = this.findAnchor(introduceContext, replaceAllOccurences);
        if (anchorStatement == null) {
            this.showErrorHint(editor, expression.getContainingFile(), RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return null;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus(anchorStatement, editor, this.getRefactoringName())) {
            return null;
        }
        String varDeclText = this.getDeclText(introduceContext, anchorStatement);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        SmartPsiElementPointer expressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
        List<JSExpression> occurrences = Arrays.asList(introduceContext.occurences);
        JSIntroducedExpressionUtil.Replacer replacer = JSIntroducedExpressionUtil.createReplacer(introduceContext.expressionDescriptor);
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)expression);
        boolean isActionScript = languageDialect != null && languageDialect.getOptionHolder().isECMA4;
        boolean isTypeScript = languageDialect != null && languageDialect.getOptionHolder().isTypeScript;
        String type = settings.getVariableType();
        if (type == null) {
            type = new BasicIntroducedEntityInfoProvider(expression, (JSExpression[])ContainerUtil.toArray(occurrences, (ArrayFactory)JSExpression.ARRAY_FACTORY), introduceContext.scope).evaluateType();
            if ((type = JSResolveUtil.getQualifiedTypeName(type)) == null) {
                type = JSClassUtils.getAnyTypeString((PsiElement)expression, false);
            }
        }
        if (isActionScript && !JSBaseIntroduceHandler.isIntroducingPartOfExpression(introduceContext.expressionDescriptor)) {
            type = (String)ImportUtils.importAndShortenReference((String)type, (PsiElement)expression, (boolean)true, (boolean)true).first;
        }
        if (isActionScript || isTypeScript && JSCodeStyleSettings.isPreferExplicitVariableTypes(expression.getProject())) {
            varDeclText = varDeclText + ":" + type;
        }
        boolean isForExpressionStatement = JSIntroduceVariableHandler.isForExpressionStatement(introduceContext, anchorStatement);
        Pair<JSVarStatement, Boolean> preparedDeclarationStatus = this.prepareDeclaration(varDeclText, introduceContext, project, languageDialect, anchorStatement, editor);
        JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
        boolean replacedOriginal = (Boolean)preparedDeclarationStatus.second;
        SmartPsiElementPointer jsVariablePointer = null;
        SmartPsiElementPointer jsVarStatementPointer = null;
        PsiElement elementToFixFormat = null;
        if (!replacedOriginal) {
            JSExpression oldExpression = expression;
            TextRange expressionTextRange = expression.getTextRange();
            TextRange statementTextRange = anchorStatement.getTextRange();
            RangeMarker marker = editor.getDocument().createRangeMarker(expressionTextRange);
            JSVariable jsVariable = this.addStatementBefore(anchorStatement, declaration);
            PsiElement jsStatement = jsVariable.getParent();
            if (jsStatement instanceof JSVarStatement) {
                jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)((JSVarStatement)jsStatement));
            } else {
                jsVariablePointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsVariable);
            }
            if (!expression.isValid()) {
                JSExpression candidateExpression;
                int relativeOffset;
                JSElement newAnchorStatement = (JSElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)jsStatement, anchorStatement.getClass());
                JSExpression newExpression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)newAnchorStatement.findElementAt(relativeOffset = marker.getStartOffset() - statementTextRange.getStartOffset()), oldExpression.getClass());
                if (newExpression == null) assert (false) : "Could not find " + oldExpression.getClass() + " in " + newAnchorStatement.getText() + " with offset " + marker.getStartOffset();
                while (newExpression.getTextRange().getLength() != expressionTextRange.getLength() && (candidateExpression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, oldExpression.getClass())) != null && candidateExpression.getTextRange().getStartOffset() - newAnchorStatement.getTextRange().getStartOffset() == marker.getStartOffset() - statementTextRange.getStartOffset()) {
                    newExpression = candidateExpression;
                }
                int expressionIndex = occurrences.indexOf(oldExpression);
                if (expressionIndex > 0) {
                    occurrences.set(expressionIndex, newExpression);
                }
                expression = newExpression;
                expressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
            }
            elementToFixFormat = jsStatement;
        } else {
            jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)declaration);
        }
        JSExpression refExpr = this.createRefExpr((PsiElement)declaration, settings, languageDialect);
        if (replaceExpressions && replaceAllOccurences) {
            ArrayList<JSExpression> newOccurences = new ArrayList<JSExpression>();
            for (JSExpression occurrence : occurrences) {
                JSExpression jsExpression;
                if (!(occurrence == expression && replacedOriginal || (jsExpression = JSBaseIntroduceHandler.replaceExpression(replacer, occurrence, refExpr)) == null)) {
                    if (occurrence == expression) {
                        expression = jsExpression;
                    }
                    newOccurences.add(jsExpression);
                }
                occurrences = newOccurences;
            }
            ArrayList<JSExpression> toHighlight = new ArrayList<JSExpression>(occurrences);
            ContainerUtil.addIfNotNull(toHighlight, (Object)declaration.getVariables()[0].getInitializer());
            HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])toHighlight.toArray(JSExpression.EMPTY_ARRAY));
        }
        if (!replaceAllOccurences && !replacedOriginal) {
            int expressionIndex = occurrences.indexOf(expression);
            expression = JSBaseIntroduceHandler.replaceExpression(replacer, (JSExpression)expressionPointer.getElement(), refExpr);
            if (expressionIndex > 0) {
                occurrences.set(expressionIndex, expression);
            }
            expressionPointer = expression != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)expression) : null;
        }
        List<SmartPsiElementPointer<JSExpression>> occurrencePointers = JSBaseIntroduceHandler.createPointers(smartPointerManager, occurrences);
        PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
        instance.doPostponedOperationsAndUnblockDocument(editor.getDocument());
        instance.commitDocument(editor.getDocument());
        if (elementToFixFormat != null) {
            JSBaseIntroduceHandler.fixFormat(elementToFixFormat);
        }
        this.doPostprocess(declaration, settings, editor);
        JSVariable createdVar = null;
        if (jsVarStatementPointer != null) {
            JSVarStatement varStatement = (JSVarStatement)jsVarStatementPointer.getElement();
            if (varStatement != null) {
                createdVar = varStatement.getVariables()[0];
            }
        } else {
            createdVar = (JSVariable)jsVariablePointer.getElement();
        }
        return new IntroduceInfo(createdVar, expressionPointer != null ? (JSExpression)expressionPointer.getElement() : null, JSBaseIntroduceHandler.derefPointers(occurrencePointers), isForExpressionStatement);
    }

    @Nullable
    private static JSExpression replaceExpression(@NotNull JSIntroducedExpressionUtil.Replacer replacer, @NotNull JSExpression toReplace, @NotNull JSExpression refExpr) {
        if (replacer == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(21);
        }
        if (toReplace == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(22);
        }
        if (refExpr == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(23);
        }
        if (JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)toReplace)) {
            toReplace.getParent().delete();
            return null;
        }
        return replacer.replaceOccurrence(toReplace, refExpr);
    }

    @NotNull
    private static List<JSExpression> derefPointers(List<? extends SmartPsiElementPointer<JSExpression>> occurrencePointers) {
        List list2 = ContainerUtil.map(occurrencePointers, pointer -> (JSExpression)pointer.getElement());
        if (list2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @NotNull
    private static List<SmartPsiElementPointer<JSExpression>> createPointers(SmartPointerManager smartPointerManager, List<? extends JSExpression> occurrences) {
        List list2 = ContainerUtil.mapNotNull(occurrences, occurrence -> occurrence.isValid() ? smartPointerManager.createSmartPsiElementPointer((PsiElement)occurrence) : null);
        if (list2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(25);
        }
        return list2;
    }

    protected JSExpression createRefExpr(PsiElement context, S settings, JSLanguageDialect languageDialect) {
        return JSPsiElementFactory.createJSExpression(settings.getVariableName(), context);
    }

    protected static void fixFormat(@NotNull PsiElement jsStatement) {
        if (jsStatement == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(26);
        }
        PsiUtilCore.ensureValid((PsiElement)jsStatement);
        PsiElement parent = jsStatement.getParent();
        if (parent != null) {
            CodeStyleManager.getInstance((Project)jsStatement.getProject()).reformatNewlyAddedElement(parent.getNode(), jsStatement.getNode());
        }
    }

    protected void doPostprocess(JSVarStatement declaration, S settings, Editor editor) {
    }

    public void performIntroduce(@NotNull BaseIntroduceContext<S> introduceContext) {
        if (introduceContext == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(27);
        }
    }

    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, BaseIntroduceContext<S> context, Project project, @Nullable JSLanguageDialect languageDialect, T anchorStatement, Editor editor) throws IncorrectOperationException {
        JSExpression initializerReplacementExpression = this.getReplacementExpression(context.expressionDescriptor);
        String text = varDeclText + (initializerReplacementExpression != null ? " = 0" : "") + JSCodeStyleSettings.getSemicolon((PsiElement)context.scope.getContainingFile());
        JSVarStatement declaration = JSPsiElementFactory.createJSStatement(text, (PsiElement)context.expressionDescriptor.first, JSVarStatement.class);
        this.replaceInitializer(initializerReplacementExpression, declaration);
        return Pair.create((Object)declaration, (Object)Boolean.FALSE);
    }

    protected void replaceInitializer(JSExpression initializerReplacementExpression, JSVarStatement declaration) {
        JSVariable variable = declaration.getVariables()[0];
        JSExpression initializer = variable.getInitializer();
        if (initializer != null && initializerReplacementExpression != null) {
            initializer.replace(initializerReplacementExpression);
        }
    }

    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression jsExpression = (JSExpression)expressionDescriptor.first;
        if (!JSBaseIntroduceHandler.isIntroducingPartOfExpression(expressionDescriptor)) {
            Pair<JSExpression, TextRange> simplified = JSBaseIntroduceHandler.simplifyExpression(expressionDescriptor);
            if (simplified == expressionDescriptor) {
                return jsExpression;
            }
            expressionDescriptor = simplified;
        }
        String value = this.getIntroducedExpressionText(expressionDescriptor);
        JSVarStatement declaration = JSPsiElementFactory.createJSStatement("var xxx = " + value + JSCodeStyleSettings.getSemicolon((PsiElement)jsExpression.getContainingFile()), (PsiElement)jsExpression, JSVarStatement.class);
        return declaration.getVariables()[0].getInitializer();
    }

    protected String getIntroducedExpressionText(Pair<JSExpression, TextRange> expressionDescriptor) {
        return JSIntroducedExpressionUtil.createReplacer(expressionDescriptor).getIntroducedExpressionText();
    }

    public static Pair<JSExpression, TextRange> simplifyExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression initial;
        if (JSIntroducedExpressionUtil.willReplacePartOfExpression(expressionDescriptor)) {
            return expressionDescriptor;
        }
        JSExpression expression = initial = (JSExpression)expressionDescriptor.first;
        while (expression instanceof JSParenthesizedExpression) {
            expression = ((JSParenthesizedExpression)expression).getInnerExpression();
        }
        if (expression != null && expression != initial) {
            return Pair.create((Object)expression, null);
        }
        return expressionDescriptor;
    }

    @NonNls
    protected String getDeclText(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return this.calcDeclText(baseIntroduceContext, "var", anchor);
    }

    protected String calcDeclText(BaseIntroduceContext<S> baseIntroduceContext, String s, T anchor) {
        boolean isStatic = JSResolveUtil.calculateStaticFromContext((PsiElement)this.getElementForContextTypeCheck(baseIntroduceContext, anchor));
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType(anchor, JSFunction.class);
        if (s.length() > 0) {
            s = s + " ";
        }
        return (isStatic && fun == null ? "static " : "") + s + baseIntroduceContext.settings.getVariableName();
    }

    protected JSElement getElementForContextTypeCheck(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return (JSElement)baseIntroduceContext.expressionDescriptor.first;
    }

    protected JSVariable addStatementBefore(T anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement statement = JSChangeUtil.addSourceElement((JSSourceElement)anchor, declaration, true);
        return statement.getVariables()[0];
    }

    protected T findAnchor(BaseIntroduceContext<S> context, boolean replaceAllOccurences) {
        JSSourceElement anchorStatement;
        JSExpression expression = (JSExpression)context.expressionDescriptor.first;
        JSSourceElement jSSourceElement = anchorStatement = replaceAllOccurences ? JSBaseIntroduceHandler.getAnchorToInsert(context.occurences) : JSUtils.findSourceAnchor((PsiElement)expression, DialectDetector.isActionScript((PsiElement)expression));
        if (anchorStatement instanceof JSVarStatement && anchorStatement.getParent() instanceof JSStatement && !(anchorStatement.getParent() instanceof JSBlockStatement) || anchorStatement != null && anchorStatement.getParent() instanceof JSLabeledStatement) {
            anchorStatement = (JSStatement)anchorStatement.getParent();
        }
        return (T)anchorStatement;
    }

    @Nullable
    private static JSSourceElement getAnchorToInsert(JSExpression[] expressions) {
        JSSourceElement statement;
        JSExpression place = expressions[0];
        block0: while (true) {
            PsiElement statementAnchor;
            if ((statementAnchor = JSUtils.findStatementAnchor((PsiElement)place, place.getContainingFile(), true)) == null) {
                return null;
            }
            statement = statementAnchor instanceof JSSourceElement && !(statementAnchor instanceof JSExpression) ? (JSSourceElement)statementAnchor : JSUtils.findSourceAnchor(statementAnchor, DialectDetector.isActionScript((PsiElement)place));
            LOG.assertTrue(statement != null);
            PsiElement parent = statement.getParent();
            for (JSExpression expression : expressions) {
                if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expression, (boolean)true)) continue;
                place = statement;
                continue block0;
            }
            break;
        }
        return statement;
    }

    public static JSElement findClassAnchor(PsiElement expression) {
        PsiElement classRef;
        PsiElement anchor = PsiTreeUtil.findFirstParent((PsiElement)expression, e -> e != null && (e.getParent() instanceof JSClass || e.getParent() instanceof JSFile));
        if (!DialectDetector.isActionScript(expression)) {
            return (JSElement)anchor;
        }
        JSFunctionExpression functionExpression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunctionExpression.class);
        if (!(anchor == null || functionExpression != null && ActionScriptResolveUtil.isAnonymousEventHandler(functionExpression))) {
            return (JSElement)anchor;
        }
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, JSClass.class});
        if (parent instanceof JSFile && (classRef = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent)) instanceof JSClass) {
            parent = (JSElement)classRef;
        }
        return parent;
    }

    protected static JSVariable addToClassAnchor(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement varStatement = anchor instanceof JSClass || anchor instanceof JSFile ? (JSVarStatement)anchor.add((PsiElement)declaration) : (JSVarStatement)anchor.getParent().addBefore((PsiElement)declaration, (PsiElement)anchor);
        return varStatement.getVariables()[0];
    }

    public static <TElement> void chooseElement(@NotNull JSIntroduceTargetChooser<TElement> chooser, @NotNull Editor editor, @NotNull List<? extends TElement> elements, final @NotNull Consumer<? super TElement> callback, @NotNull Function<? super TElement, String> presenter) {
        if (chooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(28);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(29);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(30);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(31);
        }
        if (presenter == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(32);
        }
        JSBaseIntroduceHandler.chooseElement(chooser, editor, elements, new Pass<TElement>(){

            public void pass(TElement element) {
                callback.accept(element);
            }
        }, presenter);
    }

    public static <TElement> void chooseElement(@NotNull JSIntroduceTargetChooser<TElement> chooser, @NotNull Editor editor, @NotNull List<? extends TElement> elements, @NotNull Pass<? super TElement> callback, @NotNull Function<? super TElement, String> presenter) {
        if (chooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(33);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(34);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(35);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(36);
        }
        if (presenter == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(37);
        }
        if (elements.isEmpty()) {
            return;
        }
        if (elements.size() == 1) {
            callback.pass(elements.get(0));
        } else {
            chooser.invoke(editor, elements, callback, presenter);
        }
    }

    protected void showDefaultErrorHint(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(39);
        }
        this.showErrorHint(editor, file2, JSBundle.message((String)this.getCannotIntroduceMessagePropertyKey(), (Object[])new Object[0]));
    }

    protected void showErrorHint(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull String message) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(40);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(41);
        }
        if (message == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(42);
        }
        CommonRefactoringUtil.showErrorHint((Project)file2.getProject(), (Editor)editor, (String)message, (String)this.getRefactoringName(), null);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(43);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(44);
        }
        throw new RuntimeException("Not implemented");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedExpressionChooser";
                break;
            }
            case 1: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 16: 
            case 19: 
            case 29: 
            case 34: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 17: 
            case 18: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler";
                break;
            }
            case 15: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsStatement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 30: 
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presenter";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "derefPointers";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "introduceWithExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "introduceWithScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doPreprocess";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateExpressions";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fixFormat";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "performIntroduce";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showDefaultErrorHint";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntroduceInfo {
        final JSVariable createdVariable;
        final JSExpression expression;
        final List<JSExpression> occurrences;
        final boolean isFromExpressionStatement;

        public IntroduceInfo(JSVariable variable, JSExpression expression, List<JSExpression> occurrences, boolean isForExpressionStatement) {
            this.createdVariable = variable;
            this.expression = expression;
            this.occurrences = occurrences;
            this.isFromExpressionStatement = isForExpressionStatement;
        }
    }

    public static final class BaseIntroduceContext<S extends BaseIntroduceSettings> {
        public final S settings;
        final JSExpression[] occurences;
        final PsiElement scope;
        public final Pair<JSExpression, TextRange> expressionDescriptor;

        public BaseIntroduceContext(Pair<JSExpression, TextRange> _mainoccurence, JSExpression[] _occurences, PsiElement _scope, S _settings) {
            this.occurences = _occurences;
            this.expressionDescriptor = _mainoccurence;
            this.settings = _settings;
            this.scope = _scope;
        }
    }
}

