/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.util.LazyReentrantRecursionGuardStrategy;
import com.intellij.lang.javascript.psi.util.ReentrantRecursionGuardStrategy;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReentrantRecursionGuard<K> {
    @NotNull
    private final RecursionGuard<StackElement<K>> myDelegate;
    @NotNull
    private final ReentrantRecursionGuardStrategy<K> myStrategy;

    public ReentrantRecursionGuard(@NotNull String id) {
        if (id == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(0);
        }
        this(id, LazyReentrantRecursionGuardStrategy.instance());
    }

    public ReentrantRecursionGuard(@NotNull String id, @NotNull ReentrantRecursionGuardStrategy<K> strategy) {
        if (id == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(1);
        }
        if (strategy == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(2);
        }
        this.myDelegate = RecursionManager.createGuard((String)id);
        this.myStrategy = strategy;
    }

    @Nullable
    public <V> V computeAndCache(@NotNull K place, @NotNull Consumer<V> cacheNewValue, @NotNull Function<K, V> provider2) {
        if (place == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(3);
        }
        if (cacheNewValue == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(5);
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        V value = this.doPreventingRecursion(place, true, () -> provider2.apply(place));
        if (value == null) {
            return null;
        }
        if (stamp.mayCacheNow()) {
            cacheNewValue.accept(value);
        }
        return value;
    }

    @Nullable
    public <V> V doPreventingRecursion(@NotNull K place, boolean memoize, @NotNull Computable<? extends V> computation) {
        if (place == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(6);
        }
        if (computation == null) {
            ReentrantRecursionGuard.$$$reportNull$$$0(7);
        }
        List currentStack = this.myDelegate.currentStack();
        boolean isRepeatedOccurrence = false;
        for (int i = currentStack.size() - 1; i >= 0; --i) {
            StackElement stackElement = (StackElement)currentStack.get(i);
            if (!Objects.equals(place, stackElement.key)) continue;
            if (stackElement.isRepeatedOccurrence) {
                isRepeatedOccurrence = true;
                break;
            }
            if (!this.myStrategy.continueSecondCycle(currentStack, i)) break;
            isRepeatedOccurrence = true;
            break;
        }
        return (V)this.myDelegate.doPreventingRecursion(new StackElement<K>(isRepeatedOccurrence, place), memoize, computation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheNewValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/ReentrantRecursionGuard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAndCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doPreventingRecursion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class StackElement<K> {
        public final boolean isRepeatedOccurrence;
        @NotNull
        public final K key;

        StackElement(boolean isRepeatedOccurrence, @NotNull K key) {
            if (key == null) {
                StackElement.$$$reportNull$$$0(0);
            }
            this.isRepeatedOccurrence = isRepeatedOccurrence;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackElement element = (StackElement)o;
            return this.isRepeatedOccurrence == element.isRepeatedOccurrence && this.key.equals(element.key);
        }

        public int hashCode() {
            return Objects.hash(this.isRepeatedOccurrence, this.key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/psi/util/ReentrantRecursionGuard$StackElement", "<init>"));
        }
    }
}

