/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleAccessibilityChecker
extends JSAccessibilityChecker {
    public static final TypeScriptModuleAccessibilityChecker INSTANCE = new TypeScriptModuleAccessibilityChecker();
    private final Class[] myClasses = new Class[]{JSVariable.class, JSFunction.class, TypeScriptImportStatement.class, TypeScriptClass.class, TypeScriptInterface.class, TypeScriptEnum.class, TypeScriptTypeAlias.class, TypeScriptModule.class};

    @Override
    @NotNull
    protected Class<? extends JSElement>[] getSuitableClasses() {
        if (this.myClasses == null) {
            TypeScriptModuleAccessibilityChecker.$$$reportNull$$$0(0);
        }
        return this.myClasses;
    }

    @Override
    @Nullable
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            TypeScriptModuleAccessibilityChecker.$$$reportNull$$$0(1);
        }
        if (place == null) {
            return null;
        }
        if (!ES6PsiUtil.isElementCanBeExported(element) || element instanceof TypeScriptImplicitModule) {
            return null;
        }
        JSElement parent = ES6PsiUtil.getExportScope(element);
        if (!(parent instanceof TypeScriptModule)) {
            return null;
        }
        JSAttributeListOwner owner = (JSAttributeListOwner)element;
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList == null || attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC || ES6ImportHandler.isExportedWithNameOrDefaultOrAssignment((PsiElement)owner)) {
            return null;
        }
        if (element instanceof JSVariable || element instanceof JSFunction) {
            PsiElement elementParent = element.getContext();
            if (elementParent instanceof JSVarStatement) {
                elementParent = elementParent.getContext();
            }
            if (elementParent instanceof JSClass) {
                return null;
            }
        }
        TypeScriptModule module = (TypeScriptModule)parent;
        if (element instanceof TypeScriptModule && module instanceof TypeScriptImplicitModule) {
            return null;
        }
        if (PsiTreeUtil.isContextAncestor((PsiElement)module, (PsiElement)place, (boolean)false) && (!(place instanceof JSReferenceExpression) || ((JSReferenceExpression)place).getQualifier() == null)) {
            return null;
        }
        return "javascript.element.is.not.accessible.message";
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor resolveProcessor) {
        return ((ResultSink)resolveProcessor.getResultSink()).isTypeScript();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptModuleAccessibilityChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptModuleAccessibilityChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

