/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class JSEvaluatorComplexityTracker {
    private static final int MAX_BRANCH_COMPLEXITY = JSUtils.getSystemPropertySafely("idea.javascript.max.evaluation.branch.complexity", 6);
    private static final int ACCUMULATED_COMPLEXITY_MULTIPLIER = 3;
    private int currentBranchComplexity = 0;
    private boolean isAccumulating = false;
    private int accumulatedComplexity = 0;
    private Object initialKey = null;
    private final RecursionGuard<Object> recursionGuard = RecursionManager.createGuard((String)"js.evaluator.complexity.tracker");
    private static boolean ourAssertOnPrevention = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runTask(@NotNull Supplier<Boolean> task) {
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(0);
        }
        boolean isInitial = this.initialKey == null;
        Object key = new Object();
        if (isInitial) {
            this.initialKey = key;
        }
        if (this.currentBranchComplexity >= MAX_BRANCH_COMPLEXITY || this.isAccumulating && this.accumulatedComplexity >= MAX_BRANCH_COMPLEXITY * 3) {
            this.recursionGuard.prohibitResultCaching(this.initialKey);
            if (isInitial) {
                this.initialKey = null;
            }
            return false;
        }
        try {
            ++this.currentBranchComplexity;
            if (this.isAccumulating) {
                ++this.accumulatedComplexity;
            }
            boolean bl = Boolean.TRUE.equals(this.recursionGuard.doPreventingRecursion(key, true, () -> (Boolean)task.get()));
            return bl;
        }
        finally {
            --this.currentBranchComplexity;
            if (isInitial) {
                this.initialKey = null;
            }
        }
    }

    public void runTaskWithAccumulatingComplexity(@NotNull Supplier<Boolean> task) {
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(1);
        }
        boolean wasAccumulating = this.isAccumulating;
        try {
            this.isAccumulating = true;
            if (!wasAccumulating) {
                this.accumulatedComplexity = this.currentBranchComplexity * 3;
            }
            this.runTask(task);
        }
        finally {
            if (!wasAccumulating) {
                this.accumulatedComplexity = 0;
                this.isAccumulating = false;
            }
        }
    }

    public boolean runTask(boolean checkOnlyIfSubTask, @NotNull Supplier<Boolean> task) {
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(2);
        }
        return this.currentBranchComplexity == 0 && checkOnlyIfSubTask ? task.get().booleanValue() : this.runTask(task);
    }

    public static void assertOnRecursionPrevention(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(3);
        }
        ourAssertOnPrevention = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnPrevention = false;
            }
        });
    }

    public static boolean isAssertOnPrevention() {
        return ourAssertOnPrevention;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskWithAccumulatingComplexity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOnRecursionPrevention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

