/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XFilterQueryArgumentList;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionImpl
extends JSExpressionImpl
implements JSReferenceExpression,
BindablePsiReference {
    private static final TokenSet IDENTIFIER_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.ANY_IDENTIFIER})});
    private static final TokenSet ACCESS_TOKENS_SET = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DOT, JSTokenTypes.ELVIS, JSElementTypes.DOT_SHARP});

    public JSReferenceExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    @Nullable
    public JSExpression getQualifier() {
        ASTNode node = JSReferenceExpressionImpl.getQualifierNode(this.getNode());
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static ASTNode getQualifierNode(@NotNull ASTNode node) {
        if (node == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        return node.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    @NotNull
    public JSReferenceExpression.Kind getReferenceKind() {
        IElementType elementType;
        ASTNode accessToken = this.getNode().findChildByType(ACCESS_TOKENS_SET);
        IElementType iElementType = elementType = accessToken == null ? null : accessToken.getElementType();
        if (elementType == JSTokenTypes.ELVIS) {
            JSReferenceExpression.Kind kind = JSReferenceExpression.Kind.ElvisAccess;
            if (kind == null) {
                JSReferenceExpressionImpl.$$$reportNull$$$0(1);
            }
            return kind;
        }
        if (elementType == JSElementTypes.DOT_SHARP) {
            JSReferenceExpression.Kind kind = JSReferenceExpression.Kind.PrivateAccess;
            if (kind == null) {
                JSReferenceExpressionImpl.$$$reportNull$$$0(2);
            }
            return kind;
        }
        if (elementType == JSTokenTypes.DOT) {
            JSReferenceExpression.Kind kind = JSReferenceExpression.Kind.PropertyAccess;
            if (kind == null) {
                JSReferenceExpressionImpl.$$$reportNull$$$0(3);
            }
            return kind;
        }
        JSReferenceExpression.Kind kind = JSReferenceExpression.Kind.Unknown;
        if (kind == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        return kind;
    }

    @Nullable
    public String getReferencedName() {
        return JSReferenceExpressionImpl.getReferenceName(this.getNode());
    }

    @Nullable
    public String getReferenceName() {
        return this.getReferencedName();
    }

    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode element = JSReferenceExpressionImpl.getNameElement(this.getNode());
        return element != null ? element.getPsi() : null;
    }

    @Nullable
    public static String getReferenceName(@NotNull ASTNode referenceNode) {
        ASTNode nameElement;
        if (referenceNode == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        return (nameElement = JSReferenceExpressionImpl.getNameElement(referenceNode)) != null ? JSPsiImplUtils.getNameFromIdentifier(nameElement) : null;
    }

    @NotNull
    public PsiElement getElement() {
        JSReferenceExpressionImpl jSReferenceExpressionImpl = this;
        if (jSReferenceExpressionImpl == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        return jSReferenceExpressionImpl;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode astNode = this.getNode();
        ASTNode nameElement = JSReferenceExpressionImpl.getNameElement(astNode);
        int startOffset = nameElement != null ? nameElement.getStartOffset() : astNode.getTextRange().getStartOffset();
        ASTNode signature = astNode.findChildByType(JSElementTypes.GENERIC_SIGNATURE);
        int endOffsetInParent = signature != null ? signature.getTextRange().getStartOffset() - astNode.getTextRange().getStartOffset() : this.getTextLength();
        TextRange textRange = new TextRange(startOffset - astNode.getStartOffset(), endOffsetInParent);
        if (textRange == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    public static ASTNode getNameElement(ASTNode node) {
        return node.findChildByType(IDENTIFIER_TOKENS_SET);
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(9);
        }
        return this.handleElementRenameInternal(newElementName);
    }

    public PsiElement handleElementRenameInternal(String newElementName) throws IncorrectOperationException {
        ASTNode node;
        int i = newElementName.lastIndexOf(46);
        if (i != -1) {
            newElementName = newElementName.substring(0, i);
        }
        if (!this.isIdentifierName(newElementName)) {
            throw new IncorrectOperationException("Invalid javascript element name:" + newElementName);
        }
        PsiElement parent = this.getParent();
        if ((parent instanceof JSClass || parent instanceof JSFunction) && (node = ((JSNamedElement)parent).findNameIdentifier()) != null && node.getPsi() == this) {
            return this;
        }
        ASTNode astNode = this.getNode();
        JSChangeUtil.doIdentifierReplacement(astNode, JSReferenceExpressionImpl.getNameElement(astNode), newElementName, this.getProject());
        return this.getParent();
    }

    private boolean isIdentifierName(String name) {
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage())).createLexer(this.getProject());
        lexer.start((CharSequence)name);
        return JSKeywordSets.IDENTIFIER_NAMES.contains(lexer.getTokenType()) && lexer.getTokenEnd() == name.length();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        JSClass jsClass;
        ASTNode node;
        PsiElement parent;
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(10);
        }
        if (((parent = this.getParent()) instanceof JSClass || parent instanceof JSNamespaceDeclaration || parent instanceof JSFunction) && (node = ((JSNamedElement)parent).findNameIdentifier()) != null && node.getPsi() == this && (parent == element || element instanceof PsiFile)) {
            return this;
        }
        if (parent instanceof JSNewExpression && element instanceof JSFunction && (jsClass = ES6PsiUtil.getES6ConstructorClass(element)) != null) {
            return JSReferenceExpressionImpl.bindToElement(this, jsClass.getName(), (PsiNamedElement)jsClass, false);
        }
        String qName = JSPsiImplUtils.getQNameForMove((PsiElement)this, element);
        return JSReferenceExpressionImpl.bindToElement(this, qName, (PsiNamedElement)element, false);
    }

    public static JSReferenceExpression bindToElement(JSReferenceExpression ref, @Nullable String qName, @NotNull PsiNamedElement element, boolean justMakeQualified) {
        String name;
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(11);
        }
        if ((name = element.getName()) == null) {
            return ref;
        }
        if (element instanceof CssClass) {
            name = CssClass.kebabToCamelCase((String)name);
        }
        String newName = element instanceof PsiFile ? FileUtilRt.getNameWithoutExtension((String)name) : name;
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            ref = helper.bindReferenceToElement(ref, qName, newName, justMakeQualified, element);
        }
        if (!newName.equals(ref.getReferencedName())) {
            ASTNode nameElement = JSInheritedLanguagesHelper.createNameIdentifierFromText(newName, (PsiElement)ref);
            ASTNode refNode = ref.getNode();
            refNode.replaceChild(JSReferenceExpressionImpl.getNameElement(refNode), nameElement);
        }
        return ref;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        boolean hasQualifier;
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(12);
        }
        boolean bl = hasQualifier = this.getQualifier() != null;
        if (hasQualifier && element instanceof JSVariable && !(element instanceof JSField) && !JSClassUtils.isClassMember(element) && !((JSVariable)element).isExported() && !((JSVariable)element).isExportedWithDefault()) {
            return false;
        }
        if (element instanceof JSNamedElement && DialectDetector.isActionScript(element) != DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue || element instanceof ES6ExportDefaultAssignment) {
            String referencedName = this.getReferencedName();
            if (JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, referencedName, element)) {
                return true;
            }
            if (DialectDetector.isActionScript((PsiElement)this)) {
                return false;
            }
            if (element instanceof JSPsiElementBase && referencedName != null && referencedName.equals(((JSPsiElementBase)element).getName())) {
                PsiElement parent = this.getParent();
                if (parent instanceof JSDefinitionExpression) {
                    if (!JSResolveUtil.isDummyResolve(this)) {
                        return false;
                    }
                    JSNamespace refNamespace = ((JSDefinitionExpression)parent).getJSNamespace();
                    return !refNamespace.isSourceStrict() || JSSymbolUtil.areElementsFromSameNamespace((JSPsiElementBase)((JSDefinitionExpression)parent), (JSPsiElementBase)element);
                }
                if (element instanceof JSDefinitionExpression || element instanceof JSProperty) {
                    if (hasQualifier && !((JSQualifiedNamedElement)element).getJSNamespace().isSourceStrict()) {
                        return true;
                    }
                    ResolveResult[] assignedElements = JSReferenceExpressionImpl.resolveAssignedElements((JSQualifiedNamedElement)element);
                    if (this.resolveResultsOverlap(assignedElements)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @NotNull
    private static ResolveResult[] resolveAssignedElements(@NotNull JSQualifiedNamedElement definitionOrProperty) {
        if (definitionOrProperty == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        PsiPolyVariantReference ref = null;
        if (definitionOrProperty instanceof JSDefinitionExpression) {
            PsiReference textReference;
            JSExpression indexExpression;
            JSExpression expression = ((JSDefinitionExpression)definitionOrProperty).getExpression();
            if (expression instanceof JSReferenceExpression) {
                ref = (JSReferenceExpression)expression;
            } else if (expression instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression()) instanceof JSLiteralExpression && (textReference = indexExpression.getReference()) instanceof JSTextReference) {
                ref = (PsiPolyVariantReference)textReference;
            }
        } else if (definitionOrProperty instanceof JSProperty) {
            ref = ((JSProperty)definitionOrProperty).getPropertyNameReference();
        }
        ResolveResult[] resolveResultArray = ref != null ? ref.multiResolve(false) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(14);
        }
        return resolveResultArray;
    }

    private boolean resolveResultsOverlap(@NotNull ResolveResult[] otherResults) {
        ResolveResult[] thisResults;
        if (otherResults == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(15);
        }
        if (otherResults.length == 0) {
            return false;
        }
        for (ResolveResult thisResult : thisResults = this.multiResolve(false)) {
            for (ResolveResult otherResult : otherResults) {
                if (!thisResult.isValidResult() || !otherResult.isValidResult() || !Objects.equals(thisResult.getElement(), otherResult.getElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static void doProcessLocalDeclarations(@NotNull PsiElement context, @Nullable JSExpression qualifier, ResolveProcessor processor, boolean ecma, boolean completion, Boolean forceInTypeContext) {
        if (context == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(16);
        }
        JSReferenceExpressionImpl.doProcessLocalDeclarations(context, qualifier, processor, ecma, completion, forceInTypeContext, null);
    }

    public static void doProcessLocalDeclarations(@NotNull PsiElement context, @Nullable JSExpression qualifier, ResolveProcessor processor, boolean ecma, boolean completion, Boolean forceInTypeContext, PsiElement forceStopElement) {
        JSFunction nearestFunction;
        boolean toProcessHierarchy;
        if (context == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(17);
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext(context, qualifier instanceof JSThisExpression);
        boolean inTypeContext = JSReferenceExpressionImpl.isTypeContext(context, forceInTypeContext);
        boolean whereTypeCanBe = JSReferenceExpressionImpl.isWhereTypeCanBe(context, qualifier, ecma, completion, inTypeContext);
        PsiElement elToProcess = context;
        JSClass scopeToStopAt = null;
        PsiElement parent = context.getParent();
        boolean strictClassOffset = JSResolveUtil.getTopReferenceParent(parent) instanceof JSImportStatement;
        boolean toProcessMembers = !strictClassOffset;
        boolean bl = toProcessHierarchy = qualifier != null || !inTypeContext || parent instanceof JSNewExpression;
        if (qualifier != null) {
            elToProcess = jsClass;
            if (jsClass == null) {
                if (qualifier instanceof JSThisExpression) {
                    if (ecma) {
                        nearestFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
                        elToProcess = nearestFunction != null && !(nearestFunction instanceof JSFunctionExpression) ? nearestFunction : context;
                    } else {
                        elToProcess = PsiTreeUtil.getParentOfType((PsiElement)context, JSProperty.class);
                        if (elToProcess != null) {
                            scopeToStopAt = elToProcess.getParent();
                        }
                    }
                } else if (qualifier instanceof JSSuperExpression) {
                    elToProcess = JSResolveUtil.getClassFromTagNameInMxml(context);
                }
            }
        } else if (ecma && whereTypeCanBe) {
            if (inTypeContext) {
                if (parent instanceof JSAttributeList && JSResolveUtil.findParent(parent.getParent()) instanceof JSBlockStatement) {
                    toProcessHierarchy = true;
                }
                if (!(parent instanceof JSNewExpression || parent instanceof JSAttributeList || parent instanceof JSBinaryExpression || parent instanceof JSUseNamespaceDirective)) {
                    toProcessMembers = false;
                    nearestFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
                    Object object = elToProcess = nearestFunction != null ? nearestFunction.getFirstChild() : jsClass;
                }
                if (completion) {
                    JSReferenceExpressionImpl.addImplicitActionScriptTypes(context, processor, parent);
                }
            } else if (parent instanceof JSExpressionStatement && JSResolveUtil.isPlaceWhereNsCanBe(parent)) {
                toProcessMembers = false;
                elToProcess = null;
            }
        }
        if ((qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && jsClass != null) {
            JSFunctionExpression expression;
            scopeToStopAt = jsClass;
            if (ecma && (expression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunctionExpression.class)) != null) {
                elToProcess = expression.getFirstChild();
            }
        }
        if (jsClass != null && (DialectDetector.isTypeScript(context) || DialectDetector.isES6(context))) {
            boolean contextSensitive;
            toProcessHierarchy = qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || jsClass instanceof TypeScriptEnum;
            toProcessMembers = toProcessHierarchy;
            boolean bl2 = contextSensitive = qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || qualifier == null;
            if (contextSensitive) {
                processor.getAccessibilityProcessingHandler().setProcessStatics(JSResolveUtil.calculateStaticFromContext(context));
            }
        }
        if (ecma && elToProcess == null && whereTypeCanBe && (elToProcess = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, JSFile.class})) != null && (elToProcess = PsiTreeUtil.getChildOfType((PsiElement)elToProcess, PsiWhiteSpace.class)) == null) {
            elToProcess = context;
        }
        processor.setTypeContext(whereTypeCanBe || qualifier == null && parent instanceof JSReferenceExpression || strictClassOffset);
        processor.setToProcessMembers(toProcessMembers);
        if (elToProcess != null) {
            processor.setToProcessHierarchy(toProcessHierarchy);
            processor.setToSkipClassDeclarationsOnce(qualifier instanceof JSSuperExpression);
            if (ecma) {
                processor.getAccessibilityProcessingHandler().setProcessStatics(JSReferenceExpressionImpl.isStaticContext(elToProcess));
            }
            JSResolveUtil.treeWalkUp(processor, elToProcess, elToProcess, context, (PsiElement)(forceStopElement == null ? scopeToStopAt : forceStopElement));
            processor.setToProcessHierarchy(false);
            processor.setToSkipClassDeclarationsOnce(false);
            processor.getAccessibilityProcessingHandler().setProcessStatics(false);
        }
    }

    private static void addImplicitActionScriptTypes(@NotNull PsiElement context, @NotNull ResolveProcessor processor, @Nullable PsiElement parent) {
        if (context == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(19);
        }
        if (parent instanceof JSVariable || parent instanceof JSFunction || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
            PsiFile containingFile = context.getContainingFile();
            JSImplicitElementImpl element = new JSImplicitElementImpl("*", null, (PsiElement)containingFile);
            processor.execute((PsiElement)element, ResolveState.initial());
            if (parent instanceof JSFunction || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
                element = new JSImplicitElementImpl("void", null, (PsiElement)containingFile);
                processor.execute((PsiElement)element, ResolveState.initial());
            }
        }
    }

    public static boolean isWhereTypeCanBe(@NotNull PsiElement context, @Nullable JSExpression qualifier, boolean ecma, boolean completion, boolean inTypeContext) {
        if (context == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(20);
        }
        return inTypeContext || qualifier == null && DialectDetector.isTypeScript(context) || completion && ecma && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion(context);
    }

    public static boolean isTypeContext(@Nullable PsiElement context, Boolean forceInTypeContext) {
        return forceInTypeContext != null ? forceInTypeContext : context instanceof JSReferenceExpression && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)context);
    }

    private static boolean isStaticContext(PsiElement element) {
        PsiElement p;
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSVariable.class, JSFunction.class, JSClass.class, JSFile.class});
        if (parent instanceof JSClass) {
            return true;
        }
        if (parent instanceof JSFile) {
            PsiElement context = parent.getContext();
            if (context instanceof XmlText) {
                context = context.getParent();
            }
            if (context instanceof XmlTag && "Script".equals(((XmlTag)context).getLocalName())) {
                return true;
            }
        }
        return parent instanceof JSFunction && (p = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSAttributeList.class})) == ((JSFunction)parent).getAttributeList();
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(21);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSReferenceExpression((JSReferenceExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)this).createReferenceExpressionResolver(this, false);
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(file2, this, resolver, incompleteCode);
        if (resolveResultArray == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(22);
        }
        return resolveResultArray;
    }

    @Nullable
    public static JSReferenceExpression getNamespaceReference(JSReferenceExpression thisElement) {
        PsiElement parent = thisElement.getParent();
        if (parent instanceof JSE4XNamespaceReference) {
            return ((JSE4XNamespaceReference)parent).getNamespaceReference();
        }
        return thisElement.getNamespaceElement();
    }

    @Nullable
    public JSExpression getResolveQualifier() {
        PsiElement parent;
        JSExpression qualifier = this.getQualifier();
        if (qualifier == null && (parent = this.getParent()) instanceof JSCallExpression) {
            PsiElement parent1 = JSResolveUtil.getTopReferenceParent(parent.getParent());
            if (parent1 instanceof JSBinaryExpression) {
                while (parent1 instanceof JSBinaryExpression) {
                    parent1 = parent1.getParent();
                }
                if (!(parent1 instanceof JSE4XFilterQueryArgumentList)) {
                    return null;
                }
                PsiElement element = parent1.getParent();
                if (element instanceof JSCallExpression) {
                    parent1 = ((JSCallExpression)element).getMethodExpression();
                }
                if (parent1 instanceof JSExpression && !(parent1 instanceof JSDefinitionExpression)) {
                    return (JSExpression)parent1;
                }
            }
            return null;
        }
        return qualifier;
    }

    public static boolean isLocalResolveQualifier(JSExpression qualifier) {
        return qualifier == null || qualifier instanceof JSThisExpression && !JSResolveUtil.ownerHasExplicitThisParameter(qualifier) || qualifier instanceof JSSuperExpression;
    }

    public boolean shouldCheckReferences() {
        return true;
    }

    public boolean isAttributeReference() {
        return this.getNode().findChildByType(JSTokenTypes.AT) != null;
    }

    public JSReferenceExpression getNamespaceElement() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.E4X_NAMESPACE_REFERENCE);
        return node == null ? null : ((JSE4XNamespaceReference)node.getPsi()).getNamespaceReference();
    }

    public static ResolveResult[] resolveUnqualified(@NotNull String referenceName, PsiElement context, Boolean forceInTypeContext) {
        if (referenceName == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(23);
        }
        SinkResolveProcessor<ResolveResultSink> resolveProcessor = new SinkResolveProcessor<ResolveResultSink>(referenceName, context, new ResolveResultSink(context, referenceName)){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JSQualifiedNamedElement)) {
                    return true;
                }
                super.execute(element, state);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        resolveProcessor.setNeedsAllVariants();
        resolveProcessor.setForceImportsForPlace(!(context instanceof JSReferenceExpressionImpl));
        boolean ecma = context.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        JSReferenceExpressionImpl.doProcessLocalDeclarations(context, null, resolveProcessor, ecma, false, forceInTypeContext);
        HashMap<String, ResolveResult> uniqueResults = new HashMap<String, ResolveResult>();
        for (ResolveResult result2 : resolveProcessor.getResultsAsResolveResults()) {
            String qname = ((JSQualifiedNamedElement)result2.getElement()).getQualifiedName();
            ResolveResult existing = (ResolveResult)uniqueResults.get(qname);
            if (existing != null && (((JSResolveResult)existing).getActionScriptImport() == null || ((JSResolveResult)result2).getActionScriptImport() != null)) continue;
            uniqueResults.put(qname, result2);
        }
        return !uniqueResults.isEmpty() ? uniqueResults.values().toArray(ResolveResult.EMPTY_ARRAY) : ResolveResult.EMPTY_ARRAY;
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof JSReferenceListMember) {
            parent.delete();
        } else {
            super.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionOrProperty";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherResults";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceKind";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAssignedElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveAssignedElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveResultsOverlap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doProcessLocalDeclarations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitActionScriptTypes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isWhereTypeCanBe";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveUnqualified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

