/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvidersRegistry;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLiteralExpressionImpl
extends JSImplicitElementProviderImpl<JSLiteralExpressionStub>
implements JSLiteralExpression,
StubBasedPsiElement<JSLiteralExpressionStub>,
PsiLanguageInjectionHost {
    public static final String BIG_INT_SUFFIX = "n";
    public static final BigInteger INT_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final int MAX_LITERAL_PROCESSING_SIZE = 4096;
    private static final Key<ParameterizedCachedValue<PsiReference[], JSLiteralExpressionImpl>> REFERENCES_KEY = new Key("js.literal.expression.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSLiteralExpressionImpl> REFERENCES_PROVIDER = param -> CachedValueProvider.Result.create((Object)param.createRefs(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    private static final Key<ParameterizedCachedValue<JSLiteralExpressionKind, JSLiteralExpressionImpl>> CACHE_KEY_EXACT = Key.create((String)"JSLiteralExpressionImpl.getExpressionKind.exact");
    protected static final Key<ParameterizedCachedValue<JSLiteralExpressionKind, JSLiteralExpressionImpl>> CACHE_KEY_SIMPLE = Key.create((String)"JSLiteralExpressionImpl.getExpressionKind.simple");
    private static final ParameterizedCachedValueProvider<JSLiteralExpressionKind, JSLiteralExpressionImpl> PROVIDER_EXACT = p -> CachedValueProvider.Result.create((Object)JSLiteralExpressionImpl.getExpressionKindImpl(p, true), (Object[])new Object[]{p});
    protected static final ParameterizedCachedValueProvider<JSLiteralExpressionKind, JSLiteralExpressionImpl> PROVIDER_SIMPLE = p -> CachedValueProvider.Result.create((Object)JSLiteralExpressionImpl.getExpressionKindImpl(p, false), (Object[])new Object[]{p});

    public JSLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub) {
        if (stub == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JSStubElementTypes.LITERAL_EXPRESSION);
    }

    protected JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub, IStubElementType type) {
        if (stub == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        super(stub, type);
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private PsiReference[] createRefs() {
        JSElementIndexingData indexingData = this.getIndexingData();
        if (indexingData != null && !ContainerUtil.isEmpty((Collection)indexingData.getImplicitElements())) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] result2 = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (result2.length == 0 && this.getTextLength() < 4096) {
            JSStringLiteralValueReferenceSet refSet = new JSStringLiteralValueReferenceSet((PsiElement)this);
            refSet.update(this.getText(), 0);
            PsiReference[] references = refSet.getReferences();
            return references.length == 0 || this.hasInjections() ? PsiReference.EMPTY_ARRAY : references;
        }
        return result2.length == 0 || this.hasInjections() ? PsiReference.EMPTY_ARRAY : result2;
    }

    private boolean hasInjections() {
        Ref result2 = new Ref();
        InjectedLanguageManager.getInstance((Project)this.getProject()).enumerate((PsiElement)this, (injectedPsi, places) -> result2.set((Object)true));
        return Boolean.TRUE == result2.get();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSLiteralExpression((JSLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isValidHost() {
        return this.isQuotedLiteral() || this.isRegExpLiteral();
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<JSLiteralExpressionImpl> createLiteralTextEscaper() {
        JSStringLiteralEscaper<JSLiteralExpressionImpl> jSStringLiteralEscaper = new JSStringLiteralEscaper<JSLiteralExpressionImpl>(this){

            protected boolean isRegExpLiteral() {
                return ((JSLiteralExpressionImpl)this.myHost).isRegExpLiteral();
            }

            public boolean isOneLine() {
                return !(JSLiteralExpressionImpl.this instanceof JSStringTemplateExpression);
            }
        };
        if (jSStringLiteralEscaper == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return jSStringLiteralEscaper;
    }

    public static boolean isQuotedLiteral(ASTNode node) {
        return node.getElementType() == JSStubElementTypes.LITERAL_EXPRESSION && node.findChildByType(JSTokenTypes.STRING_LITERALS) != null;
    }

    @NotNull
    public JSLiteralExpressionKind getExpressionKind(boolean computeExactNumericKind) {
        JSLiteralExpressionKind result2 = (JSLiteralExpressionKind)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHE_KEY_SIMPLE, PROVIDER_SIMPLE, false, (Object)this);
        if (!result2.isNumeric() || !computeExactNumericKind) {
            JSLiteralExpressionKind jSLiteralExpressionKind = result2;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(6);
            }
            return jSLiteralExpressionKind;
        }
        JSLiteralExpressionKind jSLiteralExpressionKind = (JSLiteralExpressionKind)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHE_KEY_EXACT, PROVIDER_EXACT, false, (Object)this);
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        return jSLiteralExpressionKind;
    }

    @NotNull
    private static JSLiteralExpressionKind getExpressionKindImpl(@NotNull JSLiteralExpressionImpl literalExpression, boolean computeExactNumericKind) {
        ASTNode node;
        ASTNode firstChild;
        if (literalExpression == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        if ((firstChild = (node = literalExpression.getNode()).getFirstChildNode()) == null) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.UNKNOWN;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(9);
            }
            return jSLiteralExpressionKind;
        }
        IElementType elementType = firstChild.getElementType();
        JSLiteralExpressionKind customKind = JSInheritedLanguagesHelper.getCustomLiteralKind(literalExpression, elementType);
        if (customKind != null) {
            JSLiteralExpressionKind jSLiteralExpressionKind = customKind;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(10);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.TRUE_KEYWORD) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.TRUE;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(11);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.FALSE_KEYWORD) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.FALSE;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(12);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.NUMERIC_LITERAL) {
            if (!computeExactNumericKind) {
                JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.OTHER_NUMERIC;
                if (jSLiteralExpressionKind == null) {
                    JSLiteralExpressionImpl.$$$reportNull$$$0(13);
                }
                return jSLiteralExpressionKind;
            }
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionImpl.getNumericExpressionKind(literalExpression.getText());
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(14);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.REGEXP_LITERAL) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.REGEXP;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(15);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.NULL_KEYWORD) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.NULL;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(16);
            }
            return jSLiteralExpressionKind;
        }
        if (JSLiteralExpressionImpl.isQuotedLiteral(node)) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.QUOTED;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(17);
            }
            return jSLiteralExpressionKind;
        }
        JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.UNKNOWN;
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(18);
        }
        return jSLiteralExpressionKind;
    }

    public static JSLiteralExpressionKind getNumericExpressionKind(@NonNls String text) {
        if (StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
            text = text.substring(1);
        }
        for (Map.Entry<Condition<String>, JSLiteralExpressionKind> entry : JSStringUtil.NUMERIC_MATCHERS.entrySet()) {
            if (!entry.getKey().value((Object)text)) continue;
            JSLiteralExpressionKind value = entry.getValue();
            return StringUtil.endsWith((CharSequence)text, (CharSequence)BIG_INT_SUFFIX) ? value.toBigInt() : value;
        }
        return JSLiteralExpressionKind.OTHER_NUMERIC;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        return JSLiteralImplicitElementProvidersRegistry.calculateIndexingData(this);
    }

    @Nullable
    public String getValueAsPropertyName() {
        JSLiteralExpressionKind kind = this.getExpressionKind(false);
        String text = this.getText();
        if ("undefined".equals(text)) {
            return text;
        }
        if (kind == JSLiteralExpressionKind.NULL) {
            return "null";
        }
        Object value = this.getValue();
        if (value instanceof Boolean || value instanceof BigInteger) {
            return value.toString();
        }
        if (value instanceof Number) {
            return JSPsiImplUtils.convertECMAScriptNumberToString(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    public Object getValue() {
        String expressionText = this.getText();
        if (StringUtil.isEmpty((String)expressionText)) {
            return null;
        }
        JSLiteralExpressionKind kind = this.getExpressionKind(true);
        if (kind.isNumeric()) {
            try {
                double t;
                if (kind.isBigInteger()) {
                    return JSNumberParser.tryParseBigInt(expressionText, kind);
                }
                Double numericValue = JSNumberParser.tryParseNumericValue(expressionText, true);
                if (numericValue != null && !numericValue.isInfinite() && !numericValue.isNaN() && numericValue > -9.223372036854776E18 && numericValue < 9.223372036854776E18 && numericValue.equals(t = Math.ceil(numericValue))) {
                    return numericValue.longValue();
                }
                return numericValue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (kind == JSLiteralExpressionKind.TRUE) {
            return true;
        }
        if (kind == JSLiteralExpressionKind.FALSE) {
            return false;
        }
        if (kind == JSLiteralExpressionKind.QUOTED) {
            return this.getStringValue();
        }
        return expressionText;
    }

    @Nullable
    public String getStringValue() {
        JSLiteralExpressionKind kind = this.getExpressionKind(false);
        if (kind.isNumeric() || kind == JSLiteralExpressionKind.TRUE || kind == JSLiteralExpressionKind.FALSE || kind == JSLiteralExpressionKind.XML) {
            return null;
        }
        String expressionText = this.getText();
        if (StringUtil.isEmpty((String)expressionText)) {
            return null;
        }
        if (JSLiteralExpression.isQuotedLiteral((JSLiteralExpressionKind)kind)) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(expressionText);
        }
        return expressionText;
    }

    @Nullable
    public String getSignificantValue() {
        JSLiteralExpressionStub stub = (JSLiteralExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSignificantValue();
        }
        List<FrameworkIndexingHandler> extensions = FrameworkIndexingHandler.getExtensions((PsiElement)this);
        for (int i = 0; i < extensions.size(); ++i) {
            if (!extensions.get(i).hasSignificantValue(this)) continue;
            return this.getText();
        }
        return null;
    }

    public static boolean isNullExpression(@NotNull ASTNode literalExpression) {
        if (literalExpression == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(19);
        }
        return literalExpression.findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKind";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKindImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionKindImpl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isNullExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSStringLiteralValueReferenceSet
    extends JSReferenceSet {
        private JSStringLiteralValueReferenceSet(@NotNull PsiElement element) {
            if (element == null) {
                JSStringLiteralValueReferenceSet.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Override
        protected PsiReference[] reparse(@NotNull String value, int offset) {
            if (value == null) {
                JSStringLiteralValueReferenceSet.$$$reportNull$$$0(1);
            }
            return new PsiReference[]{this.createTextReference(value, offset)};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl$JSStringLiteralValueReferenceSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reparse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

