/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSRecursiveNodeVisitor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSAsyncReturnType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGeneratorReturnType;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionNodesVisitor
extends JSRecursiveNodeVisitor {
    private final JSFunctionBaseImpl myBase;
    private final JSFunctionCachedData myCachedData;
    private final List<? super JSFunction> myNestedFuns;
    private final List<JSType> myEvaluatedReturnTypes;
    private final List<JSType> myEvaluatedGeneratorReturnTypes;
    private final LinkedHashMap<String, UnqualifiedNamesUsages> myUnqualifiedNamesUsages;

    public JSFunctionNodesVisitor(JSFunctionBaseImpl base, JSFunctionCachedData cachedData, List<? super JSFunction> nestedFuns) {
        this.myBase = base;
        this.myCachedData = cachedData;
        this.myNestedFuns = nestedFuns;
        this.myEvaluatedReturnTypes = new ArrayList<JSType>();
        this.myEvaluatedGeneratorReturnTypes = new ArrayList<JSType>();
        this.myUnqualifiedNamesUsages = new LinkedHashMap();
    }

    public void appendReturnType(JSType type) {
        this.myEvaluatedReturnTypes.add(type);
    }

    @Override
    public void visitAttributeList(ASTNode node) {
    }

    @Override
    public void visitDocComment(ASTNode node) {
    }

    @Override
    protected void visitDestructuringParameter(ASTNode node) {
        super.visitElement(node);
    }

    @Override
    public void visitParameter(ASTNode node) {
        ASTNode child = JSParameterImpl.findParameterNameIdentifier(node);
        if (child == null) {
            child = node.getFirstChildNode();
        }
        UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
        nameUsages.hasDeclaredParameter = true;
    }

    @Override
    public void visitVariable(ASTNode node) {
        super.visitVariable(node);
        ASTNode child = JSVariableBaseImpl.findVariableNameIdentifier(node);
        if (child != null) {
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
            nameUsages.hasDeclaredVariable = true;
        }
    }

    @Override
    public void visitReferenceExpression(ASTNode node) {
        ASTNode childNode;
        if (node.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS) == null && JSFunctionBaseImpl.isInJS(node) && (childNode = node.getFirstChildNode()) != null && childNode.getTreeNext() == null) {
            String nodeText = childNode.getText();
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(nodeText);
            nameUsages.isReferenced = true;
            return;
        }
        super.visitReferenceExpression(node);
    }

    @Override
    public void visitThisExpression(ASTNode node) {
        this.myCachedData.referencesThis = true;
    }

    @Override
    public void visitFunctionExpression(ASTNode node) {
        this.myNestedFuns.add((JSFunction)((JSFunction)node.getPsi()));
    }

    @Override
    public void visitFunctionDeclaration(ASTNode node) {
        this.myNestedFuns.add((JSFunction)((JSFunction)node.getPsi()));
        ASTNode child = JSPsiImplUtils.findNameIdentifierOfFunction(node);
        if (child != null) {
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
            nameUsages.hasDeclaredVariable = true;
        }
    }

    @Override
    public void visitFunctionProperty(ASTNode node) {
        this.myNestedFuns.add((JSFunction)((JSFunction)node.getPsi()));
    }

    @Override
    public void visitBinaryExpression(ASTNode node) {
        ASTNode child = node.findChildByType(JSTokenTypes.OROR);
        if (child != null) {
            this.addRef(node);
        } else {
            child = node.findChildByType(JSTokenTypes.ANDAND);
            if (child != null) {
                this.addRef(node);
            } else {
                ASTNode identifier;
                ASTNode childByType = node.findChildByType(JSTokenTypes.EQUALITY_OPERATIONS);
                if (childByType != null && (identifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, childByType)) != null) {
                    if (identifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                        this.addRef(node);
                    } else {
                        ASTNode firstIdentifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
                        if (firstIdentifier != null && firstIdentifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                            this.addExpr(identifier);
                        }
                    }
                }
            }
        }
        super.visitBinaryExpression(node);
    }

    @Override
    public void visitPrefixExpression(ASTNode node) {
        ASTNode child = node.findChildByType(JSTokenTypes.TYPEOF_KEYWORD);
        if (child == null) {
            child = node.findChildByType(JSTokenTypes.EXCL);
        }
        if (child != null) {
            this.addRef(node);
        }
        super.visitPrefixExpression(node);
    }

    @Override
    public void visitIfStatement(ASTNode node) {
        this.addRef(node);
        super.visitIfStatement(node);
    }

    @Override
    public void visitProperty(ASTNode node) {
        ASTNode expr;
        ASTNode name = JSPropertyImpl.findNameIdentifier(node);
        if (name != null && (expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, name.getTreeNext())) != null && expr != name) {
            this.addExpr(expr);
        }
        super.visitProperty(node);
    }

    @Override
    public void visitArgumentList(ASTNode node) {
        ASTNode expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
        while (expr != null) {
            this.addExpr(expr);
            ASTNode treeNext = expr.getTreeNext();
            expr = treeNext != null ? node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, treeNext) : null;
        }
        super.visitArgumentList(node);
    }

    @Override
    protected void visitYieldExpression(ASTNode node) {
        JSType type;
        JSYieldExpression yieldExpression;
        JSExpression expression;
        if (this.myBase.isGenerator() && (expression = (yieldExpression = (JSYieldExpression)node.getPsi()).getExpression()) != null && (type = this.visitReturnNode(node, expression)) != null) {
            JSFunctionNodesVisitor.addTypeToReturnTypeCollection(yieldExpression.isIterable() ? new JSIterableComponentTypeImpl(type, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true)) : type, this.myEvaluatedReturnTypes);
        }
        super.visitYieldExpression(node);
    }

    @Override
    public void visitReturnStatement(ASTNode node) {
        JSType type = this.visitReturnNode(node, ((JSReturnStatement)node.getPsi()).getExpression());
        if (type != null) {
            JSFunctionNodesVisitor.addTypeToReturnTypeCollection(type, this.myBase.isGenerator() ? this.myEvaluatedGeneratorReturnTypes : this.myEvaluatedReturnTypes);
        }
        super.visitReturnStatement(node);
    }

    @Nullable
    protected JSType visitReturnNode(@NotNull ASTNode context, @Nullable JSExpression expression) {
        String text;
        JSExpression invoked;
        if (context == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(0);
        }
        if (expression instanceof JSNewExpression && (invoked = ((JSNewExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)invoked).getQualifier() == null && (text = invoked.getText()).equals(this.myBase.getName())) {
            UnqualifiedNamesUsages value = this.getOrCreateUnqualifiedNameUsages(text);
            value.isReturnedInNew = true;
        }
        return this.getTypeFromReturnedExpression(context, expression);
    }

    @Nullable
    protected JSType getTypeFromReturnedExpression(@NotNull ASTNode context, @Nullable JSExpression expression) {
        if (context == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(1);
        }
        return JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).getTypeHelper().getTypeForIndexing(expression, context.getPsi());
    }

    private static void addTypeToReturnTypeCollection(@NotNull JSType returnType, @NotNull List<JSType> typeCollection) {
        if (returnType == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(2);
        }
        if (typeCollection == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(3);
        }
        List<JSType> newTypes = JSTypeUtils.addPossibleOption(typeCollection, returnType);
        typeCollection.addAll(newTypes);
    }

    @Nullable
    public JSType getReturnTypeFromEvaluated() {
        return this.wrapTypeIfNeeded(this.addReturnTypeFromEvaluated(this.myEvaluatedReturnTypes, true), this.addReturnTypeFromEvaluated(this.myEvaluatedGeneratorReturnTypes, false));
    }

    @Nullable
    private JSType wrapTypeIfNeeded(@Nullable JSType type, @Nullable JSType typeForGenerator) {
        boolean isGenerator = this.myBase.isGenerator();
        boolean isAsync = ES6PsiUtil.isAsyncContext(this.myBase);
        if (isAsync && !isGenerator) {
            return new JSAsyncReturnType(JSTypeSourceFactory.createTypeSource((PsiElement)this.myBase, true), type == null ? JSAnyType.get((PsiElement)this.myBase, true) : type);
        }
        if (isGenerator) {
            return new JSGeneratorReturnType(JSTypeSourceFactory.createTypeSource((PsiElement)this.myBase, true), type, typeForGenerator, isAsync);
        }
        if (type == null && DialectDetector.isTypeScript((PsiElement)this.myBase) && this.myBase.getBlock() != null && !this.myCachedData.constructor) {
            return new JSVoidType(JSTypeSourceFactory.createTypeSource((PsiElement)this.myBase, true));
        }
        return type;
    }

    @Nullable
    protected JSType addReturnTypeFromEvaluated(List<JSType> types2, boolean canBeVoid) {
        if (this.myBase.isSetProperty()) {
            return null;
        }
        if (this.myBase.isShorthandArrowFunction()) {
            if (types2.isEmpty()) {
                return null;
            }
            return JSFunctionNodesVisitor.allowLiteralWidening(types2.get(0));
        }
        JSBlockStatement element = this.myBase.getBlock();
        if (element == null) {
            return null;
        }
        JSSourceElement[] statements = element.getStatementListItems();
        if (statements.length == 0) {
            return null;
        }
        if (types2.isEmpty() || !this.myBase.isGenerator() && !DialectDetector.isTypeScript((PsiElement)this.myBase) && JSFunctionNodesVisitor.hasImplicitReturnStatement((PsiElement)element)) {
            if (!canBeVoid) {
                return null;
            }
            types2.add(new JSVoidType(JSTypeSourceFactory.createTypeSource((PsiElement)this.myBase, true)));
        }
        if (types2.size() == 1) {
            return JSFunctionNodesVisitor.allowLiteralWidening(types2.get(0));
        }
        return new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)this.myBase, true), JSFunctionNodesVisitor.convertVoidToUndefined(types2));
    }

    @NotNull
    private static List<JSType> convertVoidToUndefined(@NotNull List<JSType> types2) {
        if (types2 == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(4);
        }
        List list2 = ContainerUtil.map(types2, el -> el instanceof JSVoidType ? new JSUndefinedType(el.getSource()) : el);
        if (list2 == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static boolean hasImplicitReturnStatement(@NotNull PsiElement element) {
        if (element == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(6);
        }
        if (element instanceof JSBlockStatement) {
            PsiElement lastChild;
            for (lastChild = element.getLastChild(); lastChild != null && !(lastChild instanceof JSStatement); lastChild = lastChild.getPrevSibling()) {
            }
            return lastChild != null && JSFunctionNodesVisitor.hasImplicitReturnStatement(lastChild);
        }
        if (element instanceof JSIfStatement) {
            JSStatement then = ((JSIfStatement)element).getThen();
            JSStatement anElse = ((JSIfStatement)element).getElse();
            return then == null || anElse == null || JSFunctionNodesVisitor.hasImplicitReturnStatement((PsiElement)then) || JSFunctionNodesVisitor.hasImplicitReturnStatement((PsiElement)anElse);
        }
        if (element instanceof JSReturnStatement) {
            return false;
        }
        return !(element instanceof JSSwitchStatement);
    }

    private static JSType allowLiteralWidening(JSType type) {
        return type instanceof JSLiteralType ? ((JSLiteralType)type).copyWithAllowWidening(true) : type;
    }

    private void addRef(ASTNode node) {
        ASTNode treeNext;
        ASTNode treeParent;
        ASTNode firstExpr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
        this.addExpr(firstExpr);
        if (firstExpr != null && node.getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeParent = node.getTreeParent()).getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeNext = firstExpr.getTreeNext()) != null) {
            this.addExpr(node.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, treeNext));
        }
    }

    private void addExpr(ASTNode expr) {
        ASTNode node;
        if (expr != null && expr.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(expr) == null && (node = expr.getFirstChildNode()).getTreeNext() == null) {
            String ref = node.getText();
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(ref);
            nameUsages.isOptionalCandidate = true;
        }
    }

    void summarizeNamesUsages(TObjectIntHashMap<String> declaredParameters) {
        for (Map.Entry<String, UnqualifiedNamesUsages> entry : this.myUnqualifiedNamesUsages.entrySet()) {
            String name = entry.getKey();
            UnqualifiedNamesUsages namesUsages = entry.getValue();
            if (namesUsages.hasDeclaredParameter) {
                this.myCachedData.declaredParameters.add(name);
            }
            if (namesUsages.hasDeclaredVariable) {
                this.myCachedData.declaredVariableNames.put((Object)name, 0);
            }
            if (namesUsages.isReferenced && !namesUsages.hasDeclaredVariable && !namesUsages.hasDeclaredParameter) {
                this.myCachedData.referencedVariableNames.put((Object)name, 0);
            }
            if (namesUsages.isOptionalCandidate) {
                if (namesUsages.hasDeclaredParameter && !namesUsages.hasDeclaredVariable) {
                    declaredParameters.put((Object)name, 1);
                } else if (!namesUsages.hasDeclaredVariable) {
                    this.myCachedData.referencedVariableNames.put((Object)name, 1);
                }
            }
            if (!namesUsages.isReturnedInNew || namesUsages.hasDeclaredParameter || namesUsages.hasDeclaredVariable) continue;
            this.myCachedData.constructorCanBeInvokedWithoutNew = this.myCachedData.referencesThis;
        }
    }

    @NotNull
    private UnqualifiedNamesUsages getOrCreateUnqualifiedNameUsages(@NotNull String name) {
        UnqualifiedNamesUsages value;
        if (name == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(7);
        }
        if ((value = this.myUnqualifiedNamesUsages.get(name)) == null) {
            value = new UnqualifiedNamesUsages();
            this.myUnqualifiedNamesUsages.put(name, value);
        }
        UnqualifiedNamesUsages unqualifiedNamesUsages = value;
        if (unqualifiedNamesUsages == null) {
            JSFunctionNodesVisitor.$$$reportNull$$$0(8);
        }
        return unqualifiedNamesUsages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCollection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionNodesVisitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionNodesVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertVoidToUndefined";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateUnqualifiedNameUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromReturnedExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTypeToReturnTypeCollection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertVoidToUndefined";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitReturnStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateUnqualifiedNameUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnqualifiedNamesUsages {
        boolean hasDeclaredParameter;
        boolean hasDeclaredVariable;
        boolean isReferenced;
        boolean isOptionalCandidate;
        boolean isReturnedInNew;

        private UnqualifiedNamesUsages() {
        }
    }
}

