/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSDestructuringElementImpl;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSParameterListImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringParameterStubImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringParameterImpl
extends JSDestructuringElementImpl<JSDestructuringParameterStubImpl>
implements JSDestructuringParameter,
StubBasedPsiElement<JSDestructuringParameterStubImpl> {
    public JSDestructuringParameterImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringParameterImpl(JSDestructuringParameterStubImpl stub) {
        super(stub, (IStubElementType)JSStubElementTypes.DESTRUCTURING_PARAMETER);
    }

    @Nullable
    public String getName() {
        JSDestructuringContainer target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.getText();
    }

    public boolean isOptional() {
        JSDestructuringParameterStubImpl stub = (JSDestructuringParameterStubImpl)this.getGreenStub();
        if (stub != null) {
            return stub.isOptional();
        }
        return this.getInitializer() != null || this.getNode().findChildByType(JSTokenTypes.QUEST) != null;
    }

    public boolean isRest() {
        JSDestructuringParameterStubImpl parameterStub = (JSDestructuringParameterStubImpl)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isRest();
        }
        return this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
    }

    @Nullable
    public JSFunction getDeclaringFunction() {
        JSElement owner = JSParameterImpl.getOwner((JSParameterListElement)this);
        return owner instanceof JSFunction ? (JSFunction)owner : null;
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(this.getTypeDecoratorName(), this.getJSType(), this.isOptional(), this.isRest(), true);
        if (jSParameterTypeDecoratorImpl == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(0);
        }
        return jSParameterTypeDecoratorImpl;
    }

    @Nullable
    private String getTypeDecoratorName() {
        JSDestructuringContainer target = this.getTarget();
        if (target == null) {
            return this.getName();
        }
        StringBuilder builder = new StringBuilder();
        ES6PsiUtil.buildSignatureForDestructuringContainer(target, builder, false);
        return builder.toString();
    }

    @Nullable
    public JSType getInferredType() {
        return this.getJSType();
    }

    @Override
    @Nullable
    public JSType getJSType() {
        JSTypeDeclaration element = this.getTypeElement();
        if (element != null) {
            return element.getJSType();
        }
        JSDestructuringContainer target = this.getTarget();
        if (target != null) {
            return JSDestructuringParameterImpl.buildElement(this, (JSElement)target);
        }
        JSDestructuringParameterStubImpl stub = (JSDestructuringParameterStubImpl)this.getGreenStub();
        if (stub != null) {
            String type = stub.getSerializedType();
            if (type != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this, true);
                return JSTypeUtils.parseSerializedType(type, source);
            }
        } else {
            JSType typeFromInitializer = this.buildTypeFromInitializer();
            if (typeFromInitializer != null) {
                return typeFromInitializer;
            }
        }
        return JSAnyType.get((PsiElement)this, true);
    }

    @Nullable
    public JSElement getDeclarationElement() {
        return this.getTarget();
    }

    @NotNull
    private static JSType buildDestructuringObject(@NotNull JSElement context, @NotNull JSDestructuringObject object) {
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(1);
        }
        if (object == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(2);
        }
        ArrayList<Object> member = new ArrayList<Object>();
        for (JSDestructuringProperty property : object.getProperties()) {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            if (property.isRest()) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)property, true);
                JSType stringType = JSNamedTypeFactory.createType("string", source, JSContext.INSTANCE);
                member.add(new JSRecordTypeImpl.IndexSignatureImpl(stringType, (JSType)JSAnyType.get(source), (PsiElement)property, false));
                continue;
            }
            JSInitializerOwner element = property.getDestructuringElement();
            JSType type = JSDestructuringParameterImpl.buildElement(context, (JSElement)element);
            boolean optional = element == null || element.hasOwnInitializer();
            member.add(new JSRecordTypeImpl.PropertySignatureImpl(name, type, optional |= element instanceof JSParameter && ((JSParameter)element).isOptional(), false, (PsiElement)element));
        }
        JSSimpleRecordTypeImpl jSSimpleRecordTypeImpl = new JSSimpleRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)object, true), member);
        if (jSSimpleRecordTypeImpl == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(3);
        }
        return jSSimpleRecordTypeImpl;
    }

    @NotNull
    private static JSType buildElement(@NotNull JSElement context, @Nullable JSElement element) {
        JSType elementType;
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(4);
        }
        if (element instanceof JSDestructuringElement) {
            element = ((JSDestructuringElement)element).getTarget();
        }
        if (element instanceof JSDestructuringObject) {
            JSType jSType = JSDestructuringParameterImpl.buildDestructuringObject(context, (JSDestructuringObject)element);
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        if (element instanceof JSDestructuringArray) {
            JSType jSType = JSDestructuringParameterImpl.buildDestructuringArray(context, (JSDestructuringArray)element);
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (element instanceof JSParameter && !DialectDetector.isTypeScript((PsiElement)context) && (elementType = ((JSParameter)element).getJSType()) != null) {
            JSType jSType = elementType;
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)context, true);
        if (jSAnyType == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(8);
        }
        return jSAnyType;
    }

    private static JSType buildDestructuringArray(@NotNull JSElement context, @NotNull JSDestructuringArray element) {
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(9);
        }
        if (element == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(10);
        }
        JSInitializerOwner[] elements = element.getElements();
        List providers = Arrays.stream(elements).filter(el -> el != null).map(el -> () -> JSDestructuringParameterImpl.buildElement(context, (JSElement)el)).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)context, false);
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
    }

    @Override
    public void delete() throws IncorrectOperationException {
        if (!JSParameterListImpl.handleChildDeletion((JSParameterListElement)this)) {
            super.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecorator";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDestructuringObject";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDestructuringObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDestructuringArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

