/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSArgumentListImpl
extends JSElementImpl
implements JSArgumentList {
    public JSArgumentListImpl(IElementType elementType) {
        super(elementType);
    }

    @NotNull
    public JSExpression[] getArguments() {
        ASTNode[] nodes = JSArgumentListImpl.getArguments(this.getNode());
        if (nodes.length == 0) {
            if (JSExpression.EMPTY_ARRAY == null) {
                JSArgumentListImpl.$$$reportNull$$$0(0);
            }
            return JSExpression.EMPTY_ARRAY;
        }
        JSExpression[] exprs = new JSExpression[nodes.length];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = (JSExpression)nodes[i].getPsi();
        }
        if (exprs == null) {
            JSArgumentListImpl.$$$reportNull$$$0(1);
        }
        return exprs;
    }

    @NotNull
    public static ASTNode[] getArguments(@NotNull ASTNode argumentListNode) {
        if (argumentListNode == null) {
            JSArgumentListImpl.$$$reportNull$$$0(2);
        }
        ASTNode[] aSTNodeArray = argumentListNode.getChildren(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        if (aSTNodeArray == null) {
            JSArgumentListImpl.$$$reportNull$$$0(3);
        }
        return aSTNodeArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSArgumentListImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSArgumentList((JSArgumentList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public void delete() throws IncorrectOperationException {
        PsiElement element = this.getParent();
        element.replace((PsiElement)((JSCallExpression)element).getMethodExpression());
    }

    public boolean hasSpreadElement() {
        return this.getNode().findChildByType((IElementType)JSElementTypes.SPREAD_EXPRESSION) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSArgumentListImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentListNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSArgumentListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

