/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPackageWrapper
extends PsiElementBase
implements JSPackage {
    private final String name;
    private final Project project;
    private final GlobalSearchScope scope;

    public JSPackageWrapper(String _name, Project _project, GlobalSearchScope _scope) {
        this.name = _name;
        this.project = _project;
        this.scope = _scope;
    }

    public String getName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public String getQualifiedName() {
        return this.name;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return JSPsiImplUtils.buildNamespaceFromQualifiedName((JSQualifiedNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            JSPackageWrapper.$$$reportNull$$$0(0);
        }
        int index = this.name.lastIndexOf(46);
        final LinkedHashSet filesToUpdate = new LinkedHashSet();
        JSPackageIndex.processElementsInScope(index == -1 ? "" : this.name.substring(0, index), this.name.substring(index + 1), new JSPackageIndex.PackageElementsProcessor(){

            @Override
            public boolean process(VirtualFile file2, @NotNull String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (kind != JSPackageIndexInfo.Kind.PACKAGE) {
                    return true;
                }
                String expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile(file2, JSPackageWrapper.this.project);
                if (expectedPackageNameFromFile == null || expectedPackageNameFromFile.length() < name.length()) {
                    return true;
                }
                while (expectedPackageNameFromFile != null && !expectedPackageNameFromFile.equals(name)) {
                    file2 = file2.getParent();
                    expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile(file2, JSPackageWrapper.this.project);
                    if (file2 != null) continue;
                    expectedPackageNameFromFile = null;
                }
                if (expectedPackageNameFromFile != null) {
                    filesToUpdate.add(file2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageWrapper$1", "process"));
            }
        }, this.scope, this.project);
        for (VirtualFile file2 : filesToUpdate) {
            try {
                JSPsiImplUtils.doRenameParentDirectoryIfNeeded(file2, newName, (Object)this);
            }
            catch (IOException ex) {
                throw new IncorrectOperationException("rename of js package failed", (Throwable)ex);
            }
        }
        String newPackageName = JSPackageIndex.buildQualifiedName(index != -1 ? this.name.substring(0, index) : "", newName);
        return new JSPackageWrapper(newPackageName, this.project, this.scope);
    }

    public PsiElement getNameIdentifier() {
        return null;
    }

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (jSLanguageDialect == null) {
            JSPackageWrapper.$$$reportNull$$$0(1);
        }
        return jSLanguageDialect;
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            JSPackageWrapper.$$$reportNull$$$0(2);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getParent() {
        return null;
    }

    public PsiFile getContainingFile() {
        return null;
    }

    public PsiElement getFirstChild() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public PsiElement getLastChild() {
        return null;
    }

    public PsiElement getNextSibling() {
        return null;
    }

    public PsiElement getPrevSibling() {
        return null;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            JSPackageWrapper.$$$reportNull$$$0(3);
        }
        return project;
    }

    public int getTextLength() {
        return 0;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    public String getText() {
        return null;
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = new char[]{};
        if (cArray == null) {
            JSPackageWrapper.$$$reportNull$$$0(4);
        }
        return cArray;
    }

    public boolean textContains(char c) {
        return false;
    }

    public ASTNode getNode() {
        return null;
    }

    public ASTNode findNameIdentifier() {
        return null;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.scope;
        if (globalSearchScope == null) {
            JSPackageWrapper.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement byQName;
        LinkedHashSet classQNames;
        String name;
        boolean b;
        if (processor == null) {
            JSPackageWrapper.$$$reportNull$$$0(6);
        }
        if (state == null) {
            JSPackageWrapper.$$$reportNull$$$0(7);
        }
        if (place == null) {
            JSPackageWrapper.$$$reportNull$$$0(8);
        }
        if (b = JSPackageIndex.processElementsInScope(this.name, name = ((ResolveProcessor)processor).getName(), new JSPackageIndex.PackageElementsProcessor(classQNames = new LinkedHashSet(), processor, state){
            final /* synthetic */ Set val$classQNames;
            final /* synthetic */ PsiScopeProcessor val$processor;
            final /* synthetic */ ResolveState val$state;
            {
                this.val$classQNames = set;
                this.val$processor = psiScopeProcessor;
                this.val$state = resolveState;
            }

            @Override
            public boolean process(VirtualFile file2, @NotNull String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                if (name == null) {
                    2.$$$reportNull$$$0(0);
                }
                String qName = JSPackageIndex.buildQualifiedName(JSPackageWrapper.this.name, name);
                if (kind != JSPackageIndexInfo.Kind.PACKAGE) {
                    this.val$classQNames.add(qName);
                    return true;
                }
                return this.val$processor.execute((PsiElement)new JSPackageWrapper(qName, JSPackageWrapper.this.project, JSPackageWrapper.this.scope), this.val$state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageWrapper$2", "process"));
            }
        }, this.scope, this.project)) {
            JSDialectSpecificHandlersFactory factory = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4);
            for (String qName : classQNames) {
                PsiElement clazz = factory.getClassResolver().findClassByQName(qName, place);
                if (clazz == null || processor.execute(clazz, state)) continue;
                b = false;
                break;
            }
        }
        if (b && name != null && (byQName = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(JSPackageIndex.buildQualifiedName(this.name, name), this.scope)) != null) {
            return processor.execute(byQName, ResolveState.initial());
        }
        return b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JSPackageWrapper that = (JSPackageWrapper)((Object)o);
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(that.project) : that.project != null) {
            return false;
        }
        return !(this.scope != null ? !this.scope.equals(that.scope) : that.scope != null);
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 31 * result2 + (this.project != null ? this.project.hashCode() : 0);
        result2 = 31 * result2 + (this.scope != null ? this.scope.hashCode() : 0);
        return result2;
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.project);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return JSPackageWrapper.isPackageReferenceOfSomeForm(this.name, this.project, this.scope, another);
    }

    static boolean isPackageReferenceOfSomeForm(String name, Project project, GlobalSearchScope scope, PsiElement another) {
        if (name == null) {
            name = "";
        }
        if (another instanceof JSPackageWrapper) {
            return name.equals(((JSPackageWrapper)another).name);
        }
        if (another instanceof JSPackageStatement) {
            return name.equals(((JSPackageStatement)another).getQualifiedName());
        }
        if (another instanceof PsiDirectoryContainer) {
            for (PsiDirectory dir : ((PsiDirectoryContainer)another).getDirectories(scope)) {
                if (!name.equals(JSResolveUtil.getExpectedPackageNameFromFile(dir.getVirtualFile(), project))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isWritable() {
        return true;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.PACKAGE_ICON;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSPackageWrapper.$$$reportNull$$$0(9);
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            JSPackageWrapper.$$$reportNull$$$0(10);
        }
        return accessType;
    }

    public boolean isDeprecated() {
        return false;
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
        if (classOrInterface == null) {
            JSPackageWrapper.$$$reportNull$$$0(11);
        }
        return classOrInterface;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = JSNamedTypeFactory.buildJSNamespace((JSElementBase)this);
        if (jSNamespace == null) {
            JSPackageWrapper.$$$reportNull$$$0(12);
        }
        return jSNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

