/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (sourceElement == null || DialectDetector.isActionScript(sourceElement)) {
            return null;
        }
        PsiElement[] elements = JSGotoDeclarationHandler.getGotoDeclarationTargetsImpl(sourceElement);
        if (elements == null) {
            elements = JSGotoDeclarationHandler.resolveQualifiedNameFromJSLiteral(sourceElement, offset);
        }
        if (elements != null && elements.length > 0) {
            return (PsiElement[])Arrays.stream(elements).map(el -> JSTargetElementEvaluator.adjustTargetElement(el, sourceElement)).toArray(PsiElement[]::new);
        }
        return elements;
    }

    @Nullable
    public static PsiElement[] getGotoDeclarationTargetsImpl(@NotNull PsiElement sourceElement) {
        PsiElement resolved;
        List<JSFunctionWithSubstitutor> result2;
        ASTNode node;
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        if ((node = sourceElement.getNode()) == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof ES6ImportedBinding) {
            ES6ImportedBinding importedBinding = (ES6ImportedBinding)parent;
            if (importedBinding.isNamespaceImport()) {
                return null;
            }
            Collection elements = importedBinding.findReferencedElements();
            if (elements.size() > 0) {
                return elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        if ((result2 = TypeScriptSignatureChooser.resolveConstructorOrCallSignature(parent)).size() > 0) {
            return (PsiElement[])result2.stream().map(el -> el.myFunctionItem).toArray(PsiElement[]::new);
        }
        JSReferenceExpression referenceExpression = parent instanceof JSReferenceExpression ? (JSReferenceExpression)parent : null;
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property && ((ES6Property)grandParent).isShorthanded() && (resolved = referenceExpression.resolve()) != null) {
            return new PsiElement[]{resolved};
        }
        if (parent instanceof JSFieldVariable && JSGotoDeclarationHandler.useVariableAsDeclaration((JSFieldVariable)parent, sourceElement) || parent instanceof TypeScriptFunction && JSGotoDeclarationHandler.useFunctionAsDeclaration((TypeScriptFunction)parent, sourceElement)) {
            return new PsiElement[]{parent};
        }
        return null;
    }

    private static boolean useVariableAsDeclaration(@NotNull JSFieldVariable variable, @NotNull PsiElement sourceElement) {
        if (variable == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(2);
        }
        return JSGotoDeclarationHandler.isIdentifier(sourceElement, variable.getNameIdentifier()) && (!(variable instanceof JSParameter) || variable.getReferences().length == 0) && !JSDestructuringUtil.isDestructuring(variable.getParent());
    }

    private static boolean useFunctionAsDeclaration(@NotNull TypeScriptFunction function, @NotNull PsiElement sourceElement) {
        if (function == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(4);
        }
        return JSGotoDeclarationHandler.isIdentifier(sourceElement, function.getNameIdentifier()) && function.getBlock() != null;
    }

    private static boolean isIdentifier(@NotNull PsiElement sourceElement, @Nullable PsiElement name) {
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(5);
        }
        return sourceElement.isEquivalentTo(name);
    }

    @Nullable
    private static PsiElement[] resolveQualifiedNameFromJSLiteral(@Nullable PsiElement sourceElement, int offset) {
        if (!(sourceElement instanceof LeafPsiElement) || ((LeafPsiElement)sourceElement).getElementType() != JSTokenTypes.STRING_LITERAL || !sourceElement.textContains('.')) {
            return null;
        }
        PsiElement literal = sourceElement.getParent();
        if (!(literal instanceof JSLiteralExpression)) {
            return null;
        }
        int offsetInLiteral = offset - literal.getTextRange().getStartOffset();
        PsiReference reference = literal.findReferenceAt(offsetInLiteral);
        if (reference != null && reference.getClass() == JSTextReference.class) {
            ResolveResult[] results;
            List<PsiElement> elements;
            TextRange rangeInLiteral = reference.getRangeInElement();
            String referenceText = rangeInLiteral.substring(literal.getText());
            int offsetInReferenceText = offsetInLiteral - rangeInLiteral.getStartOffset();
            Object qualifiedName = null;
            int componentStart = 0;
            while (componentStart < referenceText.length()) {
                String component;
                int nextDotOffset = referenceText.indexOf(46, componentStart);
                if (nextDotOffset == -1) {
                    nextDotOffset = referenceText.length();
                }
                if (!BasicJavascriptNamesValidator.isIdentifierName(component = referenceText.substring(componentStart, nextDotOffset))) {
                    return null;
                }
                if (componentStart <= offsetInReferenceText) {
                    qualifiedName = JSQualifiedNameImpl.create(component, (JSQualifiedName)qualifiedName);
                }
                componentStart = nextDotOffset + 1;
            }
            if (qualifiedName != null && !qualifiedName.equals(((JSTextReference)reference).getQualifiedName()) && !(elements = JSResolveResult.toElements(results = ((JSTextReference)reference).doResolveQualifiedName((JSQualifiedName)qualifiedName))).isEmpty()) {
                return elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/navigation/JSGotoDeclarationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGotoDeclarationTargetsImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useVariableAsDeclaration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "useFunctionAsDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

