/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSModuleNameInfoImpl
implements JSModuleNameInfo {
    @Nullable
    private final VirtualFile myModule;
    @NotNull
    private final VirtualFile myResolvedFile;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myQuote;

    public JSModuleNameInfoImpl(@Nullable String path, @NotNull VirtualFile module, @NotNull PsiElement context) {
        if (module == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(1);
        }
        this(path, module, module, context, JSFileReference.IMPLICIT_EXTENSIONS, false);
    }

    public JSModuleNameInfoImpl(@Nullable String path, @Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull PsiElement context, String[] extensions, boolean forceExtension) {
        if (resolvedFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(3);
        }
        this.myQuote = JSCodeStyleSettings.getQuote(context);
        this.myModuleName = JSModuleNameInfoImpl.getModuleName(path, moduleFileOrDirectory, context, extensions, forceExtension);
        this.myModule = moduleFileOrDirectory;
        this.myResolvedFile = resolvedFile;
    }

    @NotNull
    public static String getModuleName(@Nullable String path, @Nullable VirtualFile moduleFileOrDirectory, @NotNull PsiElement context) {
        if (context == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(4);
        }
        String string = JSModuleNameInfoImpl.getModuleName(path, moduleFileOrDirectory, context, JSFileReference.IMPLICIT_EXTENSIONS, false);
        if (string == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getModuleName(@Nullable String path, @Nullable VirtualFile moduleFileOrDirectory, @NotNull PsiElement context, @NotNull String[] extensions, boolean forceExtension) {
        boolean useExplicitExtension;
        String extensionWithDot;
        if (context == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(6);
        }
        if (extensions == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)path)) {
            if ("" == null) {
                JSModuleNameInfoImpl.$$$reportNull$$$0(8);
            }
            return "";
        }
        boolean isFile = moduleFileOrDirectory == null || !moduleFileOrDirectory.isDirectory();
        String string = extensionWithDot = isFile && (moduleFileOrDirectory == null || path.endsWith(moduleFileOrDirectory.getName())) ? JSFileReference.findExtension(path, extensions) : null;
        if (extensionWithDot == null) {
            String string2 = path;
            if (string2 == null) {
                JSModuleNameInfoImpl.$$$reportNull$$$0(9);
            }
            return string2;
        }
        boolean bl = useExplicitExtension = forceExtension || TypeScriptImportsResolverProvider.checkUseExplicitExtension(extensionWithDot, context);
        if (useExplicitExtension && !ArrayUtil.contains((String)extensionWithDot, (String[])TypeScriptFileImportsResolver.TS_EXTENSIONS)) {
            String string3 = path;
            if (string3 == null) {
                JSModuleNameInfoImpl.$$$reportNull$$$0(10);
            }
            return string3;
        }
        String withoutExtension = StringUtil.trimEnd((String)path, (String)extensionWithDot);
        String string4 = useExplicitExtension ? withoutExtension + ".js" : withoutExtension;
        if (string4 == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(11);
        }
        return string4;
    }

    @Override
    public boolean isValid() {
        return !StringUtil.isEmpty((String)this.myModuleName);
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myQuote + this.getModuleName() + this.myQuote;
        if (string == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getModuleFileOrDirectory() {
        VirtualFile virtualFile = this.myModule == null ? this.getResolvedFile() : this.myModule;
        if (virtualFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getResolvedFile() {
        VirtualFile virtualFile = this.myResolvedFile;
        if (virtualFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    public String toString() {
        return this.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleNameInfoImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleNameInfoImpl";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFileOrDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

