/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAction
implements QuestionAction {
    public static final Key<Boolean> NO_HINT_KEY = Key.create((String)"ES6.auto.import.no.hint");
    public static final ImportElementFilter DEFAULT_FILTER = new DefaultElementFilter();
    public static final Key<String> NAME_TO_IMPORT = Key.create((String)"name.for.import");
    @Nullable
    protected final Editor myEditor;
    @Nullable
    protected final String myName;
    @Nullable
    protected final PsiElement myContext;
    protected final ImportElementFilter myFilter;

    private static boolean isJSXContext(@NotNull PsiElement context) {
        if (context == null) {
            ES6ImportAction.$$$reportNull$$$0(0);
        }
        return context.getNode().getElementType() == JSTokenTypes.XML_TAG_NAME || context instanceof JSXmlLiteralExpression;
    }

    public ES6ImportAction(@Nullable PsiElement context, @NonNls @Nullable String name, @NotNull ImportElementFilter filter) {
        if (filter == null) {
            ES6ImportAction.$$$reportNull$$$0(1);
        }
        this(null, context, name, filter);
    }

    public ES6ImportAction(@Nullable Editor editor, @Nullable PsiElement context, @NonNls @Nullable String name, @NotNull ImportElementFilter filter) {
        if (filter == null) {
            ES6ImportAction.$$$reportNull$$$0(2);
        }
        this.myContext = context;
        this.myEditor = editor;
        this.myName = name;
        this.myFilter = filter;
    }

    public boolean execute() {
        this.executeForAllVariants();
        return true;
    }

    public void executeForAllVariants() {
        this.executeForAllVariants(null);
    }

    public void executeForAllVariants(@Nullable Consumer<? super JSElement> postProcess) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContext == null || this.myName == null || !this.myContext.isValid()) {
            return;
        }
        if (!this.myFilter.isValidContext(this.myContext)) {
            return;
        }
        List<JSElement> candidates = this.getCandidates();
        if (candidates.isEmpty()) {
            return;
        }
        if (!this.shouldShowPopup(candidates) || this.myEditor == null) {
            this.addImport(candidates, postProcess);
        } else {
            HashMap<PsiElement, JSModuleNameInfo> preRenderedQNames = new HashMap<PsiElement, JSModuleNameInfo>();
            Project project = this.myContext.getProject();
            Collection<JSElement> elementsFromLibraries = ES6ImportAction.getElementsFromLibraries(project, candidates);
            PsiFile file2 = this.myContext.getContainingFile();
            if (elementsFromLibraries.isEmpty()) {
                List<JSElement> finalElements = this.getFinalElements(project, file2, candidates, elementsFromLibraries, preRenderedQNames);
                if (!this.shouldShowPopup(finalElements)) {
                    this.addImport(candidates, postProcess);
                } else {
                    this.setNoHintFlag(true);
                    this.chooseElement(finalElements, preRenderedQNames, postProcess);
                }
                return;
            }
            Runnable calcModuleNamesAndShowPopupIfNecessary = () -> {
                List newCandidates = (List)ReadAction.compute(() -> this.getFinalElements(project, file2, candidates, elementsFromLibraries, preRenderedQNames));
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    this.setNoHintFlag(false);
                    if (newCandidates.isEmpty() || !this.myContext.isValid() || this.myEditor.isDisposed()) {
                        return;
                    }
                    if (!this.shouldShowPopup(newCandidates)) {
                        JSElement item = (JSElement)ContainerUtil.getFirstItem((List)newCandidates);
                        assert (item != null);
                        if (!item.isValid()) {
                            return;
                        }
                        Runnable runnable = () -> this.executeFor(item, postProcess);
                        CommandProcessor.getInstance().executeCommand(item.getProject(), runnable, this.getName(), (Object)this);
                        return;
                    }
                    this.chooseElement(newCandidates, preRenderedQNames, postProcess);
                });
            };
            this.setNoHintFlag(true);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                calcModuleNamesAndShowPopupIfNecessary.run();
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(calcModuleNamesAndShowPopupIfNecessary);
            }
        }
    }

    protected boolean shouldShowPopup(@NotNull List<JSElement> candidates) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(3);
        }
        return candidates.size() > 1;
    }

    private void setNoHintFlag(boolean value) {
        if (this.myContext == null || !this.myContext.isValid()) {
            return;
        }
        PsiElement toSet = this.myContext;
        if (this.myContext.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
            this.myContext.putUserData(NO_HINT_KEY, (Object)value);
            PsiElement parent = this.myContext.getParent();
            toSet = parent == null ? toSet : parent;
        }
        toSet.putUserData(NO_HINT_KEY, (Object)value);
    }

    private void addImport(List<? extends JSElement> candidates, @Nullable Consumer<? super JSElement> postProcess) {
        JSElement candidate = candidates.iterator().next();
        this.executeFor(candidate, postProcess);
    }

    public void executeWithoutPrepare(@NotNull JSElement candidate) {
        if (candidate == null) {
            ES6ImportAction.$$$reportNull$$$0(4);
        }
        assert (this.myContext != null && this.myName != null);
        this.runAction(this.myEditor, this.myName, candidate, this.myContext);
    }

    public void executeFor(@NotNull JSElement candidate, @Nullable Consumer<? super JSElement> postProcess) {
        if (candidate == null) {
            ES6ImportAction.$$$reportNull$$$0(5);
        }
        assert (this.myContext != null && this.myName != null);
        if (!candidate.isValid() || !this.myContext.isValid()) {
            return;
        }
        FileHeaderKeeper keeper = new FileHeaderKeeper(ES6CreateImportUtil.getExternalModuleScope(this.myContext));
        this.executeWithoutPrepare(candidate);
        if (postProcess != null || keeper.canMove()) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> {
                if (postProcess != null) {
                    postProcess.consume((Object)candidate);
                }
                if (keeper.canMove()) {
                    if (this.myEditor != null && !this.myEditor.isDisposed()) {
                        Document document2 = this.myEditor.getDocument();
                        PsiDocumentManager.getInstance((Project)candidate.getProject()).commitDocument(document2);
                    }
                    keeper.moveHeader();
                }
            }));
        }
    }

    @NotNull
    public List<JSElement> getDistinctCandidatesSync() {
        if (this.myContext == null || this.myName == null || !this.myContext.isValid()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ES6ImportAction.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<JSElement> raw = this.getCandidates();
        if (raw.size() <= 1) {
            List<JSElement> list3 = raw;
            if (list3 == null) {
                ES6ImportAction.$$$reportNull$$$0(7);
            }
            return list3;
        }
        Project project = this.myContext.getProject();
        PsiFile file2 = this.myContext.getContainingFile();
        Collection<JSElement> elementsFromLibraries = ES6ImportAction.getElementsFromLibraries(project, raw);
        List<JSElement> list4 = this.getFinalElements(project, file2, raw, elementsFromLibraries, new HashMap<PsiElement, JSModuleNameInfo>());
        if (list4 == null) {
            ES6ImportAction.$$$reportNull$$$0(8);
        }
        return list4;
    }

    @NotNull
    public List<JSElement> getCandidates() {
        if (!this.isContextValid(this.myContext) || this.myName == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ES6ImportAction.$$$reportNull$$$0(9);
            }
            return list2;
        }
        Project project = this.myContext.getProject();
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, this.myContext);
        JSImportPlaceInfo info = new JSImportPlaceInfo(this.myContext);
        ArrayList<JSElement> candidates = new ArrayList<JSElement>();
        ArrayList exportSpecifiers = new ArrayList();
        HashSet scopesWithSpecifierExports = new HashSet();
        Processor processor = CommonProcessors.processAll(toProcess -> {
            if (toProcess instanceof ES6ExportSpecifier) {
                exportSpecifiers.add((ES6ExportSpecifier)toProcess);
                return;
            }
            if (ES6CreateImportUtil.isAvailableForImport((PsiElement)toProcess, info)) {
                JSElement exportScope;
                JSPsiElementBase element;
                candidates.add((JSElement)toProcess);
                if (toProcess instanceof JSPsiElementBase && (element = (JSPsiElementBase)toProcess).isExported() && ES6PsiUtil.isExternalModule((PsiElement)(exportScope = ES6PsiUtil.getExportScope((PsiElement)element)))) {
                    scopesWithSpecifierExports.add(exportScope);
                }
            }
        });
        StubIndex.getInstance().processElements(ES6ExportedNamesIndex.KEY, (Object)this.myName, project, scope, JSElement.class, processor);
        for (ES6ExportSpecifier specifier : exportSpecifiers) {
            JSElement exportScope = ES6PsiUtil.getExportScope((PsiElement)specifier);
            if (exportScope == null || scopesWithSpecifierExports.contains(exportScope) || exportScope == info.getContainer() || !ES6CreateImportUtil.isAcceptableExportSpecifier(specifier)) continue;
            candidates.add((JSElement)specifier);
        }
        Processor assignmentProcessor = CommonProcessors.processAll(toProcess -> {
            JSElement expression = toProcess.getStubSafeElement();
            if (expression instanceof JSQualifiedNamedElement) {
                if (expression.getName() == null) {
                    candidates.add(expression);
                }
            } else {
                candidates.add((JSElement)toProcess);
            }
        });
        StubIndex.getInstance().processElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)this.myName, project, scope, JSExportAssignment.class, assignmentProcessor);
        List<JSElement> result2 = this.additionalProcessCandidates(info, candidates);
        List<JSElement> list3 = this.myFilter.filterByContext(this.myContext, result2);
        if (list3 == null) {
            ES6ImportAction.$$$reportNull$$$0(10);
        }
        return list3;
    }

    @Contract(value="null -> false")
    protected boolean isContextValid(@Nullable PsiElement context) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (context == null || !context.isValid()) {
            return false;
        }
        Project project = context.getProject();
        return !DumbService.isDumb((Project)project) && !project.isDisposed();
    }

    @NotNull
    protected List<JSElement> additionalProcessCandidates(@NotNull JSImportPlaceInfo info, @NotNull List<JSElement> candidates) {
        if (info == null) {
            ES6ImportAction.$$$reportNull$$$0(11);
        }
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(12);
        }
        List<JSElement> list2 = candidates;
        if (list2 == null) {
            ES6ImportAction.$$$reportNull$$$0(13);
        }
        return list2;
    }

    protected void runAction(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            ES6ImportAction.$$$reportNull$$$0(14);
        }
        if (elementToImport == null) {
            ES6ImportAction.$$$reportNull$$$0(15);
        }
        if (place == null) {
            ES6ImportAction.$$$reportNull$$$0(16);
        }
        assert (this.myContext != null);
        PsiFile containingFile = this.myContext.getContainingFile();
        if (containingFile instanceof JSExpressionCodeFragment) {
            ((JSExpressionCodeFragment)containingFile).importElement(elementToImport);
        } else {
            WriteAction.run(() -> ES6ImportPsiUtil.insertJSImport(this.myContext, name, (PsiElement)elementToImport, editor));
        }
    }

    @NotNull
    protected List<JSElement> getFinalElements(@NotNull Project project, @NotNull PsiFile file2, @NotNull List<JSElement> candidates, @NotNull Collection<JSElement> elementsFromLibraries, @NotNull Map<PsiElement, JSModuleNameInfo> renderedTexts) {
        if (project == null) {
            ES6ImportAction.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            ES6ImportAction.$$$reportNull$$$0(18);
        }
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(19);
        }
        if (elementsFromLibraries == null) {
            ES6ImportAction.$$$reportNull$$$0(20);
        }
        if (renderedTexts == null) {
            ES6ImportAction.$$$reportNull$$$0(21);
        }
        if (!file2.isValid() || project.isDisposed() || !project.isOpen()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ES6ImportAction.$$$reportNull$$$0(22);
            }
            return list2;
        }
        candidates = ES6ImportAction.removeMergedElements(candidates, elementsFromLibraries);
        candidates = ES6ImportAction.fillExternalModuleNamesAndFilterByBlacklist(renderedTexts, candidates, file2);
        Map<PsiElement, JSModuleNameInfo> libraryOnlyModulesInfos = ES6ImportAction.createLibraryOnlyModulesInfos(elementsFromLibraries, renderedTexts);
        List<JSElement> withoutSimilar = ES6ImportAction.removeSimilarModules(candidates, renderedTexts);
        List<JSElement> withoutNested = ES6ImportAction.removeNestedLibraryModules(withoutSimilar, libraryOnlyModulesInfos);
        ArrayList sortedResult = ContainerUtil.newArrayList(ES6ImportAction.removeSrcLibraryFiles(withoutNested, libraryOnlyModulesInfos));
        ContainerUtil.sort((List)sortedResult, Comparator.comparing(el -> {
            JSModuleNameInfo info = (JSModuleNameInfo)renderedTexts.get(el);
            return info == null ? Integer.MAX_VALUE : info.getModuleName().length();
        }));
        ArrayList arrayList = sortedResult;
        if (arrayList == null) {
            ES6ImportAction.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    protected static Map<PsiElement, JSModuleNameInfo> createLibraryOnlyModulesInfos(@NotNull Collection<JSElement> elementsFromLibraries, @NotNull Map<PsiElement, JSModuleNameInfo> renderedTexts) {
        if (elementsFromLibraries == null) {
            ES6ImportAction.$$$reportNull$$$0(24);
        }
        if (renderedTexts == null) {
            ES6ImportAction.$$$reportNull$$$0(25);
        }
        HashMap<PsiElement, JSModuleNameInfo> result2 = new HashMap<PsiElement, JSModuleNameInfo>();
        elementsFromLibraries.forEach(el -> {
            JSModuleNameInfo info = (JSModuleNameInfo)renderedTexts.get(el);
            if (info != null) {
                result2.put((PsiElement)el, info);
            }
        });
        HashMap<PsiElement, JSModuleNameInfo> hashMap = result2;
        if (hashMap == null) {
            ES6ImportAction.$$$reportNull$$$0(26);
        }
        return hashMap;
    }

    private void chooseElement(@NotNull List<? extends JSElement> candidates, @NotNull Map<PsiElement, JSModuleNameInfo> preRenderedQNames, @Nullable Consumer<? super JSElement> postProcess) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(27);
        }
        if (preRenderedQNames == null) {
            ES6ImportAction.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiElementProcessor<JSElement> processor = this.createModuleProcessor(postProcess);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myEditor != null) {
                processor.execute((PsiElement)Optional.ofNullable(this.myEditor.getUserData(NAME_TO_IMPORT)).map(name -> (JSElement)ContainerUtil.find((Iterable)candidates, element -> this.getDebugNameForElement((JSElement)element, preRenderedQNames).equals(name))).orElseThrow(() -> new AssertionError((Object)("Import name must be specified for multiple candidates. Available names: " + StreamEx.of((Collection)candidates).map(element -> this.getDebugNameForElement((JSElement)element, preRenderedQNames)).joining((CharSequence)",")))));
            }
            return;
        }
        assert (this.myEditor != null);
        if (this.myEditor.isDisposed()) {
            return;
        }
        NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])candidates.toArray(JSElement.EMPTY_ARRAY)), this.createRenderer(preRenderedQNames), (String)this.getModuleSelectionPopupTitle(), processor).showInBestPositionFor(this.myEditor);
    }

    @NotNull
    protected String getDebugNameForElement(@NotNull JSElement element, @NotNull Map<PsiElement, JSModuleNameInfo> preRenderedQNames) {
        JSModuleNameInfo info;
        if (element == null) {
            ES6ImportAction.$$$reportNull$$$0(29);
        }
        if (preRenderedQNames == null) {
            ES6ImportAction.$$$reportNull$$$0(30);
        }
        String string = (String)ObjectUtils.coalesce((Object)((info = preRenderedQNames.get(element)) == null ? null : info.getPath()), (Object)JSQualifiedNamedElementRenderer.getContainerText(element));
        if (string == null) {
            ES6ImportAction.$$$reportNull$$$0(31);
        }
        return string;
    }

    protected String getModuleSelectionPopupTitle() {
        return JSBundle.message((String)"choose.class.to.import.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getName() {
        String string = "Import " + this.myName;
        if (string == null) {
            ES6ImportAction.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private PsiElementProcessor<JSElement> createModuleProcessor(final @Nullable Consumer<? super JSElement> postProcess) {
        PsiElementProcessor<JSElement> psiElementProcessor = new PsiElementProcessor<JSElement>(){

            public boolean execute(@NotNull JSElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
                    if (ES6ImportAction.this.myContext == null || !ES6ImportAction.this.myContext.isValid() || !element.isValid()) {
                        return;
                    }
                    assert (ES6ImportAction.this.myName != null);
                    ES6ImportAction.this.executeFor(element, (Consumer<? super JSElement>)postProcess);
                }, ES6ImportAction.this.getName(), (Object)this);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/ES6ImportAction$1", "execute"));
            }
        };
        if (psiElementProcessor == null) {
            ES6ImportAction.$$$reportNull$$$0(33);
        }
        return psiElementProcessor;
    }

    @NotNull
    protected PsiElementListCellRenderer<JSElement> createRenderer(final @NotNull Map<PsiElement, JSModuleNameInfo> preRenderedQNames) {
        if (preRenderedQNames == null) {
            ES6ImportAction.$$$reportNull$$$0(34);
        }
        ES6QualifiedNamedElementRenderer<JSElement> eS6QualifiedNamedElementRenderer = new ES6QualifiedNamedElementRenderer<JSElement>(){

            @Override
            protected String getContainerText(JSElement element, String name) {
                String preRenderedQName;
                JSModuleNameInfo info = (JSModuleNameInfo)preRenderedQNames.get(element);
                if (info != null && !StringUtil.isEmpty((String)(preRenderedQName = info.getPath()))) {
                    return "(" + preRenderedQName + ")";
                }
                return super.getContainerText(element, name);
            }
        };
        if (eS6QualifiedNamedElementRenderer == null) {
            ES6ImportAction.$$$reportNull$$$0(35);
        }
        return eS6QualifiedNamedElementRenderer;
    }

    protected static List<JSElement> fillExternalModuleNamesAndFilterByBlacklist(@NotNull Map<PsiElement, JSModuleNameInfo> renderedText, @NotNull Collection<? extends JSElement> candidates, @NotNull PsiFile file2) {
        if (renderedText == null) {
            ES6ImportAction.$$$reportNull$$$0(36);
        }
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            ES6ImportAction.$$$reportNull$$$0(38);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<JSElement> filtered = new ArrayList<JSElement>();
        for (JSElement jSElement : candidates) {
            PsiFile containingFile = jSElement.getContainingFile();
            if (containingFile instanceof JSFile && ((JSFile)containingFile).isCommonJSModule()) {
                JSModuleNameInfo nameToModule = ES6CreateImportUtil.getExternalFileModuleName(jSElement, (PsiElement)file2, true);
                if (nameToModule == null) continue;
                filtered.add(jSElement);
                renderedText.put((PsiElement)jSElement, nameToModule);
                continue;
            }
            filtered.add(jSElement);
        }
        return filtered;
    }

    private static boolean checkReferenceExpressionAcceptable(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            ES6ImportAction.$$$reportNull$$$0(39);
        }
        if (!referenceExpression.isValid() || referenceExpression.getQualifier() != null) {
            return false;
        }
        String name = referenceExpression.getReferenceName();
        return JSStubBasedPsiTreeUtil.resolveReferenceLocally((PsiPolyVariantReference)referenceExpression, name) == null;
    }

    @NotNull
    private static Collection<JSElement> getElementsFromLibraries(@NotNull Project project, @NotNull Collection<? extends JSElement> candidates) {
        if (project == null) {
            ES6ImportAction.$$$reportNull$$$0(40);
        }
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(41);
        }
        List list2 = ContainerUtil.filter(candidates, element -> {
            PsiFile file2 = element.getContainingFile();
            if (!(file2 instanceof JSFile) || !((JSFile)file2).isCommonJSModule()) {
                return false;
            }
            VirtualFile fileToSearch = file2.getVirtualFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
            if (virtualFile == null) {
                return false;
            }
            Pair<VirtualFile, VirtualFile> parentLibraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(project, fileToSearch, JSLibraryUtil.LIBRARY_DIR_NAMES);
            return parentLibraryDirectory != null;
        });
        if (list2 == null) {
            ES6ImportAction.$$$reportNull$$$0(42);
        }
        return list2;
    }

    @NotNull
    protected static List<JSElement> removeMergedElements(@NotNull List<JSElement> candidates, @NotNull Collection<JSElement> elementsFromLibraries) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(43);
        }
        if (elementsFromLibraries == null) {
            ES6ImportAction.$$$reportNull$$$0(44);
        }
        HashSet<String> qNames = new HashSet<String>();
        HashSet<JSElement> toRemove = new HashSet<JSElement>();
        for (JSElement candidate : candidates) {
            PsiElement module;
            String qName;
            if (elementsFromLibraries.contains(candidate) || StringUtil.isEmpty((String)(qName = JSQualifiedNamedElementRenderer.getQualifiedName(candidate))) || (module = ES6PsiUtil.findExternalModule((PsiElement)candidate)) != null || qNames.add(qName)) continue;
            toRemove.add(candidate);
        }
        if (toRemove.isEmpty()) {
            List<JSElement> list2 = candidates;
            if (list2 == null) {
                ES6ImportAction.$$$reportNull$$$0(45);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter(candidates, el -> !toRemove.contains(el));
        if (list3 == null) {
            ES6ImportAction.$$$reportNull$$$0(46);
        }
        return list3;
    }

    @NotNull
    private static List<JSElement> removeSimilarModules(@NotNull List<JSElement> candidates, @NotNull Map<PsiElement, JSModuleNameInfo> calculatedModules) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(47);
        }
        if (calculatedModules == null) {
            ES6ImportAction.$$$reportNull$$$0(48);
        }
        if (calculatedModules.isEmpty() || calculatedModules.size() == 1) {
            List<JSElement> list2 = candidates;
            if (list2 == null) {
                ES6ImportAction.$$$reportNull$$$0(49);
            }
            return list2;
        }
        HashSet toRemove = new HashSet();
        Set<Map.Entry<PsiElement, JSModuleNameInfo>> entries = calculatedModules.entrySet();
        HashSet uniqueModuleNamesForSymbols = new HashSet();
        HashSet uniqueModuleNamesForModules = new HashSet();
        entries.forEach(entry -> {
            JSModuleNameInfo moduleInfo = (JSModuleNameInfo)entry.getValue();
            PsiElement elementToImport = (PsiElement)entry.getKey();
            String pathText = moduleInfo.getModuleName();
            if (!StringUtil.isEmpty((String)pathText)) {
                if (elementToImport instanceof TypeScriptModule) {
                    if (!uniqueModuleNamesForModules.add(pathText)) {
                        toRemove.add(elementToImport);
                    }
                } else if (!uniqueModuleNamesForSymbols.add(pathText)) {
                    toRemove.add(elementToImport);
                }
            }
        });
        List list3 = ((StreamEx)StreamEx.of(candidates).filter(el -> !toRemove.contains(el))).toList();
        if (list3 == null) {
            ES6ImportAction.$$$reportNull$$$0(50);
        }
        return list3;
    }

    @NotNull
    private static List<JSElement> removeNestedLibraryModules(@NotNull List<JSElement> candidates, @NotNull Map<PsiElement, JSModuleNameInfo> calculatedModules) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(51);
        }
        if (calculatedModules == null) {
            ES6ImportAction.$$$reportNull$$$0(52);
        }
        if (candidates.size() <= 1) {
            List<JSElement> list2 = candidates;
            if (list2 == null) {
                ES6ImportAction.$$$reportNull$$$0(53);
            }
            return list2;
        }
        List rootPackages = ((StreamEx)StreamEx.of(calculatedModules.values()).map(el -> el.getModuleFileOrDirectory()).filter(el -> el.findChild("package.json") != null)).toList();
        if (rootPackages.isEmpty()) {
            List<JSElement> list3 = candidates;
            if (list3 == null) {
                ES6ImportAction.$$$reportNull$$$0(54);
            }
            return list3;
        }
        List list4 = ((StreamEx)StreamEx.of(candidates).filter(el -> {
            JSModuleNameInfo moduleInfo = (JSModuleNameInfo)calculatedModules.get(el);
            if (moduleInfo == null) {
                return true;
            }
            VirtualFile moduleFileOrDirectory = moduleInfo.getModuleFileOrDirectory();
            if (!moduleFileOrDirectory.isDirectory()) {
                return true;
            }
            return rootPackages.stream().noneMatch(root -> VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)moduleFileOrDirectory, (boolean)true));
        })).toList();
        if (list4 == null) {
            ES6ImportAction.$$$reportNull$$$0(55);
        }
        return list4;
    }

    @NotNull
    protected static List<JSElement> removeSrcLibraryFiles(@NotNull List<JSElement> candidates, @NotNull Map<PsiElement, JSModuleNameInfo> calculatedModules) {
        if (candidates == null) {
            ES6ImportAction.$$$reportNull$$$0(56);
        }
        if (calculatedModules == null) {
            ES6ImportAction.$$$reportNull$$$0(57);
        }
        if (candidates.size() <= 1) {
            List<JSElement> list2 = candidates;
            if (list2 == null) {
                ES6ImportAction.$$$reportNull$$$0(58);
            }
            return list2;
        }
        List<JSElement> newCandidates = ContainerUtil.filter(candidates, el -> {
            JSModuleNameInfo info = (JSModuleNameInfo)calculatedModules.get(el);
            if (info == null) {
                return true;
            }
            String path = info.getModuleName();
            return !path.contains("/src/");
        });
        List<JSElement> list3 = newCandidates.size() > 0 ? newCandidates : candidates;
        if (list3 == null) {
            ES6ImportAction.$$$reportNull$$$0(59);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 27: 
            case 37: 
            case 41: 
            case 43: 
            case 47: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/ES6ImportAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 24: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsFromLibraries";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedTexts";
                break;
            }
            case 28: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preRenderedQNames";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedText";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 48: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculatedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/ES6ImportAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistinctCandidatesSync";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "additionalProcessCandidates";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalElements";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryOnlyModulesInfos";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugNameForElement";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleProcessor";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromLibraries";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMergedElements";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSimilarModules";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNestedLibraryModules";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSrcLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJSXContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowPopup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeWithoutPrepare";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeFor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "additionalProcessCandidates";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runAction";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFinalElements";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryOnlyModulesInfos";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDebugNameForElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "fillExternalModuleNamesAndFilterByBlacklist";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpressionAcceptable";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getElementsFromLibraries";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeMergedElements";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removeSimilarModules";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedLibraryModules";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeSrcLibraryFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ImportElementFilter {
        @NotNull
        public List<JSElement> filterByContext(@NotNull PsiElement var1, @NotNull List<JSElement> var2);

        public boolean isValidContext(@NotNull PsiElement var1);
    }

    public static class DefaultElementFilter
    implements ImportElementFilter {
        @Override
        @NotNull
        public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result2) {
            if (context == null) {
                DefaultElementFilter.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                DefaultElementFilter.$$$reportNull$$$0(1);
            }
            if (result2.isEmpty()) {
                List<JSElement> list2 = result2;
                if (list2 == null) {
                    DefaultElementFilter.$$$reportNull$$$0(2);
                }
                return list2;
            }
            if (ES6ImportAction.isJSXContext(context)) {
                List list3 = ContainerUtil.filter(result2, el -> {
                    if (!ReactXmlExtension.isPossibleReactComponent((PsiElement)el)) {
                        return false;
                    }
                    JSElement scope = ES6PsiUtil.getExportScope((PsiElement)el);
                    if (scope == null) {
                        return false;
                    }
                    return ES6PsiUtil.isExternalModule((PsiElement)scope);
                });
                if (list3 == null) {
                    DefaultElementFilter.$$$reportNull$$$0(3);
                }
                return list3;
            }
            List<JSElement> list4 = result2;
            if (list4 == null) {
                DefaultElementFilter.$$$reportNull$$$0(4);
            }
            return list4;
        }

        @Override
        public boolean isValidContext(@NotNull PsiElement context) {
            if (context == null) {
                DefaultElementFilter.$$$reportNull$$$0(5);
            }
            if (ES6ImportAction.isJSXContext(context)) {
                JSXmlLiteralExpression expression = (JSXmlLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSXmlLiteralExpression.class, (boolean)false);
                if (expression != null) {
                    PsiPolyVariantReference topLevelReference = JSXResolveUtil.getTopLevelReference(expression);
                    if (topLevelReference == null) {
                        return false;
                    }
                    return JSStubBasedPsiTreeUtil.resolveReferenceLocally(topLevelReference, topLevelReference.getCanonicalText()) == null;
                }
                return true;
            }
            return !(context instanceof JSReferenceExpression) || ES6ImportAction.checkReferenceExpressionAcceptable((JSReferenceExpression)context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterByContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "filterByContext";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidContext";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

