/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.jshint.JSHintConfiguration;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile fileAtElement = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (fileAtElement == null) {
            return null;
        }
        Project project = element.getProject();
        JSHintConfiguration configuration = JSHintConfiguration.getInstance(project);
        JSHintState state = (JSHintState)configuration.getExtendedState().getState();
        String path = fileAtElement.getPath();
        String configPath = FileUtil.toSystemIndependentName((String)state.getCustomConfigFilePath());
        if (!configPath.equals(path)) {
            return null;
        }
        return new MyRefactoringElementListener(configuration);
    }

    private static class MyRefactoringElementListener
    extends UndoRefactoringElementAdapter {
        private final JSHintConfiguration myConfiguration;

        MyRefactoringElementListener(@NotNull JSHintConfiguration configuration) {
            if (configuration == null) {
                MyRefactoringElementListener.$$$reportNull$$$0(0);
            }
            this.myConfiguration = configuration;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            VirtualFile newFile;
            if (element == null) {
                MyRefactoringElementListener.$$$reportNull$$$0(1);
            }
            if ((newFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null) {
                ExtendedLinterState extendedState = this.myConfiguration.getExtendedState();
                JSHintState.Builder builder = new JSHintState.Builder((JSHintState)extendedState.getState());
                builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)newFile.getPath()));
                this.myConfiguration.setExtendedState(extendedState.isEnabled(), builder.build());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintRefactoringElementListenerProvider$MyRefactoringElementListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refactored";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

