/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.eslint.ESLintJsonProblemsParser;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintRequestData;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ESLintBasedLanguageService<TStoredState extends JSNpmLinterState<TStoredState>>
extends JSLanguageServiceBase
implements EslintLanguageServiceClient {
    @NotNull
    private final NodePackage myNodePackage;
    @NotNull
    private final VirtualFile myWorkingDirectory;

    public ESLintBasedLanguageService(@NotNull Project project, @NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory) {
        if (project == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(0);
        }
        if (nodePackage == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(2);
        }
        super(project);
        this.myNodePackage = nodePackage;
        this.myWorkingDirectory = workingDirectory;
    }

    @Override
    @NotNull
    public NodePackage getNodePackage() {
        NodePackage nodePackage = this.myNodePackage;
        if (nodePackage == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    @Override
    @NotNull
    public VirtualFile getWorkingDirectory() {
        VirtualFile virtualFile = this.myWorkingDirectory;
        if (virtualFile == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public CompletableFuture<EslintLanguageServiceClient.Response<List<EslintError>>> highlight(@NotNull EslintRequestData requestData, String extraOptions) {
        if (requestData == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)requestData.getFileToLintContent())) {
            return null;
        }
        VirtualFile virtualFile = requestData.getFileToLint();
        String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getSpecifiedConfigFile());
        String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile);
        String eslintIgnoreFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getEslintIgnoreFile());
        if (path == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            String error = JSLanguageServiceUtil.getLanguageServiceCreationError(this);
            return CompletableFuture.completedFuture(EslintLanguageServiceClient.Response.error(error, false));
        }
        GetErrorsCommand command = new GetErrorsCommand(path, configPath, requestData.getFileToLintContent(), extraOptions, eslintIgnoreFilePath, requestData.getFileKind().getStringValue());
        return process.execute(command, ESLintBasedLanguageService.createHighlightProcessor());
    }

    @Override
    @Nullable
    public CompletableFuture<EslintLanguageServiceClient.Response<String>> fixFile(@NotNull EslintRequestData requestData, String extraOptions) {
        if (requestData == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(6);
        }
        VirtualFile virtualFile = requestData.getFileToLint();
        String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getSpecifiedConfigFile());
        String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile);
        String ignoreFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getEslintIgnoreFile());
        if (path == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return CompletableFuture.completedFuture(EslintLanguageServiceClient.Response.error(JSLanguageServiceUtil.getLanguageServiceCreationError(this), false));
        }
        FixErrorsCommand command = new FixErrorsCommand(path, configPath, requestData.getFileToLintContent(), extraOptions, ignoreFilePath, requestData.getFileKind().getStringValue());
        return process.execute(command, (serviceObject, answer) -> ESLintBasedLanguageService.processFixFileResponse(answer));
    }

    @NotNull
    protected abstract Class<? extends JSLinterConfiguration<TStoredState>> getConfigurationClass();

    protected void fillInitialProtocolState(@NotNull ESLintLanguageServiceInitialState protocolState, @NotNull TStoredState storedState) {
        if (protocolState == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(7);
        }
        if (storedState == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(8);
        }
        protocolState.eslintPackagePath = LocalFilePath.create(this.myNodePackage.getSystemDependentPath());
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<EslintLanguageServiceClient.Response<List<EslintError>>> createHighlightProcessor() {
        JSLanguageServiceCommandProcessor<EslintLanguageServiceClient.Response<List<EslintError>>> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            String languageServiceError = JsonUtil.getChildAsString((JsonObject)answer.getElement(), (String)"error");
            if (languageServiceError != null) {
                boolean isNoConfigFile = JsonUtil.getChildAsBoolean((JsonObject)answer.getElement(), (String)"isNoConfigFile", (boolean)false);
                return EslintLanguageServiceClient.Response.error(languageServiceError, isNoConfigFile);
            }
            ESLintJsonProblemsParser parser = ESLintJsonProblemsParser.parse(answer.getElement());
            return new EslintLanguageServiceClient.Response<List<EslintError>>(parser.getFileLevelError(), parser.getErrors(), false);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(9);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    private static EslintLanguageServiceClient.Response<String> processFixFileResponse(@NotNull JSLanguageServiceAnswer answer) {
        JsonObject element;
        JsonObject responseObject;
        String languageServiceError;
        if (answer == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(10);
        }
        if ((languageServiceError = JsonUtil.getChildAsString((JsonObject)(responseObject = answer.getElement()), (String)"error")) != null) {
            EslintLanguageServiceClient.Response<String> response = EslintLanguageServiceClient.Response.error(languageServiceError, false);
            if (response == null) {
                ESLintBasedLanguageService.$$$reportNull$$$0(11);
            }
            return response;
        }
        JsonObject body = JsonUtil.getChildAsObject((JsonObject)responseObject, (String)"body");
        JsonArray response = JsonUtil.getChildAsArray((JsonObject)body, (String)"results");
        if (response == null || response.size() == 0) {
            EslintLanguageServiceClient.Response<Object> response2 = EslintLanguageServiceClient.Response.ok(null);
            if (response2 == null) {
                ESLintBasedLanguageService.$$$reportNull$$$0(12);
            }
            return response2;
        }
        JsonObject jsonObject = element = response.get(0).isJsonObject() ? response.get(0).getAsJsonObject() : null;
        if (element == null) {
            EslintLanguageServiceClient.Response<String> response3 = EslintLanguageServiceClient.Response.error("Unexpected Language service response: " + responseObject.toString(), false);
            if (response3 == null) {
                ESLintBasedLanguageService.$$$reportNull$$$0(13);
            }
            return response3;
        }
        EslintLanguageServiceClient.Response<String> response4 = EslintLanguageServiceClient.Response.ok(JsonUtil.getChildAsString((JsonObject)element, (String)"output"));
        if (response4 == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(14);
        }
        return response4;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        return new JSLanguageServiceQueueImpl(this.myProject, new Protocol(StringUtil.toLowerCase((String)this.getDebugName()), this.myProject, Consumer.EMPTY_CONSUMER), this.myProcessConnector, this.myDefaultReporter, new JSLanguageServiceDefaultCacheData());
    }

    @Override
    protected boolean needInitToolWindow() {
        return false;
    }

    @NotNull
    private ExtendedLinterState<TStoredState> getExtendedState() {
        ExtendedLinterState<TStoredState> extendedLinterState = JSLinterConfiguration.getInstance(this.myProject, this.getConfigurationClass()).getExtendedState();
        if (extendedLinterState == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(15);
        }
        return extendedLinterState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storedState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightProcessor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processFixFileResponse";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillInitialProtocolState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processFixFileResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        public Protocol(@NotNull String serviceName, @NotNull Project project, Consumer<?> readyConsumer) {
            if (project == null) {
                Protocol.$$$reportNull$$$0(0);
            }
            if (readyConsumer == null) {
                Protocol.$$$reportNull$$$0(1);
            }
            super(serviceName, project, readyConsumer);
        }

        @Override
        protected String getWorkingDirectory() {
            return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(ESLintBasedLanguageService.this.myWorkingDirectory);
        }

        public void dispose() {
        }

        @Override
        @Nullable
        protected NodeJsInterpreter getInterpreter() {
            ExtendedLinterState extendedState = ESLintBasedLanguageService.this.getExtendedState();
            return JSLanguageServiceUtil.getInterpreterIfValid(((JSNpmLinterState)extendedState.getState()).getInterpreterRef().resolve(this.myProject));
        }

        @Override
        protected void addNodeProcessAdditionalArguments(@NotNull GeneralCommandLine commandLine) {
            if (commandLine == null) {
                Protocol.$$$reportNull$$$0(2);
            }
            super.addNodeProcessAdditionalArguments(commandLine);
            if (this.myServiceName != null) {
                JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(commandLine, this.myServiceName, () -> Registry.stringValue((String)"eslint.service.node.arguments"));
            }
            JSLanguageServiceUtil.addNodePathFromRegistry(commandLine, () -> Registry.stringValue((String)"eslint.service.node.path"));
        }

        @Override
        protected JSLanguageServiceInitialState createState() {
            ESLintLanguageServiceInitialState protocolState = new ESLintLanguageServiceInitialState();
            ESLintBasedLanguageService.this.fillInitialProtocolState(protocolState, (JSNpmLinterState)ESLintBasedLanguageService.this.getExtendedState().getState());
            protocolState.pluginName = "ESLint";
            File service = new File(JSLanguageServiceUtil.getPluginDirectory(this.getClass(), "languageService"), "eslint/bin/eslint-plugin-provider.js");
            if (!service.exists()) {
                JSLanguageServiceQueue.LOGGER.info("ESLint plugin not found");
            }
            protocolState.pluginPath = LocalFilePath.create(service.getAbsolutePath());
            return protocolState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readyConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Protocol";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addNodeProcessAdditionalArguments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FixErrorsCommand
    extends BaseCommand {
        FixErrorsCommand(String fileName, String configPath, String content, String extraOptions, String ignoreFilePath, String fileKind) {
            super(fileName, configPath, content, extraOptions, ignoreFilePath, fileKind);
        }

        @Override
        @NotNull
        public String getCommand() {
            if ("FixErrors" == null) {
                FixErrorsCommand.$$$reportNull$$$0(0);
            }
            return "FixErrors";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$FixErrorsCommand", "getCommand"));
        }
    }

    private static class GetErrorsCommand
    extends BaseCommand {
        private GetErrorsCommand(String fileName, String configPath, String content, String extraOptions, String ignoreFilePath, String fileKind) {
            super(fileName, configPath, content, extraOptions, ignoreFilePath, fileKind);
        }

        @Override
        @NotNull
        public String getCommand() {
            if ("GetErrors" == null) {
                GetErrorsCommand.$$$reportNull$$$0(0);
            }
            return "GetErrors";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$GetErrorsCommand", "getCommand"));
        }
    }

    private static abstract class BaseCommand
    implements JSLanguageServiceCommand,
    JSLanguageServiceSimpleCommand,
    JSLanguageServiceObject {
        public String fileKind;
        public LocalFilePath fileName;
        public LocalFilePath configPath;
        public String content;
        public String extraOptions;
        public LocalFilePath ignoreFilePath;

        BaseCommand(String fileName, String configPath, String content, String extraOptions, String ignoreFilePath, String fileKind) {
            this.fileName = LocalFilePath.create(fileName);
            this.configPath = LocalFilePath.create(configPath);
            this.content = content;
            this.extraOptions = extraOptions;
            this.ignoreFilePath = LocalFilePath.create(ignoreFilePath);
            this.fileKind = fileKind;
        }

        @Override
        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            BaseCommand baseCommand = this;
            if (baseCommand == null) {
                BaseCommand.$$$reportNull$$$0(0);
            }
            return baseCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$BaseCommand", "toSerializableObject"));
        }
    }
}

