/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.ESLintSuppressionUtil;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EsLintFixAction;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintFixSingleErrorAction;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintExternalAnnotator
extends JSLinterExternalAnnotator<EslintState> {
    private static final EslintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new EslintExternalAnnotator(false);

    @NotNull
    public static EslintExternalAnnotator getInstanceForBatchInspection() {
        EslintExternalAnnotator eslintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (eslintExternalAnnotator == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(0);
        }
        return eslintExternalAnnotator;
    }

    public EslintExternalAnnotator() {
        this(true);
    }

    public EslintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected UntypedJSLinterConfigurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(1);
        }
        EslintConfigurable eslintConfigurable = new EslintConfigurable(project, true);
        if (eslintConfigurable == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(2);
        }
        return eslintConfigurable;
    }

    @Override
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected Class<EslintInspection> getInspectionClass() {
        return EslintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(3);
        }
        return EslintUtil.isPossiblyAcceptableFileType(file2);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult annotate(@NotNull JSLinterInput<EslintState> input) {
        if (input == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(4);
        }
        EslintState state = input.getState();
        EslintLanguageServiceManager languageServiceManager = EslintLanguageServiceManager.getInstance(input.getProject());
        return languageServiceManager.useService(input.getVirtualFile(), state.getNodePackageRef(), service -> {
            if (service == null) {
                return JSLinterAnnotationResult.empty();
            }
            return EsLintExternalRunner.highlight(input, service, this.isOnTheFly());
        });
    }

    @Override
    public void apply(@NotNull PsiFile file2, @Nullable JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (annotationResult == null) {
            return;
        }
        IntentionAction fixFileAction = new EsLintFixAction().asIntentionAction();
        String toolName = JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
        Icon icon = JavaScriptLanguageIcons.FileTypes.Eslint;
        EslintExternalAnnotator.apply(file2, annotationResult, holder, fixFileAction, toolName, icon, true, null, this.getInspectionClass());
    }

    public static void apply(@NotNull PsiFile file2, @NotNull JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder, @NotNull IntentionAction fixFileAction, @NotNull String toolName, @Nullable Icon icon, boolean editConfig, @Nullable String editSettingCaption, Class<? extends JSLinterInspection> inspectionClass) {
        Document document2;
        if (file2 == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(7);
        }
        if (annotationResult == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(9);
        }
        if (fixFileAction == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(10);
        }
        if (toolName == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(11);
        }
        long documentModificationStamp = (document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2)) != null ? document2.getModificationStamp() : -1L;
        EslintConfigurable configurable = new EslintConfigurable(file2.getProject(), true);
        JSLinterEditSettingsAction editSettingsAction = new JSLinterEditSettingsAction(configurable, (String)ObjectUtils.coalesce((Object)editSettingCaption, (Object)configurable.getDisplayName()), icon);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditConfig(editConfig).setEditSettingsAction(editSettingsAction).setErrorToIntentionConverter((Convertor<JSLinterErrorBase, List<IntentionAction>>)((Convertor)error -> {
            if (!(error instanceof EslintError)) {
                return ContainerUtil.emptyList();
            }
            ArrayList<EslintFixSingleErrorAction> result2 = new ArrayList<EslintFixSingleErrorAction>();
            EslintError eslintError = (EslintError)error;
            if (eslintError.getFixInfo() != null) {
                if (document2 != null && !holder.isBatchMode()) {
                    result2.add(new EslintFixSingleErrorAction(file2, eslintError, toolName, document2.getModificationStamp()));
                }
                result2.add((EslintFixSingleErrorAction)fixFileAction);
            } else if (!holder.isBatchMode()) {
                ContainerUtil.addIfNotNull(result2, (Object)ESLintSuppressionUtil.INSTANCE.getHighPrioritySuppressForLineAction(eslintError, documentModificationStamp));
            }
            return result2;
        })).setProblemGroup((Function<JSLinterErrorBase, ProblemGroup>)((Function)error -> {
            if (holder.isBatchMode()) {
                return null;
            }
            if (error instanceof EslintError) {
                SuppressIntentionAction[] intentionActions = ESLintSuppressionUtil.INSTANCE.getSuppressionsForError((EslintError)error, documentModificationStamp);
                return new JSAnnotatorProblemGroup(intentionActions, null);
            }
            return null;
        }));
        new JSLinterAnnotationsBuilder(file2, annotationResult, holder, configurable, toolName + ": ", inspectionClass, fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).setDefaultFileLevelErrorIcon(icon).apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixFileAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceForBatchInspection";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

