/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.JSXCommentProvider;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterSuppressionUtil {
    protected JSLinterSuppressionUtil() {
    }

    @Nullable
    public IntentionAction getHighPrioritySuppressForLineAction(@NotNull JSLinterError error, long documentModificationStamp) {
        String code;
        if (error == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(code = error.getCode()))) {
            return null;
        }
        return new MyHighPriorityFix(new SuppressForLineIntentionAction(code, error.getLine(), documentModificationStamp));
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressionsForError(@NotNull JSLinterError error, long documentModificationStamp) {
        String code;
        if (error == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(code = error.getCode()))) {
            if (SuppressIntentionAction.EMPTY_ARRAY == null) {
                JSLinterSuppressionUtil.$$$reportNull$$$0(2);
            }
            return SuppressIntentionAction.EMPTY_ARRAY;
        }
        SuppressIntentionAction[] suppressIntentionActionArray = new SuppressIntentionAction[]{new SuppressForLineIntentionAction(code, error.getLine(), documentModificationStamp), new SuppressForFileIntentionAction(code, documentModificationStamp), new SuppressForLineIntentionAction(null, error.getLine(), documentModificationStamp), new SuppressForFileIntentionAction(null, documentModificationStamp)};
        if (suppressIntentionActionArray == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(3);
        }
        return suppressIntentionActionArray;
    }

    @Nullable
    protected abstract String getRulesFromFileLevelComment(@NotNull PsiComment var1);

    @Nullable
    protected abstract String getRulesFromLineSuppressionComment(@NotNull PsiComment var1);

    @NotNull
    protected abstract String getToolName();

    @NotNull
    protected abstract String buildLineCommentText(@Nullable String var1, @Nullable String var2);

    @NotNull
    protected abstract String buildFileCommentText(@Nullable String var1, @Nullable String var2);

    private void insertFileSuppressionComment(@NotNull PsiElement element, @Nullable String ruleCode) {
        JSElement rootElement;
        if (element == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(4);
        }
        if ((rootElement = JSLinterSuppressionUtil.getRootJSElement(element)) == null) {
            return;
        }
        Pair<PsiComment, String> existing = this.findFileLevelComment((PsiElement)rootElement);
        if (existing != null) {
            String commentText = "/* " + this.buildFileCommentText((String)existing.second, ruleCode) + " */";
            PsiComment newComment = JSPsiElementFactory.createPsiComment(commentText, (PsiElement)rootElement);
            ((PsiComment)existing.first).replace((PsiElement)newComment);
        } else {
            String commentText = "/* " + this.buildFileCommentText(null, ruleCode) + " */";
            PsiComment newComment = JSPsiElementFactory.createPsiComment(commentText, (PsiElement)rootElement);
            newComment = (PsiComment)rootElement.addBefore((PsiElement)newComment, rootElement.getFirstChild());
            if (rootElement instanceof JSEmbeddedContent) {
                JSChangeUtil.addWs(rootElement.getNode(), newComment.getNode(), "\n");
            }
        }
    }

    @Nullable
    private Pair<PsiComment, String> findFileLevelComment(@NotNull PsiElement rootElement) {
        if (rootElement == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(5);
        }
        return JSLinterSuppressionUtil.findFileLevelComment(rootElement, this::getRulesFromFileLevelComment);
    }

    private void insertLineSuppressionComment(@NotNull Document document2, @NotNull PsiElement element, int lineNumber, @Nullable String ruleCode) {
        int previousLineEnd;
        int previousLineStart;
        Pair<PsiComment, String> existing;
        JSElement rootElement;
        if (document2 == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(6);
        }
        if (element == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(7);
        }
        if ((rootElement = JSLinterSuppressionUtil.getRootJSElement(element)) == null) {
            return;
        }
        String existingSuppressions = null;
        PsiComment existingComment = null;
        if (lineNumber > 0 && (existing = JSLinterSuppressionUtil.findLineComment(element, previousLineStart = document2.getLineStartOffset(lineNumber - 1), previousLineEnd = document2.getLineEndOffset(lineNumber - 1), this::getRulesFromLineSuppressionComment)) != null) {
            existingComment = (PsiComment)existing.first;
            existingSuppressions = (String)existing.second;
        }
        boolean isJsxBlockCommentContext = JSLinterSuppressionUtil.isJSXCommentContext(document2, element, lineNumber);
        Pair<String, String> pair = JSLinterSuppressionUtil.getCommentPrefixSuffix(existingComment, element, isJsxBlockCommentContext);
        String commentContent = this.buildLineCommentText(ruleCode, existingSuppressions);
        commentContent = (String)pair.first + commentContent + (String)pair.second;
        if (existingComment != null) {
            existingComment.replace((PsiElement)JSPsiElementFactory.createPsiComment(commentContent, element));
        } else {
            int rootElementStartOffset;
            String comment = commentContent;
            if (isJsxBlockCommentContext) {
                comment = "{" + commentContent + "}";
            }
            comment = comment + "\n";
            int insertionOffset = document2.getLineStartOffset(lineNumber);
            if (!JSCodeStyleSettings.getCommonSettings((PsiElement)element).LINE_COMMENT_AT_FIRST_COLUMN) {
                String indent = JSLinterSuppressionUtil.getIndent(document2, lineNumber);
                comment = indent + comment;
            }
            if ((rootElementStartOffset = rootElement.getNode().getStartOffset()) > insertionOffset) {
                insertionOffset = rootElementStartOffset;
                comment = "\n" + comment.trim();
            }
            document2.insertString(insertionOffset, (CharSequence)comment);
            Project project = element.getProject();
            PsiFile file2 = rootElement.getContainingFile();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, insertionOffset);
        }
    }

    private static boolean isJSXCommentContext(@NotNull Document document2, @NotNull PsiElement element, int lineNumber) {
        if (document2 == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(8);
        }
        if (element == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(9);
        }
        if (!DialectDetector.isJSX(element) || lineNumber <= 0) {
            return false;
        }
        PsiElement context = element.getContainingFile().findElementAt(document2.getLineStartOffset(lineNumber));
        return JSXCommentProvider.isTagBodyContext(context);
    }

    @NotNull
    private static Pair<String, String> getCommentPrefixSuffix(@Nullable PsiComment existing, @NotNull PsiElement context, boolean isJSTagContent) {
        boolean isLineComment;
        if (context == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(10);
        }
        boolean bl = existing != null ? JSTokenTypes.END_OF_LINE_COMMENT == existing.getNode().getElementType() : (isLineComment = !isJSTagContent);
        if (!isLineComment) {
            Pair pair = Pair.create((Object)"/* ", (Object)" */");
            if (pair == null) {
                JSLinterSuppressionUtil.$$$reportNull$$$0(11);
            }
            return pair;
        }
        CommonCodeStyleSettings settings = JSCodeStyleSettings.getCommonSettings(context);
        String prefix = settings.LINE_COMMENT_ADD_SPACE || settings.LINE_COMMENT_AT_FIRST_COLUMN ? " " : "";
        Pair pair = Pair.create((Object)("//" + prefix), (Object)"");
        if (pair == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(12);
        }
        return pair;
    }

    private static String getIndent(@NotNull Document document2, int lineNumber) {
        if (document2 == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(13);
        }
        CharSequence charsSequence = document2.getCharsSequence();
        int lineStartOffset = document2.getLineStartOffset(lineNumber);
        int indentEndIndex = CharArrayUtil.shiftForward((CharSequence)charsSequence, (int)lineStartOffset, (String)" \t");
        return charsSequence.subSequence(lineStartOffset, indentEndIndex).toString();
    }

    @Nullable
    private static Pair<PsiComment, String> findLineComment(@NotNull PsiElement rootElement, int start, int end, @NotNull Function<PsiComment, String> getRules) {
        if (rootElement == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(14);
        }
        if (getRules == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(15);
        }
        PsiElement element = rootElement.getContainingFile().getViewProvider().findElementAt(start);
        while (element != null) {
            String rulesString;
            if (element.getTextRange().intersects(start, end) && element instanceof PsiComment && StringUtil.isNotEmpty((String)(rulesString = getRules.apply((PsiComment)element)))) {
                return Pair.create((Object)((PsiComment)element), (Object)rulesString);
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiComment, String> findFileLevelComment(@NotNull PsiElement rootElement, Function<PsiComment, String> getRules) {
        if (rootElement == null) {
            JSLinterSuppressionUtil.$$$reportNull$$$0(16);
        }
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)rootElement, element -> {
            String rulesString;
            if (element != rootElement && !(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace)) {
                return false;
            }
            if (element instanceof PsiComment && StringUtil.isNotEmpty((String)(rulesString = (String)getRules.apply((PsiComment)element)))) {
                result2.set((Object)Pair.create((Object)((PsiComment)element), (Object)rulesString));
                return false;
            }
            return true;
        });
        return (Pair)result2.get();
    }

    @Nullable
    @Contract(value="null -> null")
    private static JSElement getRootJSElement(@Nullable PsiElement element) {
        return (JSElement)PsiTreeUtil.findFirstParent((PsiElement)element, e -> e instanceof JSFile || e instanceof JSEmbeddedContent && !JSPsiImplUtils.isEmbeddedExpressionContent(e));
    }

    private String getSuppressForLineDescription(@Nullable String code) {
        return JSBundle.message((String)"javascript.linter.suppress.rules.for.line.description", (Object[])new Object[]{this.getRuleDescription(code)});
    }

    private String getSuppressForFileDescription(@Nullable String ruleCode) {
        return JSBundle.message((String)"javascript.linter.suppress.rules.for.file.description", (Object[])new Object[]{this.getRuleDescription(ruleCode)});
    }

    private String getRuleDescription(@Nullable String code) {
        return StringUtil.isEmpty((String)code) ? "all " + this.getToolName() + " rules" : String.format("'%s'", code);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionsForError";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentPrefixSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHighPrioritySuppressForLineAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionsForError";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertFileSuppressionComment";
                break;
            }
            case 5: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFileLevelComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertLineSuppressionComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isJSXCommentContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefixSuffix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findLineComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyHighPriorityFix
    extends BaseIntentionAction
    implements HighPriorityAction {
        private final SuppressForLineIntentionAction myAction;

        private MyHighPriorityFix(SuppressForLineIntentionAction action) {
            this.myAction = action;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                MyHighPriorityFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.myAction.getText();
            if (string == null) {
                MyHighPriorityFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                MyHighPriorityFix.$$$reportNull$$$0(2);
            }
            return this.myAction.isAvailable(project, editor, file2);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                MyHighPriorityFix.$$$reportNull$$$0(3);
            }
            this.myAction.invoke(project, editor, file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$MyHighPriorityFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$MyHighPriorityFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SuppressForFileIntentionAction
    extends SuppressIntentionAction {
        @Nullable
        private final String myRuleCode;
        private final long myDocumentModificationStamp;

        SuppressForFileIntentionAction(String code, long documentModificationStamp) {
            this.myRuleCode = code;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public String getText() {
            String string = JSLinterSuppressionUtil.this.getSuppressForFileDescription(this.myRuleCode);
            if (string == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.linter.suppress.rules.for.file.family.name", (Object[])new Object[0]);
            if (string == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(2);
            }
            if (element == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(3);
            }
            return editor.getDocument().getModificationStamp() == this.myDocumentModificationStamp && JSLinterSuppressionUtil.getRootJSElement(element) != null;
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            if (project == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(4);
            }
            if (element == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(5);
            }
            JSLinterSuppressionUtil.this.insertFileSuppressionComment(element, this.myRuleCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForFileIntentionAction";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForFileIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SuppressForLineIntentionAction
    extends SuppressIntentionAction {
        @Nullable
        private final String myRuleCode;
        private final int myLineNumber;
        private final long myDocumentModificationStamp;

        SuppressForLineIntentionAction(String myRuleCode, int lineNumber, long documentModificationStamp) {
            this.myRuleCode = myRuleCode;
            this.myLineNumber = lineNumber;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public String getText() {
            String string = JSLinterSuppressionUtil.this.getSuppressForLineDescription(this.myRuleCode);
            if (string == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.linter.suppress.rules.for.line.family.name", (Object[])new Object[0]);
            if (string == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(2);
            }
            if (element == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(3);
            }
            return editor.getDocument().getModificationStamp() == this.myDocumentModificationStamp && JSLinterSuppressionUtil.getRootJSElement(element) != null;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            Document document2;
            if (project == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(4);
            }
            if (element == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(5);
            }
            if ((document2 = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile())) == null) {
                return;
            }
            JSLinterSuppressionUtil.this.insertLineSuppressionComment(document2, element, this.myLineNumber, this.myRuleCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForLineIntentionAction";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterSuppressionUtil$SuppressForLineIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

