/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDownloadManager {
    private ProgressIndicator myProgress;
    private final String myTestRoot;
    private final String myTargetDirPath;
    private JSDownloadException myLastException;
    private String myActualSource;
    private String myTargetFilePath;

    public JSDownloadManager(@Nullable String testRoot) {
        this(JSDownloadManager.getTargetDirPath(), testRoot);
    }

    public JSDownloadManager(String targetDirPath, @Nullable String testRoot) {
        this.myTestRoot = testRoot;
        this.myTargetDirPath = targetDirPath;
        this.myLastException = null;
    }

    public static String getTargetDirPath() {
        return JSUtils.getExtLibsDirPath();
    }

    public void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.myProgress = progressIndicator;
    }

    @Nullable
    public String download(@NotNull String location, @NotNull String extension) {
        if (location == null) {
            JSDownloadManager.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            JSDownloadManager.$$$reportNull$$$0(1);
        }
        this.myActualSource = JSLibraryUtil.getDevVersionLocation(location);
        String targetFileName = this.getResultFileName(extension, true);
        this.myLastException = null;
        try {
            return this.fetch(this.myActualSource, targetFileName);
        }
        catch (JSDownloadException e) {
            if (e.getCause() instanceof IOException) {
                try {
                    this.myActualSource = location;
                    targetFileName = this.getResultFileName(extension, false);
                    return this.fetch(this.myActualSource, targetFileName);
                }
                catch (JSDownloadException e1) {
                    this.myLastException = e1;
                }
            } else {
                this.myLastException = e;
            }
            return null;
        }
    }

    @NotNull
    protected String getResultFileName(@NotNull String extension, boolean name) {
        if (extension == null) {
            JSDownloadManager.$$$reportNull$$$0(2);
        }
        String string = JSLibraryUtil.makeUniqueFileName(this.myActualSource, name) + extension;
        if (string == null) {
            JSDownloadManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getActualSource() {
        return this.myActualSource;
    }

    @Nullable
    public JSDownloadException getLastException() {
        return this.myLastException;
    }

    @NotNull
    private String fetch(String location, String targetFileName) throws JSDownloadException {
        String string;
        File targetDir = new File(this.myTargetDirPath);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new JSDownloadException("Can not create " + this.myTargetDirPath + " directory.");
        }
        if (location.startsWith("//")) {
            location = "http:" + location;
        }
        String targetPath = this.myTargetDirPath + File.separatorChar + targetFileName;
        File targetFile = new File(targetPath);
        try {
            if (this.myTestRoot == null) {
                DownloadUtil.downloadAtomically((ProgressIndicator)this.myProgress, (String)location, (File)targetFile);
            } else {
                File f = new File(location.replaceFirst("^(http|https)://", FileUtil.toSystemIndependentName((String)this.myTestRoot) + "/"));
                FileUtil.copy((File)f, (File)targetFile);
            }
            this.myTargetFilePath = targetPath;
            string = targetPath;
        }
        catch (IOException e) {
            if (targetFile.exists()) {
                FileUtil.delete((File)targetFile);
            }
            throw new JSDownloadException(e);
        }
        if (string == null) {
            JSDownloadManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getTargetFilePath() {
        return this.myTargetFilePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/download/JSDownloadManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/download/JSDownloadManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResultFileName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSDownloadException
    extends Exception {
        public JSDownloadException(String message) {
            super(message);
        }

        public JSDownloadException(Throwable e) {
            super(e);
        }

        @NotNull
        public String getReason() {
            Throwable t = this.getCause();
            if (t == null) {
                String string = StringUtil.notNullize((String)this.getMessage());
                if (string == null) {
                    JSDownloadException.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (t instanceof FileNotFoundException) {
                if ("File not found" == null) {
                    JSDownloadException.$$$reportNull$$$0(1);
                }
                return "File not found";
            }
            if (t instanceof UnknownHostException) {
                if ("Unknown host" == null) {
                    JSDownloadException.$$$reportNull$$$0(2);
                }
                return "Unknown host";
            }
            String string = StringUtil.notNullize((String)t.getMessage());
            if (string == null) {
                JSDownloadException.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/download/JSDownloadManager$JSDownloadException", "getReason"));
        }
    }
}

