/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibrariesData;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryManager
extends ScriptingLibraryManager {
    private volatile JSPredefinedLibrariesData myPredefinedLibrariesDataCache;
    private final Object myPredefinedLibrariesDataCacheUpdateLock = new Object();

    public JSLibraryManager(Project project) {
        super(project, JSLibraryKind.INSTANCE);
    }

    protected void initPredefinedLibraries(@NotNull ScriptingLibraryTable libraryTable) {
        if (libraryTable == null) {
            JSLibraryManager.$$$reportNull$$$0(0);
        }
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        for (ScriptingLibraryModel library : data.getLibraryModels()) {
            libraryTable.addPredefinedLibrary(library);
        }
    }

    public void commitChanges(boolean fireRootsChangedEvent) {
        this.invalidatePredefinedLibrariesCache();
        super.commitChanges(fireRootsChangedEvent);
    }

    private void invalidatePredefinedLibrariesCache() {
        this.myPredefinedLibrariesDataCache = null;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibraryFiles() {
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        Set<VirtualFile> set = data.getLibraryFiles();
        if (set == null) {
            JSLibraryManager.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> rebuildPredefinedLibraryFilesAndGet() {
        this.invalidatePredefinedLibrariesCache();
        Set<VirtualFile> set = this.getPredefinedLibraryFiles();
        if (set == null) {
            JSLibraryManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibraryFilesForResolve() {
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        Set<VirtualFile> files = data.getLibraryFilesForResolve();
        if (VfsUtilCore.hasInvalidFiles(files)) {
            this.invalidatePredefinedLibrariesCache();
            files = this.getPredefinedLibrariesData().getLibraryFilesForResolve();
        }
        Set<VirtualFile> set = files;
        if (set == null) {
            JSLibraryManager.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Nullable
    public VirtualFile findPredefinedLibraryFileByName(@NotNull String fileName) {
        if (fileName == null) {
            JSLibraryManager.$$$reportNull$$$0(4);
        }
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        return data.findPredefinedFileByName(fileName);
    }

    public boolean isPredefinedLibraryFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        return data.isPredefinedFile(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private JSPredefinedLibrariesData getPredefinedLibrariesData() {
        JSPredefinedLibrariesData data = this.myPredefinedLibrariesDataCache;
        if (data == null) {
            Object object = this.myPredefinedLibrariesDataCacheUpdateLock;
            synchronized (object) {
                data = this.myPredefinedLibrariesDataCache;
                if (data == null) {
                    this.myPredefinedLibrariesDataCache = data = JSPredefinedLibrariesData.create(this.getProject());
                }
            }
        }
        JSPredefinedLibrariesData jSPredefinedLibrariesData = data;
        if (jSPredefinedLibrariesData == null) {
            JSLibraryManager.$$$reportNull$$$0(5);
        }
        return jSPredefinedLibrariesData;
    }

    @NotNull
    public ScriptingLibraryMappings getLibraryMappings() {
        JSLibraryMappings jSLibraryMappings = JSLibraryMappings.getInstance(this.getProject());
        if (jSLibraryMappings == null) {
            JSLibraryManager.$$$reportNull$$$0(6);
        }
        return jSLibraryMappings;
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve() {
        Set<VirtualFile> set = this.getPredefinedLibrariesData().getRequiredLibraryFilesForResolve();
        if (set == null) {
            JSLibraryManager.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFiles() {
        Set<VirtualFile> set = this.getPredefinedLibrariesData().getRequiredLibraryFiles();
        if (set == null) {
            JSLibraryManager.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public static JSLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            JSLibraryManager.$$$reportNull$$$0(9);
        }
        JSLibraryManager jSLibraryManager = (JSLibraryManager)((Object)ServiceManager.getService((Project)project, JSLibraryManager.class));
        if (jSLibraryManager == null) {
            JSLibraryManager.$$$reportNull$$$0(10);
        }
        return jSLibraryManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildPredefinedLibraryFilesAndGet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryFilesForResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibrariesData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initPredefinedLibraries";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPredefinedLibraryFileByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

