/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSSeparateDigitsIntention
extends JavaScriptIntention {
    private String myText = JSBundle.message((String)"js.separate.digits", (Object[])new Object[0]);

    private static int getComplicatedPartIndex(String text) {
        return StringUtil.indexOfAny((String)text, (String)"eE.");
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean available;
        if (project == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        boolean bl = available = parent instanceof JSLiteralExpression && ((JSLiteralExpression)parent).isNumericLiteral() && (DialectDetector.isES6(element) || DialectDetector.isTypeScript(element));
        if (!available) {
            return false;
        }
        String text = parent.getText();
        if (text.indexOf(95) != -1) {
            return false;
        }
        LiteralKind kind = LiteralKind.fromLiteralText(text);
        if (kind.isUnsupported()) {
            return false;
        }
        if (kind == LiteralKind.ComplicatedDec) {
            int index = JSSeparateDigitsIntention.getComplicatedPartIndex(text);
            assert (index != -1);
            text = text.substring(0, index);
        }
        if (text.length() - kind.getStartOffset() <= kind.getSeparationSize()) {
            return false;
        }
        this.myText = JSBundle.message((String)kind.getBundleId(), (Object[])new Object[0]);
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(4);
        }
        PsiElement parent = element.getParent();
        assert (parent instanceof JSLiteralExpression);
        String text = parent.getText();
        LiteralKind literalKind = LiteralKind.fromLiteralText(text);
        JSLiteralExpression result2 = JSSeparateDigitsIntention.transform(text, literalKind, parent);
        ((JSLiteralExpression)parent).replace((JSExpression)result2);
    }

    private static JSLiteralExpression transform(String text, LiteralKind kind, PsiElement context) {
        String postfix = "";
        if (kind == LiteralKind.ComplicatedDec) {
            int index = JSSeparateDigitsIntention.getComplicatedPartIndex(text);
            assert (index != -1);
            postfix = text.substring(index);
            text = text.substring(0, index);
        }
        int offset = text.startsWith("-") ? 1 : 0;
        String prefix = text.substring(0, offset += kind.getStartOffset());
        StringBuilder newString = new StringBuilder();
        int j = 0;
        for (int i = text.length() - 1; i > offset; --i) {
            newString.insert(0, text.charAt(i));
            if (++j % kind.getSeparationSize() != 0) continue;
            newString.insert(0, '_');
        }
        newString.insert(0, text.charAt(offset));
        newString.insert(0, prefix);
        newString.append(postfix);
        return JSPsiElementFactory.createJSExpression(newString.toString(), context, JSLiteralExpression.class);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.separate.digits", (Object[])new Object[0]);
        if (string == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSeparateDigitsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSeparateDigitsIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum LiteralKind {
        Boolean,
        LargeBoolean,
        Hex,
        LargeHex,
        Dec,
        Oct,
        ObsoleteOct,
        ComplicatedDec;


        public static LiteralKind fromLiteralText(String text) {
            if (text.startsWith("0b")) {
                return text.length() - 2 > 16 ? LargeBoolean : Boolean;
            }
            if (text.startsWith("0x")) {
                return text.length() - 2 > 8 ? LargeHex : Hex;
            }
            if (text.startsWith("0o")) {
                return Oct;
            }
            if (text.length() >= 2 && text.charAt(0) == '\u0000' && StringUtil.isOctalDigit((char)text.charAt(1))) {
                return ObsoleteOct;
            }
            return JSSeparateDigitsIntention.getComplicatedPartIndex(text) != -1 ? ComplicatedDec : Dec;
        }

        public String getBundleId() {
            switch (this) {
                case Boolean: {
                    return "js.separate.nibbles";
                }
                case LargeBoolean: {
                    return "js.separate.bytes";
                }
                case Hex: {
                    return "js.separate.bytes";
                }
                case LargeHex: {
                    return "js.separate.words";
                }
                case Dec: {
                    return "js.separate.thousands";
                }
                case ComplicatedDec: {
                    return "js.separate.thousands.in.integer.part";
                }
            }
            throw new NotImplementedError(this.toString());
        }

        public int getStartOffset() {
            switch (this) {
                case Boolean: 
                case LargeBoolean: 
                case Hex: 
                case LargeHex: {
                    return 2;
                }
                case Dec: 
                case ComplicatedDec: {
                    return 0;
                }
            }
            throw new NotImplementedError(this.toString());
        }

        public int getSeparationSize() {
            switch (this) {
                case Boolean: {
                    return 4;
                }
                case LargeBoolean: {
                    return 8;
                }
                case Hex: {
                    return 2;
                }
                case LargeHex: {
                    return 4;
                }
                case Dec: 
                case ComplicatedDec: {
                    return 3;
                }
            }
            throw new NotImplementedError(this.toString());
        }

        public boolean isUnsupported() {
            return this == Oct || this == ObsoleteOct;
        }
    }
}

