/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIterateIntention
extends JavaScriptIntention {
    private String myText = JSBundle.message((String)"js.iterate", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSIterateIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSIterateIntention.$$$reportNull$$$0(1);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        Pair<JSExpression, Boolean> iterableExpression = JSIterateIntention.getIterableExpression(editor, element.getContainingFile());
        assert (iterableExpression != null);
        TextRange textRange = ((JSExpression)iterableExpression.first).getTextRange();
        selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        TemplateImpl template = JSIterateIntention.getTemplate((Boolean)iterableExpression.second);
        assert (template != null);
        new InvokeTemplateAction(template, editor, project, new HashSet()).perform();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.iterate", (Object[])new Object[0]);
        if (string == null) {
            JSIterateIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static TemplateImpl getTemplate(boolean asyncTemplate) {
        return TemplateSettings.getInstance().getTemplate(asyncTemplate ? "itera" : "iter", "JavaScript");
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSIterateIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSIterateIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSIterateIntention.$$$reportNull$$$0(5);
        }
        if (!DialectDetector.isES6(element) && !DialectDetector.isTypeScript(element)) {
            return false;
        }
        Pair<JSExpression, Boolean> expression = JSIterateIntention.getIterableExpression(editor, element.getContainingFile());
        if (expression == null || expression.first == null) {
            return false;
        }
        TemplateImpl template = JSIterateIntention.getTemplate((Boolean)expression.second);
        if (template == null || template.isDeactivated()) {
            return false;
        }
        this.myText = (Boolean)expression.second != false ? JSBundle.message((String)"js.iterate.async", (Object[])new Object[0]) : JSBundle.message((String)"js.iterate", (Object[])new Object[0]);
        return true;
    }

    @Nullable
    private static JSExpression getCommonExpression(PsiElement elementAtStart, PsiElement elementAtEnd) {
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        if (parent instanceof JSExpression) {
            return (JSExpression)parent;
        }
        if (parent != null && parent.getParent() instanceof JSExpression) {
            return (JSExpression)parent.getParent();
        }
        return null;
    }

    @Nullable
    private static Pair<JSExpression, Boolean> getIterableExpression(Editor editor, PsiFile file2) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement parent;
            PsiElement elementAtStart = file2.findElementAt(selectionModel.getSelectionStart());
            PsiElement elementAtEnd = file2.findElementAt(selectionModel.getSelectionEnd() - 1);
            if ((elementAtStart == null || elementAtStart instanceof PsiWhiteSpace || elementAtStart instanceof PsiComment) && (elementAtStart = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)elementAtStart)) == null) {
                return null;
            }
            if ((elementAtEnd == null || elementAtEnd instanceof PsiWhiteSpace || elementAtEnd instanceof PsiComment) && (elementAtEnd = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementAtEnd)) == null) {
                return null;
            }
            JSExpression commonExpression = JSIterateIntention.getCommonExpression(elementAtStart, elementAtEnd);
            PsiElement psiElement = parent = commonExpression == null ? null : commonExpression.getParent();
            if (!(parent instanceof JSExpressionStatement)) {
                return null;
            }
            return JSIterateIntention.getIterableExpression(commonExpression);
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        while (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)element).getExpression();
            PsiElement psiElement = element = expression == null ? null : expression.getLastChild();
        }
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, JSExpression.class, (boolean)true)) != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSCallExpression) continue;
            if (!(parent instanceof JSExpressionStatement)) {
                return null;
            }
            Pair<JSExpression, Boolean> iterableExpression = JSIterateIntention.getIterableExpression((JSExpression)element);
            if (iterableExpression == null) continue;
            return iterableExpression;
        }
        return null;
    }

    @Nullable
    private static Pair<JSExpression, Boolean> getIterableExpression(@Nullable JSExpression parent) {
        String typeName;
        if (parent == null) {
            return null;
        }
        JSType type = JSResolveUtil.getExpressionJSType(parent);
        if (type instanceof JSArrayType || type instanceof JSStringType) {
            return Pair.create((Object)parent, (Object)false);
        }
        if (type == null || !JSTypeUtils.isIterableCollectionType(type)) {
            return null;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        if (type instanceof JSNamedType && ("AsyncIterableIterator".equals(typeName = ((JSNamedType)type).getQualifiedName().getQualifiedName()) || "AsyncGenerator".equals(typeName) || "AsyncIterable".equals(typeName))) {
            return Pair.create((Object)parent, (Object)true);
        }
        return Pair.create((Object)parent, (Object)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSIterateIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSIterateIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

