/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JSInitializeFieldsIntentionBase;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSInitializeFieldsIntention
extends JSInitializeFieldsIntentionBase {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Initialize new fields from parameters" == null) {
            JSInitializeFieldsIntention.$$$reportNull$$$0(0);
        }
        return "Initialize new fields from parameters";
    }

    @Override
    protected String getDialogTitle() {
        return "Select Parameters to Initialize Fields";
    }

    @Override
    protected JSInitializeFieldsIntentionBase.ImplicitFields includeImplicitFields(PsiElement context) {
        if (DialectDetector.isTypeScript(context)) {
            return JSInitializeFieldsIntentionBase.ImplicitFields.EXCLUDE;
        }
        return JSInitializeFieldsIntentionBase.ImplicitFields.INCLUDE;
    }

    @Override
    protected void doInvoke(Project project, JSFunction function, List<JSNamedElement> elements) {
        JSExpression expression;
        JSBlockStatement block = function.getBlock();
        if (block == null) {
            return;
        }
        PsiElement blockAnchor = JSInitializeFieldsIntention.getLBrace((PsiElement)block);
        JSSourceElement firstElement = (JSSourceElement)ArrayUtil.getFirstElement((Object[])block.getStatementListItems());
        if (firstElement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)firstElement).getExpression()) instanceof JSCallExpression && ((JSCallExpression)expression).getMethodExpression() instanceof JSSuperExpression) {
            blockAnchor = firstElement;
        }
        PsiElement anchor = JSInitializeFieldsIntention.computeClassAnchor(function);
        JSClass clazz = JSResolveUtil.getClassOfContext((PsiElement)function);
        HashSet<String> existingMembers = new HashSet<String>();
        for (Object member : clazz.getMembers()) {
            if (!(member instanceof JSNamedElement)) continue;
            existingMembers.add(((JSNamedElement)member).getName());
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)function);
        for (JSNamedElement element : elements) {
            String name = element.getName();
            if (!existingMembers.contains(name)) {
                String text = element.getText() + semicolon;
                anchor = this.addClassMember(project, anchor, dialect, text);
            }
            JSStatement statement = JSPsiElementFactory.createJSStatement("this." + name + " = " + name + semicolon, (PsiElement)function);
            blockAnchor = blockAnchor.getParent().addAfter((PsiElement)statement, blockAnchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSInitializeFieldsIntention", "getFamilyName"));
    }
}

