/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.unusedsymbols;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolsPass;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedGlobalSymbolCache {
    private static final Key<SoftlyCachedValue<Optional<PsiReference>>> CACHED_VALUE_KEY = Key.create((String)"js.unused.global.symbol.inspection.reference.key");
    private static final List<ImplicitUsageProvider> myExtensions = ImplicitUsageProvider.EP_NAME.getExtensionList();

    private JSUnusedGlobalSymbolCache() {
    }

    public static boolean calcUnused(@NotNull PsiElement element) {
        ThreeState usedFromCache;
        if (element == null) {
            JSUnusedGlobalSymbolCache.$$$reportNull$$$0(0);
        }
        if ((usedFromCache = JSUnusedGlobalSymbolCache.isUsedImplicitlyOrFromCache(element)) != ThreeState.UNSURE) {
            return !usedFromCache.toBoolean();
        }
        return JSUnusedGlobalSymbolCache.calculateUnusedWithoutCaching(element);
    }

    private static boolean calculateUnusedWithoutCaching(@NotNull PsiElement element) {
        PsiReference foundReference;
        GlobalSearchScope scope;
        if (element == null) {
            JSUnusedGlobalSymbolCache.$$$reportNull$$$0(1);
        }
        if ((scope = JSUnusedGlobalSymbolsPass.getScopeForSearch(element)) == null) {
            scope = element.getUseScope();
        }
        return (foundReference = JSUnusedGlobalSymbolCache.findAnyReference(element, (SearchScope)scope)) == null;
    }

    public static void saveFoundReference(@Nullable PsiReference foundReference, @NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            JSUnusedGlobalSymbolCache.$$$reportNull$$$0(2);
        }
        ReferenceModificationTracker tracker = new ReferenceModificationTracker(foundReference, elementToSearch.getProject());
        elementToSearch.putUserData(CACHED_VALUE_KEY, new SoftlyCachedValue<Optional<PsiReference>>(Optional.ofNullable(foundReference), tracker));
    }

    @Nullable
    public static PsiReference findAnyReference(@NotNull PsiElement element, SearchScope scope) {
        if (element == null) {
            JSUnusedGlobalSymbolCache.$$$reportNull$$$0(3);
        }
        Query psiReferenceQuery = ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true);
        MySearchProcessor processor = new MySearchProcessor(element);
        psiReferenceQuery.forEach((Processor)processor);
        return processor.getFoundReference();
    }

    @NotNull
    public static ThreeState isUsedImplicitlyOrFromCache(@NotNull PsiElement element) {
        Optional result2;
        if (element == null) {
            JSUnusedGlobalSymbolCache.$$$reportNull$$$0(4);
        }
        for (ImplicitUsageProvider provider2 : myExtensions) {
            if (!provider2.isImplicitUsage(element)) continue;
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSUnusedGlobalSymbolCache.$$$reportNull$$$0(5);
            }
            return threeState;
        }
        SoftlyCachedValue cachedValue = (SoftlyCachedValue)element.getUserData(CACHED_VALUE_KEY);
        if (cachedValue != null && (result2 = (Optional)cachedValue.getUpToDateOrNull()) != null) {
            if (!result2.isPresent()) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    JSUnusedGlobalSymbolCache.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            PsiReference ref = (PsiReference)result2.get();
            if (ref.isReferenceTo(element)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    JSUnusedGlobalSymbolCache.$$$reportNull$$$0(7);
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSUnusedGlobalSymbolCache.$$$reportNull$$$0(8);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolCache";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isUsedImplicitlyOrFromCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcUnused";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateUnusedWithoutCaching";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveFoundReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAnyReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUsedImplicitlyOrFromCache";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReferenceModificationTracker
    implements ModificationTracker {
        @Nullable
        private final PsiReference myReference;
        @NotNull
        private final Project myProject;

        private ReferenceModificationTracker(@Nullable PsiReference reference, @NotNull Project project) {
            if (project == null) {
                ReferenceModificationTracker.$$$reportNull$$$0(0);
            }
            this.myReference = reference;
            this.myProject = project;
        }

        public long getModificationCount() {
            if (this.myReference == null) {
                return PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
            }
            PsiElement element = this.myReference.getElement();
            if (!element.isValid()) {
                return -1L;
            }
            PsiFile file2 = element.getContainingFile();
            if (file2 == null || !file2.isValid()) {
                return -1L;
            }
            return file2.getModificationStamp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolCache$ReferenceModificationTracker", "<init>"));
        }
    }

    private static class MySearchProcessor
    implements Processor<PsiReference> {
        private final PsiElement myElementToSearch;
        private final AtomicReference<PsiReference> myRef = new AtomicReference();

        MySearchProcessor(PsiElement elementToSearch) {
            this.myElementToSearch = elementToSearch;
        }

        public boolean process(PsiReference psiReference) {
            PsiElement parent;
            PsiElement psiElement = psiReference.getElement();
            if (JSResolveUtil.isSelfReference(psiElement) || this.isNegligibleReference(psiElement)) {
                return true;
            }
            if (this.myElementToSearch instanceof JSDefinitionExpression && (parent = psiElement.getParent()) instanceof JSDefinitionExpression) {
                return true;
            }
            this.myRef.set(psiReference);
            return false;
        }

        public PsiReference getFoundReference() {
            return this.myRef.get();
        }

        private boolean isNegligibleReference(@NotNull PsiElement referenceElement) {
            ES6ExportDeclaration declaration;
            if (referenceElement == null) {
                MySearchProcessor.$$$reportNull$$$0(0);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myElementToSearch, (PsiElement)referenceElement, (boolean)false)) {
                if (this.myElementToSearch instanceof JSClass) {
                    return true;
                }
                JSFunction callback = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, JSFunction.class);
                return callback == null || !PsiTreeUtil.isAncestor((PsiElement)this.myElementToSearch, (PsiElement)callback, (boolean)true);
            }
            return referenceElement instanceof ES6ExportSpecifier && (declaration = ((ES6ExportSpecifier)referenceElement).getDeclaration()) != null && declaration.getFromClause() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolCache$MySearchProcessor", "isNegligibleReference"));
        }
    }
}

