/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUndeclaredVariableInspection
extends JSInspection {
    public boolean myCheckGlobalDefinitions;

    @Nullable
    private static JSVarStatement findPreviousVarStatement(PsiElement anchor) {
        PsiElement prevSibling = anchor;
        while (prevSibling != null && !(prevSibling instanceof PsiFile)) {
            if ((prevSibling = prevSibling.getPrevSibling()) instanceof JSVarStatement) {
                return (JSVarStatement)prevSibling;
            }
            if (prevSibling != null) continue;
            prevSibling = anchor = anchor.getParent();
        }
        return null;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSUndeclaredVariableInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.undeclared.variable.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUndeclaredVariableInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSSourceElement element;
                PsiElement parentElement = node.getParent();
                if (!(parentElement instanceof JSCallExpression) && node.shouldCheckReferences() && node.getQualifier() == null && parentElement instanceof JSDefinitionExpression && ((element = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSWithStatement.class, JSFunction.class, JSLoopStatement.class})) != null || JSUndeclaredVariableInspection.this.myCheckGlobalDefinitions) && !(element instanceof JSWithStatement)) {
                    PsiElement nameIdentifier;
                    ResolveResult[] resolveResults;
                    boolean varReferenceWithoutVar = true;
                    for (ResolveResult r : resolveResults = node.multiResolve(false)) {
                        PsiElement resolveResult = r.getElement();
                        if (!(resolveResult instanceof JSVariable) && !(resolveResult instanceof JSFunction) && (!(resolveResult instanceof JSImplicitElement) || ((JSImplicitElement)resolveResult).getType() != JSImplicitElement.Type.Tag) && (!(resolveResult instanceof JSImplicitFunctionImpl) || !((JSImplicitFunctionImpl)resolveResult).isGetProperty() && !((JSImplicitFunctionImpl)resolveResult).isSetProperty())) continue;
                        varReferenceWithoutVar = false;
                        break;
                    }
                    if (varReferenceWithoutVar && resolveResults.length > 0 && (nameIdentifier = node.getReferenceNameElement()) != null) {
                        LinkedList<Object> fixes = new LinkedList<Object>();
                        if (JSUndeclaredVariableInspection.this.myOnTheFly) {
                            PsiFile file2 = node.getContainingFile();
                            fixes.add(new DeclareJSVariableIntentionAction(node.getReferencedName()));
                            PsiElement anchor = JSUtils.findStatementAnchor((PsiElement)node, file2);
                            JSVarStatement varStatement = JSUndeclaredVariableInspection.findPreviousVarStatement(anchor);
                            if (varStatement != null) {
                                fixes.add(new DeclareJSVariableInPreviousVarStatementQuickFix(node.getReferencedName()));
                            }
                        }
                        holder.registerProblem(nameIdentifier, JSBundle.message((String)"javascript.undeclared.variable.name.message", (Object[])new Object[]{node.getReferencedName()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, !fixes.isEmpty() ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : null);
                    }
                }
                super.visitJSReferenceExpression(node);
            }
        };
        if (jSElementVisitor == null) {
            JSUndeclaredVariableInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"javascript.check.global.definitions", (Object[])new Object[0]), (InspectionProfileEntry)this, "myCheckGlobalDefinitions");
    }

    private static boolean isImplicitlyDeclared(JSReferenceExpression node, PsiElement parentElement) {
        if (parentElement instanceof JSForInStatement) {
            JSExpression varExpression = ((JSForInStatement)parentElement).getVariableExpression();
            return PsiTreeUtil.findCommonParent((PsiElement)varExpression, (PsiElement)node) == varExpression;
        }
        if (parentElement instanceof JSForStatement) {
            JSExpression varExpression = ((JSForStatement)parentElement).getInitialization();
            return PsiTreeUtil.findCommonParent((PsiElement)varExpression, (PsiElement)node) == varExpression;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DeclareJSVariableInPreviousVarStatementQuickFix
    implements LocalQuickFix {
        private final String myVarName;

        private DeclareJSVariableInPreviousVarStatementQuickFix(String varName) {
            this.myVarName = varName;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"javascript.declare.variable.in.previous.var.statement.intention.name", (Object[])new Object[]{this.myVarName});
            if (string == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.declare.variable.in.previous.var.statement.intention.family", (Object[])new Object[0]);
            if (string == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiFile file2;
            JSReferenceExpression referenceExpression;
            PsiElement anchor;
            JSVarStatement varStatement;
            if (project == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(3);
            }
            if ((varStatement = JSUndeclaredVariableInspection.findPreviousVarStatement(anchor = JSUtils.findStatementAnchor((PsiElement)(referenceExpression = (JSReferenceExpression)descriptor2.getPsiElement().getParent()), file2 = referenceExpression.getContainingFile()))) == null) {
                return;
            }
            Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
            if (document2 == null) {
                return;
            }
            boolean hasVars = !ArrayUtil.isEmpty((Object[])varStatement.getDeclarations());
            PsiElement lastChild = varStatement.getLastChild();
            int endOffset = lastChild != null && lastChild.getNode().getElementType() == JSTokenTypes.SEMICOLON ? lastChild.getPrevSibling().getTextRange().getEndOffset() : varStatement.getTextRange().getEndOffset();
            String declaration = (hasVars ? ", " : " ") + referenceExpression.getReferenceName();
            document2.insertString(endOffset, (CharSequence)declaration);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
            CodeStyleManager.getInstance((Project)project).reformatText(file2, varStatement.getTextRange().getStartOffset(), varStatement.getTextRange().getStartOffset() + declaration.length());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeclareJSVariableIntentionAction
    implements LocalQuickFix {
        private final String myVarName;

        DeclareJSVariableIntentionAction(String varName) {
            this.myVarName = varName;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"javascript.declare.variable.intention.name", (Object[])new Object[]{this.myVarName});
            if (string == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.declare.variable.intention.family.name", (Object[])new Object[0]);
            if (string == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            JSExpression initialization;
            JSStatement statement;
            PsiFile file2;
            PsiElement anchor;
            JSReferenceExpression referenceExpression;
            boolean implicitlyDeclared;
            if (project == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(3);
            }
            if ((implicitlyDeclared = JSUndeclaredVariableInspection.isImplicitlyDeclared(referenceExpression = (JSReferenceExpression)descriptor2.getPsiElement().getParent(), anchor = JSUtils.findStatementAnchor((PsiElement)referenceExpression, file2 = referenceExpression.getContainingFile()))) && (statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)(anchor = referenceExpression), (Class[])new Class[]{JSForStatement.class, JSStatement.class})) instanceof JSForStatement && (initialization = ((JSForStatement)statement).getInitialization()) instanceof JSBinaryExpression && ((JSBinaryExpression)initialization).getOperationSign() == JSTokenTypes.COMMA) {
                anchor = ((JSAssignmentExpression)((JSBinaryExpression)initialization).getLOperand()).getLOperand();
            }
            if (anchor != null) {
                JSExpression expr;
                boolean anchorChanged = false;
                if (!implicitlyDeclared) {
                    PsiElement parent = anchor.getParent();
                    while (parent instanceof JSBlockStatement || parent instanceof JSIfStatement || parent instanceof JSLoopStatement) {
                        PsiElement newAnchor = parent.getParent();
                        if (newAnchor instanceof JSIfStatement || newAnchor instanceof JSWithStatement || newAnchor instanceof JSLoopStatement || newAnchor instanceof JSTryStatement || newAnchor instanceof JSSwitchStatement) {
                            anchor = newAnchor;
                            parent = anchor.getParent();
                            anchorChanged = true;
                            continue;
                        }
                        if (!(newAnchor instanceof JSFile)) break;
                        anchor = parent;
                        anchorChanged = true;
                        break;
                    }
                }
                TextRange textRange = anchor.getTextRange();
                int startOffset = textRange.getStartOffset();
                StringBuilder builder = new StringBuilder();
                builder.append(JSChangeUtil.getVariablePrefix((PsiElement)file2));
                builder.append(" ");
                if (anchor instanceof JSExpressionStatement && (expr = ((JSExpressionStatement)anchor).getExpression()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)expr).getOperationSign() != JSTokenTypes.EQ) {
                    anchorChanged = true;
                }
                if (!(!anchorChanged && anchor instanceof JSExpressionStatement || implicitlyDeclared)) {
                    builder.append(referenceExpression.getReferencedName()).append(";\n");
                }
                Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                document2.replaceString(startOffset, startOffset, (CharSequence)builder);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
                CodeStyleManager.getInstance((Project)project).reformatText(file2, startOffset, textRange.getEndOffset() + builder.length());
                file2.navigate(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

