/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.Processor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNonASCIINamesInspection
extends JSInspection {
    private static final Key<Map<String, String>> WARNING_TEXTS = Key.create((String)"Javascript.Non.ASCII.Identifiers.Cache");
    public boolean myAllowOnlyAscii;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"non.ascii.identifiers.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSNonASCIINamesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"non.ascii.identifiers.only.ascii", (Object[])new Object[0]), (InspectionProfileEntry)this, "myAllowOnlyAscii");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSNonASCIINamesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSNonASCIINamesInspection.$$$reportNull$$$0(2);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSElement(JSElement node) {
                PsiElement identifier;
                if (node instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)node).getNameIdentifier()) != null && !(identifier instanceof JSReferenceExpression) && !(identifier.getParent() instanceof JSReferenceExpression)) {
                    this.checkIdentifier(identifier);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                this.checkIdentifier(node.getReferenceNameElement());
            }

            public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
                JSExpression expression = node.getIndexExpression();
                if (expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isQuotedLiteral()) {
                    this.checkIdentifier((PsiElement)expression);
                }
            }

            private void checkIdentifier(PsiElement identifier) {
                String warning;
                if (identifier == null || identifier instanceof JSReferenceExpression) {
                    return;
                }
                String text = identifier.getText();
                HashMap<String, String> map = (HashMap<String, String>)session.getUserData(WARNING_TEXTS);
                String string = warning = map == null ? null : (String)map.get(text);
                String problemDescription = warning != null ? (warning.isEmpty() ? null : warning) : new Checker(JSNonASCIINamesInspection.this.myAllowOnlyAscii, text).process();
                if (!StringUtil.isEmptyOrSpaces((String)text) && problemDescription != null) {
                    if (map == null) {
                        map = new HashMap<String, String>();
                        session.putUserData(WARNING_TEXTS, map);
                    }
                    map.put(text, problemDescription);
                    holder.registerProblem(identifier, JSNonASCIINamesInspection.this.myAllowOnlyAscii ? JSBundle.message((String)"non.ascii.identifiers.non.ascii.found", (Object[])new Object[]{problemDescription}) : JSBundle.message((String)"non.ascii.identifiers.mixed.set", (Object[])new Object[]{problemDescription}), new LocalQuickFix[0]);
                }
            }
        };
        if (jSElementVisitor == null) {
            JSNonASCIINamesInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSNonASCIINamesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSNonASCIINamesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Checker {
        private final boolean myOnlyASCII;
        private final String myText;
        private boolean containNonAscii = false;
        private boolean containAscii = false;
        private StringBuilder myResult;

        Checker(boolean onlyASCII, String text) {
            this.myOnlyASCII = onlyASCII;
            this.myText = text;
        }

        private void iterateText(@NotNull Processor<Integer> processor) {
            int point;
            if (processor == null) {
                Checker.$$$reportNull$$$0(0);
            }
            for (int i = 0; i < this.myText.length() && processor.process((Object)(point = this.myText.codePointAt(i))); ++i) {
            }
        }

        public String process() {
            this.iterateText((Processor<Integer>)((Processor)point -> {
                if (point < 128) {
                    if (Character.isLetter(point)) {
                        this.containAscii = true;
                    }
                } else {
                    this.containNonAscii = true;
                }
                return !this.errorFound();
            }));
            if (this.errorFound()) {
                this.myResult = new StringBuilder("<span>");
                this.iterateText((Processor<Integer>)((Processor)point -> {
                    if (point >= 128) {
                        this.myResult.append("<span style=\"color: red\">").append(Character.toChars(point)).append("</span>");
                    } else {
                        this.myResult.append(Character.toChars(point));
                    }
                    return true;
                }));
            }
            return this.myResult == null ? null : this.myResult.toString();
        }

        private boolean errorFound() {
            return this.myOnlyASCII && this.containNonAscii || this.containAscii && this.containNonAscii;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/inspections/JSNonASCIINamesInspection$Checker", "iterateText"));
        }
    }
}

