/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSFunctionExpressionToArrowFunctionQuickFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSFunctionExpressionToArrowFunctionInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSFunctionExpressionToArrowFunctionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSFunctionExpressionToArrowFunctionInspection.$$$reportNull$$$0(1);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSFunctionExpression(node);
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                JSParameterList parameterListElement = node.getParameterList();
                if (node.isGenerator() || node.isReferencesArguments() || node.isArrowFunction() || parameterListElement == null) {
                    return;
                }
                JSQualifiedNamedElement parent = node.getElementAssignedTo();
                if (JSUtils.isMember((PsiElement)parent)) {
                    return;
                }
                String functionExpressionName = node.getName();
                if (JSFunctionExpressionToArrowFunctionInspection.hasThisReferences((JSFunction)node)) {
                    return;
                }
                if (parent == null && StringUtil.isNotEmpty((String)functionExpressionName) && !PsiTreeUtil.processElements((PsiElement)node, element -> !JSFunctionExpressionToArrowFunctionInspection.isRecursiveCall(functionExpressionName, element))) {
                    return;
                }
                int endOffset = parameterListElement.getTextRangeInParent().getEndOffset();
                holder.registerProblem((PsiElement)node, new TextRange(0, endOffset), JSBundle.message((String)"js.inspection.function.expression.is.used.instead.of.arrow", (Object[])new Object[0]), new LocalQuickFix[]{new JSFunctionExpressionToArrowFunctionQuickFix(node)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionInspection$1", "visitJSFunctionExpression"));
            }
        };
        if (jSElementVisitor == null) {
            JSFunctionExpressionToArrowFunctionInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    public static boolean hasThisReferences(@NotNull JSFunction function) {
        if (function == null) {
            JSFunctionExpressionToArrowFunctionInspection.$$$reportNull$$$0(3);
        }
        final Ref ref = new Ref((Object)Boolean.FALSE);
        function.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

            @Override
            protected boolean skipLambdas() {
                return true;
            }

            public void visitJSThisExpression(JSThisExpression node) {
                ref.set((Object)Boolean.TRUE);
                this.stopWalking();
            }
        });
        return Boolean.TRUE.equals(ref.get());
    }

    private static boolean isRecursiveCall(@NotNull String innerName, @NotNull PsiElement element) {
        if (innerName == null) {
            JSFunctionExpressionToArrowFunctionInspection.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSFunctionExpressionToArrowFunctionInspection.$$$reportNull$$$0(5);
        }
        return element instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)element, innerName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasThisReferences";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

