/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexedFilesFilterProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaScriptIndex
implements Disposable {
    public static final Key<Boolean> SKIP_STUB_CREATION = Key.create((String)"js.skip.stub.creation");
    public static final FileBasedIndex.InputFilter ourIndexedFilesFilter = new FileBasedIndex.FileTypeSpecificInputFilter(){
        private final int JS_SPECIFIC_FILESIZE_LIMIT = StringUtil.parseInt((String)System.getProperty("idea.js.max.intellisense.filesize"), (int)8192) << 10;
        private final int MAX_JS_FILESIZE_LIMIT = Math.max(FileUtilRt.getUserFileSizeLimit(), this.JS_SPECIFIC_FILESIZE_LIMIT);
        private final int MAX_DTS_FILESIZE_LIMIT = FileUtilRt.getUserContentLoadLimit();

        public boolean acceptInput(@NotNull VirtualFile file2) {
            if (file2 == null) {
                1.$$$reportNull$$$0(0);
            }
            FileType fileType = file2.getFileType();
            if (!JavaScriptIndex.getFileTypesToIndexJS().contains(fileType)) {
                return false;
            }
            if (fileType == HtmlFileType.INSTANCE && file2.getFileSystem().getProtocol().equals("jar")) {
                return false;
            }
            String name = file2.getName();
            int cacheIndex = name.indexOf(".cache.");
            if (cacheIndex != -1 && name.endsWith(".js")) {
                boolean justHexDigits = cacheIndex > 0;
                for (int i = 0; i < cacheIndex && justHexDigits; ++i) {
                    justHexDigits = StringUtil.isHexDigit((char)name.charAt(i));
                }
                if (justHexDigits) {
                    return false;
                }
            }
            if (this.isMinifiedCopy(file2)) {
                return false;
            }
            if (Boolean.TRUE.equals(file2.getUserData(SKIP_STUB_CREATION))) {
                return false;
            }
            if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file2, (long)PersistentFSConstants.getMaxIntellisenseFileSize()) && JSMinifiedFileUtil.isFileContentMinified(file2)) {
                return false;
            }
            if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file2, (long)this.getLimitByFile(file2))) {
                return false;
            }
            for (JSIndexedFilesFilterProvider filter : JSIndexedFilesFilterProvider.EP_NAME.getExtensionList()) {
                if (filter.acceptInput(file2)) continue;
                return false;
            }
            return true;
        }

        private int getLimitByFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (TypeScriptUtil.isDefinitionFile(file2)) {
                return this.MAX_DTS_FILESIZE_LIMIT;
            }
            return this.MAX_JS_FILESIZE_LIMIT;
        }

        private boolean isMinifiedCopy(@NotNull VirtualFile file2) {
            String devName;
            String name;
            if (file2 == null) {
                1.$$$reportNull$$$0(2);
            }
            return !StringUtil.equals((CharSequence)(name = file2.getName()), (CharSequence)(devName = JSLibraryUtil.getDevVersionLocation(name))) && file2.getParent() != null && file2.getParent().findChild(devName) != null;
        }

        public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
            if (fileTypeSink == null) {
                1.$$$reportNull$$$0(3);
            }
            for (FileType ft : JavaScriptIndex.getFileTypesToIndexJS()) {
                fileTypeSink.consume((Object)ft);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypeSink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/index/JavaScriptIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptInput";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLimitByFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMinifiedCopy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerFileTypesUsedForIndexing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final String ECMASCRIPT_JS2 = "ECMAScript.js2";
    private static final int BASE_VERSION = 171;
    private static final int COMPUTED_TOTAL_VERSION = FrameworkIndexingHandler.computeTotalVersion(171);
    private final PsiModificationTracker myModificationTracker;
    private ScriptingLibraryManager myLibraryManager;
    private final Lock myCachesReadLock;
    private final Lock myCachesWriteLock;
    private final Map<GlobalSearchScope, Map<String, PsiElement>> myTopLevelResolveResult;
    private volatile long myModificationStamp;
    private final Project myProject;
    private static final NotNullLazyValue<Set<FileType>> ourFileTypesToIndexJS = NotNullLazyValue.createValue(() -> {
        HashSet<Object> fileTypesForJSCompletion = new HashSet<Object>();
        fileTypesForJSCompletion.add(HtmlFileType.INSTANCE);
        for (FileType type : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            Language language;
            if (!(type instanceof LanguageFileType) || !(language = ((LanguageFileType)type).getLanguage()).isKindOf((Language)JavascriptLanguage.INSTANCE) && !language.isKindOf((Language)HTMLLanguage.INSTANCE) && (!(language instanceof TemplateLanguage) || LanguageParserDefinitions.INSTANCE.forLanguage(language) == null)) continue;
            fileTypesForJSCompletion.add(type);
        }
        return fileTypesForJSCompletion;
    });

    @NotNull
    public static Set<FileType> getFileTypesToIndexJS() {
        Set set = (Set)ourFileTypesToIndexJS.getValue();
        if (set == null) {
            JavaScriptIndex.$$$reportNull$$$0(0);
        }
        return set;
    }

    public JavaScriptIndex(Project project, PsiManager psiManager, JSLibraryManager libraryManager) {
        ReentrantReadWriteLock ourLock = new ReentrantReadWriteLock();
        this.myCachesReadLock = ourLock.readLock();
        this.myCachesWriteLock = ourLock.writeLock();
        this.myTopLevelResolveResult = new THashMap();
        this.myProject = project;
        this.myLibraryManager = libraryManager;
        this.myModificationTracker = psiManager.getModificationTracker();
    }

    public static int getVersionStatic() {
        return COMPUTED_TOTAL_VERSION;
    }

    public static boolean isAcceptableFile(VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && ourIndexedFilesFilter.acceptInput(fileOrDir);
    }

    private void doClear(long modificationCount) {
        this.myCachesWriteLock.lock();
        this.myLibraryManager = (ScriptingLibraryManager)ServiceManager.getService((Project)this.myProject, JSLibraryManager.class);
        this.myLibraryManager.clearCaches();
        try {
            this.myTopLevelResolveResult.clear();
            this.myModificationStamp = modificationCount;
        }
        finally {
            this.myCachesWriteLock.unlock();
        }
    }

    public void dispose() {
        this.clear();
    }

    public static JavaScriptIndex getInstance(Project project) {
        return (JavaScriptIndex)project.getComponent(JavaScriptIndex.class);
    }

    public void clear() {
        this.doClear(this.myModificationTracker.getModificationCount());
    }

    public NavigationItem[] getFileByName(String name, boolean includeNonProjectItems) {
        return FilenameIndex.getFilesByName((Project)this.myProject, (String)name, (GlobalSearchScope)this.getCollectScope(includeNonProjectItems));
    }

    private GlobalSearchScope getCollectScope(boolean includeNonProjectItems) {
        return includeNonProjectItems ? JSResolveUtil.getJavaScriptSymbolsResolveScope(this.myProject) : ProjectScope.getContentScope((Project)this.myProject);
    }

    public final Project getProject() {
        return this.myProject;
    }

    public String[] getSymbolNames() {
        HashSet symbolNames = new HashSet();
        symbolNames.addAll(StubIndex.getInstance().getAllKeys(JSSymbolIndex2.KEY, this.myProject));
        symbolNames.addAll(StubIndex.getInstance().getAllKeys(JSNameIndex.KEY, this.myProject));
        return ArrayUtilRt.toStringArray(symbolNames);
    }

    @NotNull
    public NavigationItem[] getSymbolsByName(String name, boolean includeNonProjectItems) {
        NavigationItem[] navigationItemArray = this.processSymbols(name, includeNonProjectItems, false);
        if (navigationItemArray == null) {
            JavaScriptIndex.$$$reportNull$$$0(1);
        }
        return navigationItemArray;
    }

    @NotNull
    private NavigationItem[] processSymbols(String name, boolean includeNonProjectItems, boolean justClasses) {
        GlobalSearchScope scope = this.getCollectScope(includeNonProjectItems);
        Collection<JSPsiElementBase> symbolNavItems = JSClassResolver.findElementsByNameIncludingImplicit(name, scope, justClasses);
        if (!justClasses) {
            Collection<JSQualifiedNamedElement> qualified = JSResolveUtil.findElementsByName(name, this.myProject, scope);
            Iterator<JSQualifiedNamedElement> q = qualified.iterator();
            while (q.hasNext()) {
                JSQualifiedNamedElement element = q.next();
                if (JavaScriptIndex.isFromSwc(element)) continue;
                q.remove();
            }
            symbolNavItems.addAll(qualified);
        }
        NavigationItem[] navigationItemArray = symbolNavItems.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        if (navigationItemArray == null) {
            JavaScriptIndex.$$$reportNull$$$0(2);
        }
        return navigationItemArray;
    }

    private static boolean isFromSwc(JSQualifiedNamedElement element) {
        return element.getContainingFile().getVirtualFile().getName().endsWith(".swf");
    }

    public NavigationItem[] getClassByName(String name, boolean includeNonProjectItems) {
        return this.processSymbols(name, includeNonProjectItems, true);
    }

    public static String intern(String name) {
        return RecentStringHolder.ourSerializationManager.internString(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rememberTopLevelClassElement(String link, GlobalSearchScope scope, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaScriptIndex.$$$reportNull$$$0(3);
        }
        this.myCachesWriteLock.lock();
        try {
            Map map = this.myTopLevelResolveResult.get(scope);
            if (map == null) {
                map = ContainerUtil.createSoftValueMap();
                this.myTopLevelResolveResult.put(scope, map);
            }
            map.put(link, psiElement);
        }
        finally {
            this.myCachesWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiElement recallClass(String link, GlobalSearchScope scope) {
        if (this.invalidateIfNeeded()) {
            return null;
        }
        try {
            this.myCachesReadLock.lock();
            Map<String, PsiElement> map = this.myTopLevelResolveResult.get(scope);
            if (map != null) {
                PsiElement psiElement = map.get(link);
                return psiElement;
            }
        }
        finally {
            this.myCachesReadLock.unlock();
        }
        return null;
    }

    boolean invalidateIfNeeded() {
        long count = this.myModificationTracker.getModificationCount();
        if (this.myModificationStamp != count) {
            this.doClear(count);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JavaScriptIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesToIndexJS";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolsByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processSymbols";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JavaScriptIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rememberTopLevelClassElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RecentStringHolder {
        private static final SerializationManager ourSerializationManager = SerializationManager.getInstance();

        private RecentStringHolder() {
        }
    }
}

