/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLocalTypeEvaluator {
    private final boolean mySkipExpressionsHavingStubs;
    private final boolean myAddCodeBasedTypes;
    private final boolean mySkipObjectLiterals;

    private JSLocalTypeEvaluator(boolean skipExpressionsHavingStubs, boolean addCodeBasedTypes, boolean skipObjectLiterals) {
        this.myAddCodeBasedTypes = addCodeBasedTypes;
        this.mySkipExpressionsHavingStubs = skipExpressionsHavingStubs;
        this.mySkipObjectLiterals = skipObjectLiterals;
    }

    @Nullable
    @Contract(value="null, _ -> !null")
    public static JSType evaluateTypeLocally(@Nullable JSExpression expression, boolean skipExpressionsHavingStubs) {
        return JSLocalTypeEvaluator.evaluateTypeLocally(expression, skipExpressionsHavingStubs, false);
    }

    @Nullable
    @Contract(value="null, _, _ -> !null")
    public static JSType evaluateTypeLocally(@Nullable JSExpression expression, boolean skipExpressionsHavingStubs, boolean addCodeBasedTypes) {
        return new JSLocalTypeEvaluator(skipExpressionsHavingStubs, addCodeBasedTypes, skipExpressionsHavingStubs).evaluate(expression);
    }

    @Nullable
    @Contract(value="null, _, _, _ -> !null")
    public static JSType evaluateTypeLocally(@Nullable JSExpression expression, boolean skipExpressionsHavingStubs, boolean addCodeBasedTypes, boolean skipObjectLiterals) {
        return new JSLocalTypeEvaluator(skipExpressionsHavingStubs, addCodeBasedTypes, skipObjectLiterals).evaluate(expression);
    }

    @Nullable
    public static JSType evaluateReturnedTypeLocally(@NotNull JSFunction function) {
        JSBlockStatement block;
        JSStatement lastStatement;
        if (function == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(0);
        }
        JSStatement jSStatement = lastStatement = (block = function.getBlock()) == null ? null : (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)block.getLastChild(), JSStatement.class);
        if (lastStatement instanceof JSReturnStatement) {
            JSExpression returnExpression = ((JSReturnStatement)lastStatement).getExpression();
            return JSLocalTypeEvaluator.evaluateTypeLocally(returnExpression, false);
        }
        return null;
    }

    @Nullable
    private JSType evaluate(@Nullable JSExpression expression) {
        JSNamespace result2;
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true);
        if (JSSymbolUtil.isLiteralOrLiteralWithSign(expression)) {
            return JSTypeEvaluator.getTypeFromConstant(expression);
        }
        if (expression instanceof JSArrayLiteralExpression) {
            List types2 = ContainerUtil.newSmartList();
            for (JSExpression element : StreamEx.of((Stream)((JSArrayLiteralExpression)expression).getExpressionStream())) {
                JSType locallyEvaluatedType = this.evaluate(element);
                if (locallyEvaluatedType == null) {
                    return null;
                }
                types2.add(locallyEvaluatedType);
                if (types2.size() <= 5) continue;
                return null;
            }
            if (types2.size() > 1) {
                boolean allEquivalent = true;
                JSType firstType = (JSType)types2.get(0);
                for (int i = 1; i < types2.size(); ++i) {
                    if (firstType.isEquivalentTo((JSType)types2.get(i), new ProcessingContext(), false)) continue;
                    allEquivalent = false;
                    break;
                }
                if (allEquivalent) {
                    return new JSArrayTypeImpl(firstType, typeSource);
                }
            }
            return JSTupleTypeImpl.createTupleType(typeSource, types2, false, -1, false);
        }
        if (expression instanceof JSObjectLiteralExpression && !this.mySkipObjectLiterals) {
            JSProperty[] properties = ((JSObjectLiteralExpression)expression).getProperties();
            ArrayList<JSRecordTypeImpl.PropertySignatureImpl> members = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(properties.length);
            for (JSProperty property : properties) {
                if (!property.canBeLocallyEvaluated()) {
                    return null;
                }
                String name = property.getName();
                if (name == null) continue;
                JSType type = this.evaluate(property.getValue());
                if (type == null) {
                    return null;
                }
                members.add(new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)property).isConst(), (PsiElement)property));
            }
            return new JSFreshObjectLiteralTypeImpl(typeSource, members);
        }
        if (expression instanceof JSConditionalExpression) {
            JSType thenType = this.evaluate(((JSConditionalExpression)expression).getThen());
            JSType elseType = this.evaluate(((JSConditionalExpression)expression).getElse());
            SmartList types3 = new SmartList();
            ContainerUtil.addAllNotNull((Collection)types3, (Object[])new JSType[]{thenType, elseType});
            if (!types3.isEmpty()) {
                if (types3.size() == 1) {
                    return ((JSType)types3.get(0)).copyWithStrict(false);
                }
                boolean isStrictType = types3.size() == 2 && ((JSType)types3.get(0)).isSourceStrict() && ((JSType)types3.get(1)).isSourceStrict();
                JSTypeSource commonTypeSource = isStrictType ? typeSource : JSTypeSourceFactory.copyTypeSource(typeSource, isStrictType);
                return JSCompositeTypeImpl.getCommonType((Collection<? extends JSType>)types3, commonTypeSource, false);
            }
        } else {
            if (expression instanceof JSParenthesizedExpression) {
                return this.evaluate(((JSParenthesizedExpression)expression).getInnerExpression());
            }
            if (expression instanceof JSAssignmentExpression) {
                return this.evaluate(((JSAssignmentExpression)expression).getROperand());
            }
            if (expression instanceof JSIndexedPropertyAccessExpression) {
                JSExpression qualifier = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
                JSType qualifierType = this.evaluate(qualifier);
                if (qualifierType != null) {
                    JSType argumentType = this.evaluate(((JSIndexedPropertyAccessExpression)expression).getIndexExpression());
                    return new JSApplyIndexedAccessType(qualifierType, argumentType, typeSource);
                }
            } else if (expression == null) {
                return new JSUndefinedType(typeSource);
            }
        }
        if (this.myAddCodeBasedTypes) {
            String referenceName;
            if (expression instanceof JSNewExpression) {
                JSType innerType;
                JSExpression methodExpression = ((JSNewExpression)expression).getMethodExpression();
                Object object = innerType = methodExpression != null ? this.evaluate(methodExpression) : JSAnyType.get((PsiElement)expression, false);
                if (innerType != null && !(innerType instanceof JSAnyType)) {
                    return new JSApplyNewType(innerType, typeSource);
                }
                return null;
            }
            if (expression instanceof JSCallExpression) {
                JSRequireCallExpressionType requireCallType = CommonJSUtil.getTypeIfRequireCall((JSCallExpression)expression);
                if (requireCallType != null) {
                    return requireCallType;
                }
                JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
                JSType argumentTypes = this.getApplyCallType((JSCallLikeExpression)((JSCallExpression)expression), methodExpression, typeSource);
                if (argumentTypes != null) {
                    return argumentTypes;
                }
            } else if (expression instanceof ES6TaggedTemplateExpression) {
                JSExpression tag = ((ES6TaggedTemplateExpression)expression).getTag();
                JSType argumentTypes = this.getApplyCallType((JSCallLikeExpression)expression, tag, typeSource);
                if (argumentTypes != null) {
                    return argumentTypes;
                }
            } else if (expression instanceof JSReferenceExpression && (referenceName = ((JSReferenceExpression)expression).getReferenceName()) != null) {
                JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
                if (qualifier == null) {
                    JSType predefinedType = JSSymbolUtil.getPredefinedType((JSReferenceExpression)expression);
                    if (predefinedType != null) {
                        return predefinedType;
                    }
                    return new JSReferenceType(referenceName, typeSource);
                }
                JSType qualifierType = this.evaluate(qualifier);
                if (qualifierType != null) {
                    return new JSQualifiedReferenceType(referenceName, qualifierType, typeSource);
                }
            }
        }
        if ((!this.mySkipExpressionsHavingStubs || expression instanceof JSNewExpression) && (result2 = JSSymbolUtil.evaluateNamespaceLocally(expression)) != null) {
            return result2;
        }
        return null;
    }

    @Nullable
    private JSType getApplyCallType(@NotNull JSCallLikeExpression expression, @Nullable JSExpression methodExpression, @NotNull JSTypeSource typeSource) {
        JSType innerType;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (typeSource == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(2);
        }
        JSType jSType = innerType = methodExpression != null ? this.evaluate(methodExpression) : null;
        if (innerType != null && !(innerType instanceof JSAnyType)) {
            List argumentTypes = ContainerUtil.map((Object[])expression.getArguments(), this::evaluate);
            return new JSApplyCallType(innerType, argumentTypes, typeSource);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateReturnedTypeLocally";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplyCallType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

